/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AbstractAuxiliaryCacheEventLogging;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.LateralCacheMonitor;
import org.apache.jcs.auxiliary.lateral.ZombieLateralCacheService;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IZombie;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStats;

public class LateralCache
extends AbstractAuxiliaryCacheEventLogging {
    private static final long serialVersionUID = 6274549256562382782L;
    private static final Log log = LogFactory.getLog((Class)LateralCache.class);
    private ILateralCacheAttributes cattr;
    final String cacheName;
    private ILateralCacheService lateral;
    private LateralCacheMonitor monitor;

    public LateralCache(ILateralCacheAttributes cattr, ILateralCacheService lateral, LateralCacheMonitor monitor) {
        this.cacheName = cattr.getCacheName();
        this.cattr = cattr;
        this.lateral = lateral;
        this.monitor = monitor;
    }

    protected LateralCache(ILateralCacheAttributes cattr) {
        this.cacheName = cattr.getCacheName();
        this.cattr = cattr;
    }

    protected void processUpdate(ICacheElement ce) throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("update: lateral = [" + this.lateral + "], " + "LateralCacheInfo.listenerId = " + LateralCacheInfo.listenerId));
            }
            this.lateral.update(ce, LateralCacheInfo.listenerId);
        }
        catch (NullPointerException npe) {
            log.error((Object)("Failure updating lateral. lateral = " + this.lateral), (Throwable)npe);
            this.handleException(npe, "Failed to put [" + ce.getKey() + "] to " + ce.getCacheName());
            return;
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to put [" + ce.getKey() + "] to " + ce.getCacheName());
        }
    }

    protected ICacheElement processGet(Serializable key) throws IOException {
        ICacheElement obj = null;
        if (this.cattr.getPutOnlyMode()) {
            return null;
        }
        try {
            obj = this.lateral.get(this.cacheName, key);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.handleException(e, "Failed to get [" + key + "] from " + this.cattr.getCacheName());
        }
        return obj;
    }

    protected Map processGetMatching(String pattern) throws IOException {
        Map elements = new HashMap();
        if (this.cattr.getPutOnlyMode()) {
            return Collections.EMPTY_MAP;
        }
        try {
            elements = this.lateral.getMatching(this.cacheName, pattern);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.handleException(e, "Failed to getMatching [" + pattern + "] from " + this.cattr.getCacheName());
        }
        return elements;
    }

    protected Map processGetMultiple(Set keys) throws IOException {
        HashMap<Serializable, ICacheElement> elements = new HashMap<Serializable, ICacheElement>();
        if (keys != null && !keys.isEmpty()) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Serializable key = (Serializable)iterator.next();
                ICacheElement element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    public Set getGroupKeys(String groupName) {
        return this.lateral.getGroupKeys(this.cacheName, groupName);
    }

    protected boolean processRemove(Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing key:" + key));
        }
        try {
            this.lateral.remove(this.cacheName, key, LateralCacheInfo.listenerId);
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to remove " + key + " from " + this.cattr.getCacheName());
        }
        return false;
    }

    protected void processRemoveAll() throws IOException {
        try {
            this.lateral.removeAll(this.cacheName, LateralCacheInfo.listenerId);
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to remove all from " + this.cattr.getCacheName());
        }
    }

    protected void processDispose() throws IOException {
        log.debug((Object)"Disposing of lateral cache");
        try {
            this.lateral.dispose(this.cattr.getCacheName());
        }
        catch (Exception ex) {
            log.error((Object)"Couldn't dispose", (Throwable)ex);
            this.handleException(ex, "Failed to dispose " + this.cattr.getCacheName());
        }
    }

    public int getStatus() {
        return this.lateral instanceof IZombie ? 3 : 1;
    }

    public int getSize() {
        return 0;
    }

    public int getCacheType() {
        return 3;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    private void handleException(Exception ex, String msg) throws IOException {
        log.error((Object)("Disabling lateral cache due to error " + msg), (Throwable)ex);
        this.lateral = new ZombieLateralCacheService();
        this.monitor.notifyError();
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    public void fixCache(ILateralCacheService lateral) {
        if (lateral != null) {
            this.lateral = lateral;
        } else {
            log.warn((Object)"Fix cache called with null lateral.");
        }
    }

    public String getStats() {
        return "";
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cattr;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n LateralCache ");
        buf.append("\n Cache Name [" + this.cattr.getCacheName() + "]");
        buf.append("\n cattr =  [" + this.cattr + "]");
        return buf.toString();
    }

    public String getEventLoggingExtraInfo() {
        return null;
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("LateralCache");
        return stats;
    }
}

