/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp.discovery;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoveryReceiver;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoverySender;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoverySenderThread;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.behavior.IShutdownObservable;
import org.apache.jcs.engine.behavior.IShutdownObserver;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.jcs.utils.net.HostNameUtil;

public class UDPDiscoveryService
implements IShutdownObserver {
    private static final Log log = LogFactory.getLog((Class)UDPDiscoveryService.class);
    private static ClockDaemon senderDaemon;
    private Thread udpReceiverThread;
    private UDPDiscoveryReceiver receiver;
    private Map facades = new HashMap();
    private UDPDiscoverySenderThread sender = null;
    private String hostAddress = "unknown";
    private String discoveryAddress;
    private int discoveryPort;
    private int servicePort;
    private ITCPLateralCacheAttributes tcpLateralCacheAttributes;
    protected ICacheEventLogger cacheEventLogger;
    protected IElementSerializer elementSerializer;

    public UDPDiscoveryService(String discoveryAddress, int discoveryPort, int servicePort, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        ((IShutdownObservable)((Object)cacheMgr)).registerShutdownObserver(this);
        this.setDiscoveryAddress(discoveryAddress);
        this.setDiscoveryPort(discoveryPort);
        this.setServicePort(servicePort);
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
        try {
            this.hostAddress = HostNameUtil.getLocalHostAddress();
        }
        catch (UnknownHostException e1) {
            log.error((Object)"Couldn't get localhost address", (Throwable)e1);
        }
        try {
            this.receiver = new UDPDiscoveryReceiver(this, this.getDiscoveryAddress(), this.getDiscoveryPort(), cacheMgr, cacheEventLogger, elementSerializer);
            this.udpReceiverThread = new Thread(this.receiver);
            this.udpReceiverThread.setDaemon(true);
            this.udpReceiverThread.start();
        }
        catch (Exception e) {
            log.error((Object)("Problem creating UDPDiscoveryReceiver, address [" + this.getDiscoveryAddress() + "] port [" + this.getDiscoveryPort() + "] we won't be able to find any other caches"), (Throwable)e);
        }
        if (senderDaemon == null) {
            senderDaemon = new ClockDaemon();
            senderDaemon.setThreadFactory((ThreadFactory)new MyThreadFactory());
        }
        this.sender = new UDPDiscoverySenderThread(this.getDiscoveryAddress(), this.getDiscoveryPort(), this.hostAddress, this.getServicePort(), this.getCacheNames());
        senderDaemon.executePeriodically(30000L, (Runnable)this.sender, false);
    }

    public synchronized boolean addNoWaitFacade(LateralCacheNoWaitFacade facade, String cacheName) {
        boolean isNew = !this.facades.containsKey(cacheName);
        this.facades.put(cacheName, facade);
        if (isNew && this.sender != null) {
            this.sender.setCacheNames(this.getCacheNames());
        }
        return isNew;
    }

    protected void addNoWait(LateralCacheNoWait noWait) {
        LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(noWait.getCacheName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got facade for " + noWait.getCacheName() + " = " + facade));
        }
        if (facade != null) {
            boolean isNew = facade.addNoWait(noWait);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Called addNoWait, isNew = " + isNew));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Different nodes are configured differently.  Region [" + noWait.getCacheName() + "] is not configured to use the lateral cache."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRequestBroadcast() {
        UDPDiscoverySender sender = null;
        try {
            sender = new UDPDiscoverySender(this.getDiscoveryAddress(), this.getDiscoveryPort());
            sender.passiveBroadcast(this.hostAddress, this.getServicePort(), this.getCacheNames());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Called sender to issue a passive broadcast");
            }
        }
        catch (Exception e) {
            log.error((Object)("Problem calling the UDP Discovery Sender. address [" + this.getDiscoveryAddress() + "] port [" + this.getDiscoveryPort() + "]"), (Throwable)e);
        }
        finally {
            try {
                if (sender != null) {
                    sender.destroy();
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem closing Passive Broadcast sender, while servicing a request broadcast.", (Throwable)e);
            }
        }
    }

    protected ArrayList getCacheNames() {
        ArrayList<String> keys = new ArrayList<String>();
        Set keySet = this.facades.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            keys.add(key);
        }
        return keys;
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Shutting down UDP discovery service receiver.");
        }
        try {
            this.receiver.shutdown();
            this.udpReceiverThread.interrupt();
        }
        catch (Exception e) {
            log.error((Object)"Problem interrupting UDP receiver thread.");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Shutting down UDP discovery service sender.");
        }
        try {
            senderDaemon.shutDown();
        }
        catch (Exception e) {
            log.error((Object)"Problem shutting down UDP sender.");
        }
    }

    protected void setDiscoveryAddress(String discoveryAddress) {
        this.discoveryAddress = discoveryAddress;
    }

    protected String getDiscoveryAddress() {
        return this.discoveryAddress;
    }

    protected void setDiscoveryPort(int discoveryPort) {
        this.discoveryPort = discoveryPort;
    }

    protected int getDiscoveryPort() {
        return this.discoveryPort;
    }

    protected void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    protected int getServicePort() {
        return this.servicePort;
    }

    public void setTcpLateralCacheAttributes(ITCPLateralCacheAttributes tCPLateralCacheAttributes) {
        this.tcpLateralCacheAttributes = tCPLateralCacheAttributes;
    }

    public ITCPLateralCacheAttributes getTcpLateralCacheAttributes() {
        return this.tcpLateralCacheAttributes;
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            String oldName = t.getName();
            t.setName("JCS-UDPDiscoveryService-" + oldName);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

