/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.AbstractRemoteAuxiliaryCache;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheMonitor;

public class RemoteHttpCache
extends AbstractRemoteAuxiliaryCache {
    private static final long serialVersionUID = -5329231850422826461L;
    private static final Log log = LogFactory.getLog((Class)RemoteHttpCache.class);
    private RemoteHttpCacheAttributes remoteHttpCacheAttributes;

    public RemoteHttpCache(RemoteHttpCacheAttributes remoteHttpCacheAttributes, IRemoteCacheService remote, IRemoteCacheListener listener) {
        super(remoteHttpCacheAttributes, remote, listener);
        this.setRemoteHttpCacheAttributes(remoteHttpCacheAttributes);
    }

    protected void handleException(Exception ex, String msg, String eventName) throws IOException {
        if (!(this.getRemoteCacheService() instanceof ZombieRemoteCacheService)) {
            String message = "Disabling remote cache due to error: " + msg;
            this.logError(this.cacheName, "", message);
            log.error((Object)message, (Throwable)ex);
            this.setRemoteCacheService(new ZombieRemoteCacheService(this.getRemoteCacheAttributes().getZombieQueueMaxSize()));
            RemoteHttpCacheMonitor.getInstance().notifyError(this);
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    public String getEventLoggingExtraInfo() {
        return null;
    }

    public void setRemoteHttpCacheAttributes(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        this.remoteHttpCacheAttributes = remoteHttpCacheAttributes;
    }

    public RemoteHttpCacheAttributes getRemoteHttpCacheAttributes() {
        return this.remoteHttpCacheAttributes;
    }
}

