/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheDispatcher;
import org.apache.jcs.auxiliary.remote.http.client.AbstractHttpClient;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.jcs.auxiliary.remote.util.RemoteCacheRequestUtil;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.jcs.utils.serialization.StandardSerializer;

public class RemoteHttpCacheDispatcher
extends AbstractHttpClient
implements IRemoteCacheDispatcher {
    private static final String PARAMETER_REQUEST_TYPE = "RequestType";
    private static final String PARAMETER_KEY = "Key";
    private static final String PARAMETER_CACHE_NAME = "CacheName";
    private static final Log log = LogFactory.getLog((Class)RemoteHttpCacheDispatcher.class);
    private StandardSerializer serializer = new StandardSerializer();

    public RemoteHttpCacheDispatcher(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        super(remoteHttpCacheAttributes);
    }

    public RemoteCacheResponse dispatchRequest(RemoteCacheRequest remoteCacheRequest) throws IOException {
        try {
            byte[] requestAsByteArray = this.serializer.serialize(remoteCacheRequest);
            String url = this.addParameters(remoteCacheRequest, this.getRemoteHttpCacheAttributes().getUrl());
            byte[] responseAsByteArray = this.processRequest(requestAsByteArray, url);
            RemoteCacheResponse remoteCacheResponse = null;
            try {
                remoteCacheResponse = (RemoteCacheResponse)this.serializer.deSerialize(responseAsByteArray);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Couldn't deserialize the response.", (Throwable)e);
            }
            return remoteCacheResponse;
        }
        catch (Exception e) {
            log.error((Object)"Problem dispatching request.", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    protected byte[] processRequest(byte[] requestAsByteArray, String url) throws IOException, HttpException {
        PostMethod post = new PostMethod(url);
        ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(requestAsByteArray);
        post.setRequestEntity((RequestEntity)requestEntity);
        this.doWebserviceCall((HttpMethod)post);
        byte[] response = post.getResponseBody();
        return response;
    }

    protected String addParameters(RemoteCacheRequest remoteCacheRequest, String baseUrl) {
        StringBuffer url = new StringBuffer(baseUrl);
        try {
            if (baseUrl != null && baseUrl.indexOf("?") == -1) {
                url.append("?");
            } else {
                url.append("&");
            }
            if (this.getRemoteHttpCacheAttributes().isIncludeCacheNameAsParameter() && remoteCacheRequest.getCacheName() != null) {
                url.append("CacheName=" + URLEncoder.encode(remoteCacheRequest.getCacheName(), "UTF-8"));
            }
            if (this.getRemoteHttpCacheAttributes().isIncludeKeysAndPatternsAsParameter()) {
                String keyValue = "";
                switch (remoteCacheRequest.getRequestType()) {
                    case 1: {
                        keyValue = remoteCacheRequest.getKey() + "";
                        break;
                    }
                    case 5: {
                        keyValue = remoteCacheRequest.getKey() + "";
                        break;
                    }
                    case 3: {
                        keyValue = remoteCacheRequest.getPattern();
                        break;
                    }
                    case 2: {
                        keyValue = remoteCacheRequest.getKeySet() + "";
                        break;
                    }
                    case 7: {
                        keyValue = remoteCacheRequest.getKey() + "";
                        break;
                    }
                    case 4: {
                        keyValue = remoteCacheRequest.getCacheElement().getKey() + "";
                        break;
                    }
                }
                String encodedKeyValue = URLEncoder.encode(keyValue, "UTF-8");
                url.append("&Key=" + encodedKeyValue);
            }
            if (this.getRemoteHttpCacheAttributes().isIncludeRequestTypeasAsParameter()) {
                url.append("&RequestType=" + URLEncoder.encode(RemoteCacheRequestUtil.getRequestTypeName(remoteCacheRequest.getRequestType()), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Couldn't encode URL.", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Url: " + url.toString()));
        }
        return url.toString();
    }

    public HttpState preProcessWebserviceCall(HttpMethod post) throws IOException {
        return null;
    }

    public void postProcessWebserviceCall(HttpMethod post, HttpState httpState) throws IOException {
    }
}

