/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.auth.AuthUser;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.LoginMgmt;
import com.fe.db.AbstractTeamOrgDB;
import com.fe.db.InfrastructureDB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.directwebremoting.WebContextFactory;

public abstract class Authenticated {
    private HttpServletRequest request = null;
    public static String REMOTE_IP = "$clientIpAddress";
    private Logger log = Logger.getLogger(Authenticated.class);
    public static final String SESS_AUTHENTICATED_USER = "$$AuthenticatedUserObj";

    protected Authenticated(boolean bl) {
    }

    public Authenticated() throws Exception {
        if (this.getAuthenticatedUser() == null) {
            throw new Exception("SESSION LOGGED OUT: Access denied for this request");
        }
        try {
            if (this.getRequest().getSession().getAttribute(REMOTE_IP) == null) {
                this.getRequest().getSession().setAttribute(REMOTE_IP, (Object)this.getRequest().getRemoteAddr());
            }
        }
        catch (Exception exception) {
            this.log.error((Object)"Error while setting up session variable remote-ipaddress ");
        }
    }

    public Authenticated(HttpServletRequest httpServletRequest) throws Exception {
        this.request = httpServletRequest;
        if (this.getAuthenticatedUser() == null) {
            throw new Exception("Requested user is not authenticated ");
        }
        try {
            if (this.getRequest().getSession().getAttribute(REMOTE_IP) == null) {
                this.getRequest().getSession().setAttribute(REMOTE_IP, (Object)this.getRequest().getRemoteAddr());
            }
        }
        catch (Exception exception) {
            this.log.error((Object)"Error while setting up session variable remote-ipaddress ");
        }
    }

    public Map replacePermissions(Map<String, String> map) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("X", "rwx");
        hashMap.put("S", "rwx");
        hashMap.put("B", "rwx");
        hashMap.put("C", "rwx");
        hashMap.put("U", "rx");
        hashMap.put("N", "r");
        hashMap.put("M", "rwx");
        for (String string : map.keySet()) {
            map.put(string, (String)hashMap.get(map.get(string)));
        }
        return map;
    }

    protected AuthUser getAuthenticatedUserObj(AbstractTeamOrgDB abstractTeamOrgDB) throws Exception {
        String string = this.getAuthenticatedUser();
        AuthUser authUser = (AuthUser)this.getRequest().getSession().getAttribute(SESS_AUTHENTICATED_USER);
        InfrastructureDB infrastructureDB = InfrastructureDB.getInfrastructureDB();
        try {
            if (authUser == null) {
                infrastructureDB.connectDB(Config.getString("db_infrastructure_name"));
                Map map = infrastructureDB.getThemes4Users(string);
                Map map2 = this.replacePermissions(map);
                authUser = new AuthUser(string);
                for (String string2 : map2.keySet()) {
                    String string3 = (String)map2.get(string2);
                    if (string3 != null && string3.trim().equalsIgnoreCase("rwx")) {
                        authUser.getRwx().add(string2);
                    }
                    if (string3 != null && string3.trim().equalsIgnoreCase("rx")) {
                        authUser.getRx().add(string2);
                    }
                    if (string3 == null || !string3.trim().equalsIgnoreCase("r")) continue;
                    authUser.getR().add(string2);
                }
                this.getRequest().getSession().setAttribute(SESS_AUTHENTICATED_USER, (Object)authUser);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            infrastructureDB.closeDB();
        }
        return authUser;
    }

    protected String getAuthenticatedUser() throws Exception {
        String string = (String)this.getRequest().getSession().getAttribute("session^logged^user");
        String string2 = null;
        this.log.debug((Object)("getAuthenticatedUser ----ky:" + string));
        if (string == null || string != null && string.equals("")) {
            String string3 = null;
            String string4 = null;
            Cookie[] cookieArray = this.getRequest().getCookies();
            if (cookieArray != null) {
                for (int i = 0; i < cookieArray.length; ++i) {
                    if (cookieArray[i].getName().equals("4eprevuser") && cookieArray[i].getValue() != null) {
                        string3 = cookieArray[i].getValue();
                    }
                    if (!cookieArray[i].getName().equals("4esessionuid") || cookieArray[i].getValue() == null) continue;
                    string4 = cookieArray[i].getValue();
                }
            }
            if (string3 != null && string4 != null) {
                LoginMgmt loginMgmt = new LoginMgmt();
                this.log.debug((Object)("user:" + string3 + " pwd:" + string4));
                Map map = loginMgmt.validateRememberedUser(string3, string4);
                this.log.debug((Object)("dt:" + map));
                if (((Boolean)map.get("success")).booleanValue()) {
                    string2 = string3;
                }
            }
        } else {
            string2 = string;
        }
        this.log.debug((Object)("getAuthenticatedUser ----@@@ky:" + string));
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        return string2;
    }

    protected void setRequest(HttpServletRequest httpServletRequest) throws Exception {
        this.request = httpServletRequest;
    }

    protected HttpServletRequest getRequest() throws Exception {
        return this.request == null && WebContextFactory.get() != null ? WebContextFactory.get().getHttpServletRequest() : this.request;
    }

    protected Map getThemeHirarchy(List<String> list, AbstractTeamOrgDB abstractTeamOrgDB) throws Exception {
        InfrastructureDB infrastructureDB = InfrastructureDB.getInfrastructureDB();
        try {
            Map map;
            String string = "";
            HashMap hashMap = new HashMap();
            for (String object2 : list) {
                string = string + (string.equals("") ? "'" + object2 + "'" : ",'" + object2 + "'");
            }
            infrastructureDB.connectDB(Config.getString("db_infrastructure_name"));
            Map map2 = !string.equals("") ? infrastructureDB.getTeamOrg(string, this.getPermissionHierarchy()) : new HashMap();
            Map map3 = map = this.replacePermissions(map2);
            return map3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            exception.printStackTrace();
            throw exception;
        }
        finally {
            infrastructureDB.closeDB();
        }
    }

    private List getPermissionHierarchy() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("X");
        arrayList.add("M");
        arrayList.add("S");
        arrayList.add("B");
        arrayList.add("C");
        arrayList.add("U");
        arrayList.add("N");
        return arrayList;
    }
}

