/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.ValueObject;
import com.fe.client.Authenticated;
import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.SchedulerMgmt;
import com.fe.db.IExecDB;
import com.fe.db.RFunctionDB;
import com.fe.db.SchedulerDB;
import com.fe.svn.SVNIExecXML;
import com.fe.util.ParseXML4ChildStrategy;
import com.fe.util.ParseXMLPlaceHolder;
import com.fe.util.WikiRFunctionManual;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNLogEntry;

public class IExecMgmt
extends Authenticated {
    private HttpServletRequest request = null;
    private Logger log = Logger.getLogger(IExecMgmt.class);
    private static String dbname = Config.getString("db_iexec");
    private static String dbnameTradingRef = Config.getString("db_tradingRef");
    private static String STRATEGY_ID = "function_id";
    private static String LOCK_DURATION = "duration";
    private static String USER = "user";
    private static JCS lockcache = null;

    protected IExecMgmt(HttpServletRequest httpServletRequest, boolean bl) throws Exception {
        super(bl);
        this.setRequest(httpServletRequest);
    }

    public IExecMgmt() throws Exception {
    }

    public IExecMgmt(HttpServletRequest httpServletRequest) throws Exception {
        super(httpServletRequest);
    }

    private static String getDBName() {
        return dbname;
    }

    private static String getDBNameTradingRef() {
        return dbnameTradingRef;
    }

    public Map getTreeViewData() throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            iExecDB.connectDB(IExecMgmt.getDBName());
            List list = iExecDB.listGroups();
            List list2 = iExecDB.listFolders();
            List list3 = iExecDB.listStrategies();
            Vector<ValueObject> vector = new Vector<ValueObject>();
            HashMap hashMap2 = new HashMap();
            for (Map map : list) {
                ValueObject valueObject = new ValueObject();
                valueObject.setKey((String)map.get("group_uid"));
                valueObject.setValue((String)map.get("group_name"));
                vector.add(valueObject);
                hashMap2.put(map.get("group_uid"), map.get("color_code"));
            }
            hashMap.put("folders", list2);
            hashMap.put("groups", vector);
            hashMap.put("group_colors", hashMap2);
            hashMap.put("strategies", list3);
            HashMap<String, Object> hashMap3 = hashMap;
            return hashMap3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    public Map getStrategy(int n, boolean bl) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            iExecDB.connectDB(IExecMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = iExecDB.getStrategy(n);
            Map map2 = this.getDataBundle4Strategy(map, iExecDB, schedulerDB);
            String string = (String)((Map)map2.get("data")).get("lockedby");
            String string2 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            if (!bl) {
                if (string == null || string.equals("") || string.equalsIgnoreCase(string2)) {
                    this.refreshCache(n, 300L, string2);
                }
            } else {
                map2.put("readonly", true);
            }
            Map map3 = map2;
            return map3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
            schedulerDB.closeDB();
        }
    }

    public Map getPlaceHolder(int n, String string) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Cloneable cloneable;
            iExecDB.connectDB(IExecMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = iExecDB.getStrategy(n);
            String string2 = (String)map.get("strategy_name");
            Map map2 = this.getDataBundle4Strategy(map, iExecDB, schedulerDB);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Map map3 = iExecDB.getParameterValues(string2, string);
            String string3 = (String)map.get("parent_strategy");
            this.log.debug((Object)("parent_name:" + string3));
            ParseXMLPlaceHolder parseXMLPlaceHolder = null;
            ParseXMLPlaceHolder parseXMLPlaceHolder2 = null;
            if (map2.get("content") != null) {
                if (string3 != null && !string3.trim().equals("")) {
                    parseXMLPlaceHolder = new ParseXML4ChildStrategy((String)map2.get("content"));
                } else {
                    parseXMLPlaceHolder = new ParseXMLPlaceHolder((String)map2.get("content"));
                    parseXMLPlaceHolder2 = new ParseXML4ChildStrategy((String)map2.get("content"));
                }
            }
            if (parseXMLPlaceHolder2 != null) {
                cloneable = parseXMLPlaceHolder.getAttributePH();
                cloneable.addAll(parseXMLPlaceHolder2.getAttributePH());
                hashMap.put("att_ph", cloneable);
                hashMap.put("att_ph_c", parseXMLPlaceHolder2.getAttributePH());
                Vector vector = parseXMLPlaceHolder.getElementPH();
                vector.addAll(parseXMLPlaceHolder2.getElementPH());
                hashMap.put("ele_ph", vector);
                hashMap.put("ele_ph_c", parseXMLPlaceHolder2.getElementPH());
            } else {
                hashMap.put("att_ph", parseXMLPlaceHolder.getAttributePH());
                hashMap.put("ele_ph", parseXMLPlaceHolder.getElementPH());
            }
            hashMap.put("ph_data", map3);
            cloneable = hashMap;
            return cloneable;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
            schedulerDB.closeDB();
        }
    }

    public String getMyParsedXML(String string, String string2) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Object object;
            Map map;
            iExecDB.connectDB(IExecMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map2 = iExecDB.getStrategy(string);
            String string3 = string;
            boolean bl = false;
            if (map2.get("parent_strategy") != null && !((String)map2.get("parent_strategy")).equals("")) {
                string3 = (String)map2.get("parent_strategy");
                bl = true;
            }
            Map map3 = this.getDataBundle4Strategy(map2, iExecDB, schedulerDB);
            String string4 = "";
            Map map4 = iExecDB.getParameterValues(string3, string2);
            Pattern pattern = Pattern.compile("^([A-Za-z\\s]+)([0-9]+)S$", 32);
            String string5 = null;
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                string5 = matcher.group(1);
            }
            if (string5 != null) {
                map = iExecDB.getParameterValues(string3, string5);
                this.mergeMaps(map4, map);
            }
            map = iExecDB.getParameterValues(string3, "Default");
            this.mergeMaps(map4, map);
            this.log.debug((Object)("parent_s:" + string3));
            if (map3.get("content") != null) {
                object = new ParseXMLPlaceHolder((String)map3.get("content"));
                string4 = ((ParseXMLPlaceHolder)object).parse(map4);
            }
            this.log.debug((Object)("xml:" + string4));
            if (bl) {
                Map map5;
                object = iExecDB.getParameterValues(string, string2);
                this.log.debug((Object)("strategy_name:" + string + " contract:" + string2));
                this.log.debug((Object)("st2:" + object));
                if (string5 != null) {
                    map5 = iExecDB.getParameterValues(string, string5);
                    this.mergeMaps((Map)object, map5);
                }
                map5 = iExecDB.getParameterValues(string, "Default");
                this.mergeMaps((Map)object, map5);
                this.mergeMaps((Map)object, map4);
                ParseXML4ChildStrategy parseXML4ChildStrategy = new ParseXML4ChildStrategy(string4);
                string4 = parseXML4ChildStrategy.parse((Map)object);
            }
            object = string4;
            return object;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
            schedulerDB.closeDB();
        }
    }

    private void mergeMaps(Map map, Map map2) {
        if (map2 != null && map != null) {
            for (String string : map2.keySet()) {
                if (map.containsKey(string) && (!map.containsKey(string) || !((String)map.get(string)).equals(""))) continue;
                map.put(string, map2.get(string));
            }
        }
    }

    public boolean deleteStrategy(int n) throws Exception {
        Map map = this.createFolderIfNotExist("Trash", "trash");
        int n2 = (Integer)map.get("folder_id");
        this.moveFile2Folder(n, n2);
        return true;
    }

    private Map createFolderIfNotExist(String string, String string2) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            File file;
            String string3 = Config.getString("iexec_source_folder");
            String string4 = string3 + string;
            iExecDB.connectDB(IExecMgmt.getDBName());
            int n = iExecDB.getFolderID(string);
            if (n <= 0) {
                n = iExecDB.createFolder(string, string2);
            }
            if (!(file = new File(string4)).isDirectory() && !file.isFile()) {
                file.mkdirs();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List list = iExecDB.listOfFolders(string2);
            hashMap.put("folders", list);
            hashMap.put("folder_id", n);
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + string + " group_id:" + string2);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            StringWriter stringWriter = new StringWriter();
            char[] cArray = new char[1024];
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((n = bufferedReader.read(cArray)) != -1) {
                    ((Writer)stringWriter).write(cArray, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            return ((Object)stringWriter).toString();
        }
        return "";
    }

    public Map createChildStrategy(int n, String string) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            iExecDB.connectDB(IExecMgmt.getDBName());
            Map map = iExecDB.getStrategy(string);
            if (map != null && map.size() > 0) {
                throw new Exception("ERROR: Strategy name: " + string + " alerady existing, please try different name");
            }
            Map map2 = iExecDB.getStrategy(n);
            String string2 = (String)map2.get("strategy_name");
            int n2 = iExecDB.createChildStrategy(string2, string);
            Map map3 = iExecDB.getStrategy(n2);
            String string3 = "";
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("content", string3);
            hashMap2.put("data", map3);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map3);
            hashMap.put("strategies", vector);
            boolean bl = true;
            hashMap.put("strategy_data", this.getStrategy(n2, !bl));
            HashMap<String, Object> hashMap3 = hashMap;
            return hashMap3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "parent_st_id:" + n + " fname:" + string + "  strategy_name:" + string);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    public Map createStrategy(String string, String string2, String string3) throws Exception {
        String string4 = Config.getString("iexec_source_folder");
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            Object object;
            Object object2;
            Object object3;
            if (string3 == null || string3 != null && string3.trim().equalsIgnoreCase("")) {
                object3 = "";
                try {
                    object2 = Config.class.getResourceAsStream("strategy_new_template.xml");
                    object3 = this.convertStreamToString((InputStream)object2);
                }
                catch (Exception exception) {
                    this.log.error((Object)"Error while reading strategy_new_template.xml file");
                }
                if (object3 != null && !((String)object3).trim().equals("")) {
                    this.log.debug((Object)"template found ");
                    object2 = new ParseXMLPlaceHolder((String)object3);
                    object = new HashMap();
                    ((HashMap)object).put("name", string2);
                    string3 = ((ParseXMLPlaceHolder)object2).parse((Map)object);
                }
            }
            object3 = new HashMap();
            iExecDB.connectDB(IExecMgmt.getDBName());
            object2 = iExecDB.getStrategy(string2);
            if (object2 != null && object2.size() > 0) {
                throw new Exception("ERROR: Strategy name: " + string2 + " alerady existing, please try different name");
            }
            object = iExecDB.getFolderName(Integer.parseInt(string));
            String string5 = string2 + new SVNIExecXML().getExtension();
            String string6 = string4 + (object != null ? (String)object + File.separator : "") + string5;
            if (!new File(string6).isFile()) {
                this.createContent(string6, string3);
            }
            int n = iExecDB.createStrategy(Integer.parseInt(string), string2, string5);
            this.synchrnizeSVN(string2, string3, null, n);
            Map map = iExecDB.getStrategy(n);
            String string7 = (String)map.get("file_name");
            string7 = string4 + (object != null ? (String)object + File.separator : "") + string7;
            String string8 = this.getContent(string7);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("content", string8);
            hashMap.put("data", map);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map);
            ((HashMap)object3).put("strategies", vector);
            boolean bl = true;
            ((HashMap)object3).put("strategy_data", this.getStrategy(n, !bl));
            Object object4 = object3;
            return object4;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + string + " fname:" + string2 + "  script:" + string3);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    public Map modifyStrategy(int n, String string, String string2) throws Exception {
        String string3 = Config.getString("iexec_source_folder");
        IExecDB iExecDB = IExecDB.getIExcecDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap hashMap = new HashMap();
            iExecDB.connectDB(IExecMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string4 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            String string5 = this.getLockedBy(n, schedulerDB, iExecDB);
            if (string5 != null && !string4.equalsIgnoreCase(this.getLockedBy(n, schedulerDB, iExecDB))) {
                throw new Exception("This function is currently locked by user " + string5);
            }
            Map map = iExecDB.getStrategy(n);
            String string6 = (String)map.get("strategy_name");
            String string7 = string6 + new SVNIExecXML().getExtension();
            String string8 = "";
            try {
                string8 = iExecDB.getFolderName((Integer)map.get("folder_id"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string9 = string3 + (string8 != null ? string8 + File.separator : "") + string7;
            this.createContent(string9, string);
            this.synchrnizeSVN(string6, string, string2, n);
            Map map2 = iExecDB.getStrategy(n);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map2);
            hashMap.put("rfunctions", vector);
            HashMap hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            iExecDB.closeDB();
        }
    }

    public Map createFolder(String string, String string2) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            File file;
            String string3 = Config.getString("iexec_source_folder");
            String string4 = string3 + string;
            if (new File(string4).isDirectory() || new File(string4).isFile()) {
                throw new Exception("Folder already existing folder failed....Path:" + string4);
            }
            iExecDB.connectDB(IExecMgmt.getDBName());
            int n = iExecDB.getFolderID(string);
            if (n <= 0) {
                n = iExecDB.createFolder(string, string2);
            }
            if (!(file = new File(string4)).isDirectory() && !file.isFile()) {
                file.mkdirs();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List list = iExecDB.listOfFolders(string2);
            hashMap.put("folders", list);
            hashMap.put("folder_id", n);
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + string + " group_id:" + string2);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    public boolean moveFolder(int n, String string) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            iExecDB.connectDB(IExecMgmt.getDBName());
            iExecDB.moveFolder(n, string);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + n + " new_group_id:" + string);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    public boolean moveFile2Folder(int n, int n2) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            String string = Config.getString("iexec_source_folder");
            iExecDB.connectDB(IExecMgmt.getDBName());
            Map map = iExecDB.getStrategy(n);
            String string2 = null;
            try {
                string2 = iExecDB.getFolderName((Integer)map.get("folder_id"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = iExecDB.getFolderName(n2);
            String string4 = (String)map.get("file_name");
            if (string2.equals(string3)) {
                throw new Exception("Moving failed! source and destination are the same..");
            }
            String string5 = string + (string2 != null ? string2 + File.separator : "") + string4;
            String string6 = string + (string3 != null ? string3 + File.separator : "") + string4;
            this.log.debug((Object)("old file:" + string5 + " new :" + string6));
            if (!new File(string5).renameTo(new File(string6))) {
                throw new Exception("Moving failed failed....");
            }
            this.log.debug((Object)("new folder_id:" + n + " function_id:" + n2));
            iExecDB.updateStrategyFolder(n, n2);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "function_id:" + n + " new_folder_id:" + n2);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    public void setGroupOrder(Vector vector) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            iExecDB.connectDB(IExecMgmt.getDBName());
            iExecDB.setGroupOrder(vector);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    public boolean updateParameter(ArrayList<Map> arrayList, String string) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            iExecDB.connectDB(IExecMgmt.getDBName());
            iExecDB.addParameters(arrayList, string);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    private boolean synchrnizeSVN(String string, String string2, String string3, int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Map map;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string4 = Config.getString("svn_user_r");
            String string5 = Config.getString("svn_pwd_r");
            SchedulerMgmt schedulerMgmt = new SchedulerMgmt(this.getRequest());
            String string6 = schedulerMgmt.getPeerIPAddress();
            String string7 = this.getAuthenticatedUser();
            if (string3 == null) {
                string3 = "created on IP:" + string6 + " By:" + string7;
            }
            if ((map = schedulerDB.getSVNUser4WikiUser(string7)) != null && map.get("svn_username") != null && map.get("svn_password") != null) {
                string4 = (String)map.get("svn_username");
                string5 = (String)map.get("svn_password");
            }
            SVNIExecXML sVNIExecXML = new SVNIExecXML(string4, string5);
            sVNIExecXML.syncFile(string, string2, string3);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.log.error((Object)"Error while committing function into SVN ");
            throw exception;
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {
                this.log.error((Object)("error while cloing db:" + exception.getMessage()));
            }
        }
    }

    public boolean removeContract(String string, String string2) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            iExecDB.connectDB(IExecMgmt.getDBName());
            iExecDB.removeContract(string, string2);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    public Vector getSVNLogs(String string) throws Exception {
        SVNIExecXML sVNIExecXML = new SVNIExecXML();
        TreeMap treeMap = new TreeMap();
        Vector<SVNLogEntry> vector = sVNIExecXML.log(string);
        if (vector != null && vector.size() > 0) {
            for (SVNLogEntry sVNLogEntry : vector) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");
                ValueObject valueObject = new ValueObject();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("author", sVNLogEntry.getAuthor());
                hashMap.put("date", simpleDateFormat.format(sVNLogEntry.getDate()));
                hashMap.put("message", sVNLogEntry.getMessage());
                hashMap.put("revision", sVNLogEntry.getRevision());
                hashMap.put("function_name", string);
                String string2 = null;
                if (sVNLogEntry.getChangedPaths() != null) {
                    for (String string3 : sVNLogEntry.getChangedPaths().keySet()) {
                        string3 = string3.substring(string3.lastIndexOf("/") + 1);
                        string2 = string2 == null ? string3 : string2 + "," + string3;
                    }
                    if (string2 != null) {
                        hashMap.put("path", string2);
                    }
                }
                treeMap.put(sVNLogEntry.getRevision(), hashMap);
            }
            return new Vector(treeMap.descendingMap().values());
        }
        return null;
    }

    public String getScriptRev(String string, String string2, boolean bl, String string3) throws Exception {
        try {
            SVNIExecXML sVNIExecXML = new SVNIExecXML();
            String string4 = null;
            string4 = bl ? sVNIExecXML.getScript(string, Long.parseLong(string2), string3) : sVNIExecXML.getWhatChanged(string, Long.parseLong(string2));
            if (string4 == null) {
                string4 = "No changes were made or first revision of this function";
            }
            return string4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private Map getDataBundle4Strategy(Map map, IExecDB iExecDB, SchedulerDB schedulerDB) throws Exception {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = Config.getString("iexec_source_folder");
        String string2 = "";
        if (map.get("folder_id") != null) {
            string2 = iExecDB.getFolderName((Integer)map.get("folder_id"));
        }
        int n = (Integer)map.get("id");
        String string3 = (String)map.get("strategy_name");
        String string4 = (String)map.get("strategy_name");
        String string5 = (String)map.get("parent_strategy");
        boolean bl = false;
        if (string5 != null && !string5.equals("")) {
            object = iExecDB.getStrategy(string5);
            string3 = (String)object.get("strategy_name");
            string2 = iExecDB.getFolderName((Integer)object.get("folder_id"));
            bl = true;
        }
        object = string3 + new SVNIExecXML().getExtension();
        this.log.debug((Object)("getDataBundle4Strategy() child_strategy:" + bl));
        this.log.debug((Object)("getDataBundle4Strategy() content strategy_name:" + string3));
        this.log.debug((Object)("getDataBundle4Strategy() Content:" + (String)object));
        Object object2 = object;
        object = string + (string2 != null ? string2 + File.separator : "") + (String)object;
        String string6 = "";
        this.log.debug((Object)("getDataBundle4Strategy() filepath:" + (String)object));
        try {
            string6 = this.getContent((String)object);
        }
        catch (Exception exception) {
            string6 = "<error>" + exception.getMessage() + "</error>";
        }
        String string7 = (String)map.get("lockedby");
        if (string7 == null || string7 != null && string7.equals("")) {
            map.put("lockedby", this.getLockedBy(n, schedulerDB, iExecDB));
        }
        ParseXMLPlaceHolder parseXMLPlaceHolder = bl ? new ParseXML4ChildStrategy(string6) : new ParseXMLPlaceHolder(string6);
        hashMap.put("element_ph_found", false);
        if (parseXMLPlaceHolder.getElementPH().size() > 0) {
            hashMap.put("element_ph_found", true);
        }
        hashMap.put("content", string6);
        hashMap.put("data", map);
        hashMap.put("isParent", iExecDB.isParent(string4));
        try {
            hashMap.put("isAuthorized", new SchedulerMgmt(this.getRequest()).isAuthorizedUser(schedulerDB));
            hashMap.put("authorizedUser", new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector<String> vector = new Vector<String>();
        vector.add("Default");
        Vector vector2 = iExecDB.getUniqueContracts(string4);
        if (vector2.contains("Default")) {
            vector2.remove("Default");
        }
        vector.addAll(vector2);
        hashMap.put("contracts", vector);
        return hashMap;
    }

    public boolean renameStrategy(String string, int n) throws Exception {
        String string2 = Config.getString("iexec_source_folder");
        IExecDB iExecDB = IExecDB.getIExcecDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            iExecDB.connectDB(IExecMgmt.getDBName());
            Map map = iExecDB.getStrategy(string);
            if (map != null && map.size() > 0) {
                throw new Exception("ERROR: Strategy name: " + string + " alerady existing, please try different name");
            }
            HashMap hashMap = new HashMap();
            iExecDB.connectDB(IExecMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string3 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            String string4 = this.getLockedBy(n, schedulerDB, iExecDB);
            if (string4 != null && !string3.equalsIgnoreCase(this.getLockedBy(n, schedulerDB, iExecDB))) {
                throw new Exception("This strategy is currently locked by user " + string4);
            }
            Map map2 = iExecDB.getStrategy(n);
            String string5 = (String)map2.get("parent_strategy");
            if (string5 != null && !string5.trim().equals("")) {
                iExecDB.renameStrategy(n, string, null);
            } else {
                String string6 = string + new SVNIExecXML().getExtension();
                String string7 = (String)map2.get("file_name");
                String string8 = (String)map2.get("strategy_name");
                String string9 = "";
                try {
                    string9 = iExecDB.getFolderName((Integer)map2.get("folder_id"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string10 = string2 + (string9 != null ? string9 + File.separator : "") + string7;
                String string11 = string2 + (string9 != null ? string9 + File.separator : "") + string6;
                Map map3 = this.getDataBundle4Strategy(map2, iExecDB, schedulerDB);
                String string12 = (String)map3.get("content");
                String string13 = "";
                string13 = "Renamed  " + string8 + "  --> " + string;
                this.log.debug((Object)("old file:" + string10 + " new :" + string11));
                if (!new File(string10).renameTo(new File(string11))) {
                    throw new Exception("Renaming failed");
                }
                iExecDB.renameParentStrategy(n, string, string6, string8);
                Map map4 = iExecDB.getStrategy(n);
                this.renameSVN(string8, string, string12, string13, n);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            iExecDB.closeDB();
        }
    }

    private boolean renameSVN(String string, String string2, String string3, String string4, int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Map map;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string5 = Config.getString("svn_user_r");
            String string6 = Config.getString("svn_pwd_r");
            SchedulerMgmt schedulerMgmt = new SchedulerMgmt(this.getRequest());
            String string7 = schedulerMgmt.getPeerIPAddress();
            String string8 = this.getAuthenticatedUser();
            if (string4 == null) {
                string4 = "created on IP:" + string7 + " By:" + string8;
            }
            if ((map = schedulerDB.getSVNUser4WikiUser(string8)) != null && map.get("svn_username") != null && map.get("svn_password") != null) {
                string5 = (String)map.get("svn_username");
                string6 = (String)map.get("svn_password");
            }
            SVNIExecXML sVNIExecXML = new SVNIExecXML(string5, string6);
            sVNIExecXML.renameFile(string, string2, string3, string4);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.log.error((Object)"Error while committing function into SVN ");
            throw exception;
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {
                this.log.error((Object)("error while cloing db:" + exception.getMessage()));
            }
        }
    }

    private void createContent(String string, String string2) throws Exception {
        BufferedWriter bufferedWriter = null;
        File file = new File(string);
        bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string2);
        ((Writer)bufferedWriter).close();
    }

    public String getStrategyWiki(String string) throws Exception {
        WikiRFunctionManual wikiRFunctionManual = new WikiRFunctionManual();
        String string2 = wikiRFunctionManual.getWikiHTML(string);
        return string2;
    }

    public Vector getStrategies(String string, boolean bl) throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            Vector<Map> vector2 = new Vector<Map>();
            iExecDB.connectDB(IExecMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector3 = iExecDB.getStrategies(vector);
            String string2 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            for (Map map : vector3) {
                Map map2 = this.getDataBundle4Strategy(map, iExecDB, schedulerDB);
                int n = (Integer)map.get("id");
                String string3 = (String)((Map)map2.get("data")).get("lockedby");
                if (!bl) {
                    if (string3 == null || string3.equals("") || string3.equalsIgnoreCase(string2)) {
                        this.refreshCache(n, 300L, string2);
                    }
                } else {
                    map2.put("readonly", true);
                }
                vector2.add(map2);
            }
            Vector<Map> vector4 = vector2;
            return vector4;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            iExecDB.closeDB();
            schedulerDB.closeDB();
        }
    }

    public Map getContractComm() throws Exception {
        IExecDB iExecDB = IExecDB.getIExcecDB();
        try {
            iExecDB.connectDB(IExecMgmt.getDBName());
            TreeMap<String, Cloneable> treeMap = new TreeMap<String, Cloneable>();
            TreeMap<String, Vector> treeMap2 = new TreeMap<String, Vector>();
            Vector<String> vector = iExecDB.getCommodityTree(IExecMgmt.getDBNameTradingRef());
            Vector vector2 = iExecDB.getContractTree(IExecMgmt.getDBName(), IExecMgmt.getDBNameTradingRef());
            for (Map map : vector2) {
                Vector vector3;
                String string = (String)map.get("commodity");
                String string2 = (String)map.get("contract");
                if (treeMap2.get(string) == null) {
                    vector3 = new Vector();
                    treeMap2.put(string.trim(), vector3);
                } else {
                    vector3 = (Vector)treeMap2.get(string);
                }
                vector3.add(string + (vector3.size() + 1) + "S");
            }
            treeMap.put("commodity", vector);
            treeMap.put("contract", treeMap2);
            TreeMap<String, Cloneable> treeMap3 = treeMap;
            return treeMap3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            iExecDB.closeDB();
        }
    }

    private String getContent(String string) throws Exception {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2 + "\r\n";
        }
        bufferedReader.close();
        return string3;
    }

    public boolean lockFunction(int n, long l) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            rFunctionDB.connectDB(IExecMgmt.getDBName());
            String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            if (l > 0L) {
                this.refreshCache(n, l, string);
            } else {
                rFunctionDB.updateLock(n, string);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            rFunctionDB.closeDB();
        }
    }

    public boolean unLockStrategyFromCache(int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            this.removeLockFromCache(n, string);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    private void removeLockFromCache(int n, String string) throws Exception {
        String string2 = string + n;
        if (IExecMgmt.getLockCache().get((Object)string2) != null) {
            IExecMgmt.getLockCache().remove((Object)string2);
        }
    }

    private String getLockedBy(int n, SchedulerDB schedulerDB, IExecDB iExecDB) throws Exception {
        Object object;
        Map map = iExecDB.getStrategy(n);
        String string = null;
        if (map.get("lockedby") != null) {
            string = (String)map.get("lockedby");
        } else {
            object = IExecMgmt.getLockCache().getMatching("^[A-Za-z0-9]+$");
            if (object != null) {
                for (String string2 : object.keySet()) {
                    Map map2 = (Map)object.get(string2);
                    int n2 = (Integer)map2.get(STRATEGY_ID);
                    long l = (Long)map2.get(LOCK_DURATION);
                    String string3 = (String)map2.get(USER);
                    if (n2 != n) continue;
                    string = string3;
                }
            }
        }
        object = string;
        return object;
    }

    private void refreshCache(int n, long l, String string) throws Exception {
        String string2 = string + n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(STRATEGY_ID, n);
        hashMap.put(LOCK_DURATION, l);
        hashMap.put(USER, string);
        IElementAttributes iElementAttributes = IExecMgmt.getLockCache().getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds(l);
        if (IExecMgmt.getLockCache().get((Object)string2) != null) {
            IExecMgmt.getLockCache().remove((Object)string2);
        }
        IExecMgmt.getLockCache().put((Object)string2, hashMap, iElementAttributes);
    }

    private static JCS getLockCache() throws Exception {
        if (lockcache == null) {
            lockcache = JCS.getInstance((String)IExecMgmt.class.getName());
        }
        return lockcache;
    }
}

