/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.client.AdminMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.data.CommodityInfo;
import com.fe.data.FlexiField;
import com.fe.db.BBSyncDB;
import com.fe.db.FlexiFieldDB;
import com.fe.db.ReferenceDB;
import com.fe.lucene.LuceneCrawler;
import com.fe.lucene.TickerIndexRecord;
import com.fe.lucene.TokenCollectorFactory;
import com.fe.util.BeanUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.directwebremoting.WebContextFactory;

public class ReferenceMgmt {
    private HttpServletRequest request = null;
    private Logger log = Logger.getLogger(ReferenceMgmt.class);
    private static String dbname = Config.getString("db_bbsync_name");

    public ReferenceMgmt(HttpServletRequest httpServletRequest) throws Exception {
        this.request = httpServletRequest;
        String string = (String)this.getRequest().getSession().getAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE);
        if (string == null || string.equalsIgnoreCase("true")) {
            // empty if block
        }
    }

    public ReferenceMgmt() throws Exception {
        String string = (String)this.getRequest().getSession().getAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE);
        if (string == null || string.equalsIgnoreCase("true")) {
            // empty if block
        }
    }

    public Map getCommodities() throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            Map map = referenceDB.getComContracts();
            referenceDB.closeDB();
            return map;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public static String getDBName() {
        return dbname;
    }

    public Vector listAllMapping() throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            Vector vector = referenceDB.getFieldMapping();
            referenceDB.closeDB();
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Vector listAllSecMapping() throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            Vector vector = referenceDB.getSecFieldMapping();
            referenceDB.closeDB();
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Vector deleteMapping(int n) throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            referenceDB.deleteFieldMapping(n);
            Vector vector = referenceDB.getFieldMapping();
            referenceDB.closeDB();
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Vector deleteSecMapping(int n) throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            referenceDB.deleteSecFieldMapping(n);
            Vector vector = referenceDB.getSecFieldMapping();
            referenceDB.closeDB();
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Vector addMapping(String string, String string2) throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            referenceDB.addFieldMapping(string, string2);
            Vector vector = referenceDB.getFieldMapping();
            referenceDB.closeDB();
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Vector addSecMapping(String string, String string2) throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            referenceDB.addSecFieldMapping(string, string2);
            Vector vector = referenceDB.getSecFieldMapping();
            referenceDB.closeDB();
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean updateCommodityInfo(Map map) throws Exception {
        try {
            CommodityInfo commodityInfo = new CommodityInfo();
            new BeanUtil().convertPropertiesToBean(map, commodityInfo);
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            referenceDB.updateCommodity(commodityInfo);
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            exception.printStackTrace();
            throw exception;
        }
    }

    public Map getCommodityInfo(String string) throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            TreeMap<String, String> treeMap = referenceDB.getCommodityInfo(string);
            if (treeMap == null) {
                treeMap = new TreeMap<String, String>();
                treeMap.put("commodity", string);
            }
            this.log.error((Object)"getCommodityInfo() called");
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map removeScheduleTicker(int n, String string) throws Exception {
        try {
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            bBSyncDB.connectDB(ReferenceMgmt.getDBName());
            bBSyncDB.removeScheduleTicker(n, string);
            bBSyncDB.closeDB();
            boolean bl = true;
            return this.getTickerBBInfo(string, bl);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map getTickerBBInfo(String string, boolean bl) throws Exception {
        try {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            bBSyncDB.connectDB(ReferenceMgmt.getDBName());
            Vector vector = null;
            Map map = null;
            if (bl) {
                vector = referenceDB.getContractBBInfo(string);
                map = referenceDB.getContractInfo(string);
            } else {
                vector = referenceDB.getSecurityBBInfo(string);
                map = referenceDB.getSecurityInfo(string);
            }
            this.log.debug((Object)("cfield:" + vector));
            treeMap.put("contract", map);
            treeMap.put("contract_fields", vector);
            bBSyncDB.closeDB();
            referenceDB.closeDB();
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public void getBBSyncInfo4Contract(String string) throws Exception {
    }

    private HttpServletRequest getRequest() throws Exception {
        return this.request == null && WebContextFactory.get() != null ? WebContextFactory.get().getHttpServletRequest() : this.request;
    }

    public Map getFlexiFieldData(String string, String string2, String string3) throws Exception {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            FlexiFieldDB flexiFieldDB = FlexiFieldDB.getFlexiFieldDB();
            flexiFieldDB.connectDB(dbname);
            Map map = flexiFieldDB.getFlexiFieldData(string, string2, string3);
            List list = flexiFieldDB.getFlexiFields(string);
            hashMap.put("fields", list);
            hashMap.put("data", map);
            flexiFieldDB.closeDB();
            return hashMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean updateFFieldOrder(long[] lArray) throws Exception {
        try {
            HashMap hashMap = new HashMap();
            FlexiFieldDB flexiFieldDB = FlexiFieldDB.getFlexiFieldDB();
            flexiFieldDB.connectDB(dbname);
            for (int i = 0; i < lArray.length; ++i) {
                flexiFieldDB.updateFlexiFieldOrder(lArray[i], i);
            }
            flexiFieldDB.closeDB();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean saveFlexiFieldData(String string, String string2, String string3, Map map) throws Exception {
        try {
            FlexiFieldDB flexiFieldDB = FlexiFieldDB.getFlexiFieldDB();
            flexiFieldDB.connectDB(dbname);
            flexiFieldDB.saveFlexiFieldData(string, string2, string3, map);
            if (string.equalsIgnoreCase("security_flexi_data")) {
                this.indexSecurity(string3);
            }
            if (string.equalsIgnoreCase("commodity_flexi_data")) {
                this.indexCommodity(string3);
            }
            if (string.equalsIgnoreCase("fundamental_flexi_data")) {
                this.indexFundamentalTicker(string3);
            }
            flexiFieldDB.closeDB();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    private void indexSecurity(String string) throws Exception {
        TickerIndexRecord tickerIndexRecord = new TickerIndexRecord();
        tickerIndexRecord.setTablename(LuceneCrawler.INDEX_TABLE_SECURITY);
        if (TokenCollectorFactory.getTokenCollector(tickerIndexRecord) != null) {
            LuceneCrawler luceneCrawler = new LuceneCrawler(LuceneCrawler.INDEX_TABLE_SECURITY);
            luceneCrawler.index(string);
        }
    }

    private void indexCommodity(String string) throws Exception {
        TickerIndexRecord tickerIndexRecord = new TickerIndexRecord();
        tickerIndexRecord.setTablename(LuceneCrawler.INDEX_TABLE_COMMODITY);
        if (TokenCollectorFactory.getTokenCollector(tickerIndexRecord) != null) {
            LuceneCrawler luceneCrawler = new LuceneCrawler(LuceneCrawler.INDEX_TABLE_COMMODITY);
            luceneCrawler.index(string);
        }
    }

    private void indexFundamentalTicker(String string) throws Exception {
        TickerIndexRecord tickerIndexRecord = new TickerIndexRecord();
        tickerIndexRecord.setTablename(LuceneCrawler.INDEX_TABLE_FUNDAMENTAL_TICKR);
        if (TokenCollectorFactory.getTokenCollector(tickerIndexRecord) != null) {
            LuceneCrawler luceneCrawler = new LuceneCrawler(LuceneCrawler.INDEX_TABLE_FUNDAMENTAL_TICKR);
            luceneCrawler.index(string);
        }
    }

    public Map addUpdateField(FlexiField flexiField, String string, String string2, String string3) throws Exception {
        try {
            FlexiFieldDB flexiFieldDB = FlexiFieldDB.getFlexiFieldDB();
            flexiFieldDB.connectDB(dbname);
            if (flexiField.getId() > 0L) {
                flexiFieldDB.updateFlexiField(flexiField.getId(), flexiField);
            } else {
                flexiFieldDB.addFlexiField(flexiField);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Map map = flexiFieldDB.getFlexiFieldData(string, string2, string3);
            List list = flexiFieldDB.getFlexiFields(string);
            hashMap.put("fields", list);
            hashMap.put("data", map);
            flexiFieldDB.closeDB();
            return hashMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map deleteField(FlexiField flexiField, String string, String string2, String string3) throws Exception {
        try {
            FlexiFieldDB flexiFieldDB = FlexiFieldDB.getFlexiFieldDB();
            flexiFieldDB.connectDB(dbname);
            if (flexiField.getId() > 0L) {
                flexiFieldDB.deleteFlexiField(flexiField.getId());
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Map map = flexiFieldDB.getFlexiFieldData(string, string2, string3);
            List list = flexiFieldDB.getFlexiFields(string);
            hashMap.put("fields", list);
            hashMap.put("data", map);
            flexiFieldDB.closeDB();
            return hashMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }
}

