/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.WeatherMgmtAbstract;
import com.fe.db.SuperDB;
import com.fe.db.WeatherNewDB;
import java.util.Map;

public class WeatherNewMgmt
extends WeatherMgmtAbstract {
    private static String dbname = Config.getString("db_weather_new");
    private static String weatherworld = Config.getString("db_weather_world");
    private static String tablesuffix = "forecast";

    @Override
    protected String getDB() {
        return dbname;
    }

    protected String getWorldDB() {
        return weatherworld;
    }

    @Override
    protected String getTsuffix() {
        return tablesuffix;
    }

    public void saveLastGMap(int n, double d, double d2) throws Exception {
        WeatherNewDB weatherNewDB = new SuperDB().getWeatherNewDB(this.getWorldDB());
        try {
            weatherNewDB.connectDB(this.getWorldDB());
            weatherNewDB.saveLastGMap(weatherNewDB.connection(), n, d, d2);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            weatherNewDB.closeDB();
        }
    }

    public Map getLastGMap() throws Exception {
        WeatherNewDB weatherNewDB = new SuperDB().getWeatherNewDB(this.getWorldDB());
        try {
            Map map;
            weatherNewDB.connectDB(this.getWorldDB());
            Map map2 = map = weatherNewDB.getLastGMap(weatherNewDB.connection());
            return map2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            weatherNewDB.closeDB();
        }
    }

    private float round(double d, int n) {
        float f = (float)Math.pow(10.0, n);
        float f2 = Math.round(d *= (double)f);
        return f2 / f;
    }
}

