/*
 * Decompiled with CFR 0.152.
 */
package com.fe.migrate.historical;

import com.fe.Config;
import com.fe.client.MigrationMgmt;
import com.fe.db.ContractDB;
import com.fe.db.SuperDB;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class HistoricalData {
    protected MigrationMgmt clientGateway;
    private Vector data = new Vector();
    private String sheetname = null;
    private String commodity = null;
    protected boolean duplicateCheck = true;
    private ContractDB cdb = null;
    private String xlfile = null;
    private Logger log = Logger.getLogger(HistoricalData.class);

    public HistoricalData(MigrationMgmt migrationMgmt) {
        this.clientGateway = migrationMgmt;
    }

    public void setDuplicateCheck(boolean bl) {
        this.duplicateCheck = bl;
    }

    public void setSheetname(String string) {
        this.sheetname = string;
    }

    public String getSheetname() {
        return this.sheetname;
    }

    public abstract void startProcess(boolean var1) throws Exception;

    public abstract String getFolder() throws Exception;

    public abstract String getArchiveFolder() throws Exception;

    public abstract String getDB() throws Exception;

    public void createRecord(Connection connection, String string, Vector vector) throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalData.resolvedColNameNoTrim(this.getCommodity()) + "_" + HistoricalData.resolvedColName(string), this.getDB());
        contractDB.connectDB(this.getDB());
        if (this.duplicateCheck) {
            contractDB.updateRecords(connection, vector);
        } else {
            contractDB.addRecords(connection, vector);
        }
    }

    public void createTable(String string) throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalData.resolvedColNameNoTrim(this.getCommodity()) + "_" + HistoricalData.resolvedColName(string), this.getDB());
        contractDB.connectDB(this.getDB());
        contractDB.updateMasterTable(contractDB.connection(), this.getCommodity(), string);
        if (this.getDB().equals(Config.getString("db_strategy_name"))) {
            contractDB.createTable(contractDB.connection(), 8);
        } else {
            contractDB.createTable(contractDB.connection(), 8);
        }
        contractDB.closeDB();
    }

    public static String resolvedColName(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            string = string.trim();
            int n = 25;
            Pattern pattern = Pattern.compile("([^a-zA-z0-9])");
            string = string.replaceAll(" ", "_").toLowerCase();
            string = string.substring(0, (string = pattern.matcher(string).replaceAll("")).length() > n ? n : string.length());
            string2 = string.replaceAll(" ", "_").toLowerCase();
        }
        return string2;
    }

    public static String resolvedColNameNoTrim(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            int n = 25;
            Pattern pattern = Pattern.compile("([^a-zA-z0-9])");
            string = string.replaceAll(" ", "_").toLowerCase();
            string = string.substring(0, (string = pattern.matcher(string).replaceAll("")).length() > n ? n : string.length());
            string2 = string.replaceAll(" ", "_").toLowerCase();
        }
        return string2;
    }

    public File[] getFiles() throws Exception {
        return HistoricalData.getFiles(this.getFolder());
    }

    public static File[] getFiles(String string) throws Exception {
        File file = new File(string);
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".xls");
            }
        });
        return fileArray;
    }

    public String getCommodity() {
        return this.commodity;
    }

    public void setCommodity(String string) {
        this.commodity = string;
    }

    public void sheetsBegin(String string, String[] stringArray) throws Exception {
        this.log.debug((Object)"sheetbegin() called");
        this.xlfile = string;
        this.cdb = new SuperDB().getContractDB(null, this.getDB());
        this.cdb.connectDB(this.getDB());
        this.log.debug((Object)"sheetbegin() ended");
    }

    public void sheetsEnd() throws Exception {
        if (this.cdb != null) {
            this.cdb.closeDB();
        }
    }

    public boolean excecuteContinue(String string, Date date, Vector vector, int n) throws Exception {
        this.clientGateway.setMessageClientServe("Processing.....&nbsp;&nbsp;&nbsp;&nbsp;<small>File:<b>" + (this.xlfile != null ? this.xlfile : "") + "</b>&nbsp;&nbsp;&nbsp;&nbsp;Sheet:<b>" + string + "</b>&nbsp;&nbsp;&nbsp;&nbsp;Row:<b>" + n + "</b></small>");
        this.createRecord(this.cdb.connection(), string, vector);
        return true;
    }

    public boolean excecute(String string, String string2, Vector vector, int n) throws Exception {
        this.setCommodity(string);
        return this.excecute(string2, vector, n);
    }

    public boolean excecute(String string, Vector vector, int n) throws Exception {
        if (this.getSheetname() != null) {
            if (this.getSheetname().equalsIgnoreCase(string)) {
                this.createTable(string);
                return true;
            }
            return false;
        }
        this.createTable(string);
        return true;
    }
}

