/*
 * Decompiled with CFR 0.152.
 */
package com.fe.migrate.historical;

import com.fe.Config;
import com.fe.client.MigrationMgmt;
import com.fe.db.ContractDB;
import com.fe.db.SuperDB;
import com.fe.migrate.historical.HistoricalData;
import com.fe.xls.historical.XLSModelHistoricalReader;
import com.fe.xls.listener.HistoricalRowListener;
import com.fe.xls.listener.HistoricalStrategySheetListener;
import java.io.File;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class HistoricalModelData
extends HistoricalData
implements HistoricalRowListener,
HistoricalStrategySheetListener {
    public HistoricalModelData(MigrationMgmt migrationMgmt) {
        super(migrationMgmt);
    }

    @Override
    public void startProcess(boolean bl) throws Exception {
        this.setDuplicateCheck(bl);
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                XLSModelHistoricalReader xLSModelHistoricalReader = new XLSModelHistoricalReader(fileArray[i]);
                xLSModelHistoricalReader.processFile(this, this);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyy");
                String string = this.getArchiveFolder() + simpleDateFormat.format(new Date());
                if (!new File(string).exists()) {
                    new File(string).mkdirs();
                }
                fileArray[i].renameTo(new File(string + File.separator + fileArray[i].getName()));
            }
        } else {
            throw new Exception("No source file found");
        }
    }

    @Override
    public void createRecord(Connection connection, String string, Vector vector) throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalModelData.resolvedColNameNoTrim(this.getCommodity()) + "_" + HistoricalModelData.resolvedColName(string), null);
        if (this.duplicateCheck) {
            contractDB.updateSValRecords(connection, vector);
        } else {
            contractDB.addSValRecords(connection, vector);
        }
    }

    @Override
    public void createTable(String string) throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalModelData.resolvedColNameNoTrim(this.getCommodity()) + "_" + HistoricalModelData.resolvedColName(string), this.getDB());
        contractDB.connectDB(this.getDB());
        contractDB.updateMasterTable(contractDB.connection(), this.getCommodity(), string);
        contractDB.createSValTable(contractDB.connection(), 8);
        contractDB.closeDB();
    }

    @Override
    public String getFolder() throws Exception {
        return Config.getString("xls_model_historical_folder");
    }

    @Override
    public String getArchiveFolder() throws Exception {
        return Config.getString("xls_model_historical_archive");
    }

    @Override
    public String getDB() throws Exception {
        return Config.getString("db_model_name");
    }
}

