/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.protocol.RelayConfigAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Logger;

public class ConfigurationFactory {
    private static final Logger LOG = Logger.getLogger((String)ConfigurationFactory.class.getName());
    protected int bufferSize = 16384;
    static ConfigurationFactory factory = new ConfigurationFactory();
    protected File home = new File(".jxta");
    protected boolean tcp_incoming = true;
    protected int mcastPort = 1234;
    protected boolean mutlicastOn = true;
    protected boolean tcp_outgoing = true;
    protected PeerID peerid = IDFactory.newPeerID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID);
    protected boolean relayed = true;
    protected int httpPort = 9700;
    protected int tcpPort = 9701;
    protected int tcpStartPort = 9701;
    protected int tcpEndPort = 9799;
    protected String name = "unknown";
    protected URI rdvSeedingURI = null;
    protected URI relaySeedingURI = null;
    protected Set seedRendezvous = new HashSet();
    protected boolean useOnlyRendezvouSeeds = false;
    protected Set seedRelay = new HashSet();
    protected boolean useOnlyRelaySeeds = false;
    protected boolean rangeSet = true;
    protected String description = "Platform Config Advertisement created by : " + ConfigurationFactory.class.getName();
    protected Properties configProps = null;
    protected String debugLevel = "info";
    protected String principal = null;
    protected String password = null;
    public static final int EDGE = 0;
    public static final int RDV = 2;
    public static final int RELAY = 4;
    protected int mode = 0;

    public static void setMode(int n) {
        ConfigurationFactory.factory.mode = n;
    }

    private ConfigurationFactory() {
    }

    private static HTTPAdv createHttpAdv(int n, boolean bl, boolean bl2) {
        HTTPAdv hTTPAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((String)HTTPAdv.getAdvertisementType());
        hTTPAdv.setProtocol("http");
        hTTPAdv.setPort(n);
        hTTPAdv.setClientEnabled(bl2);
        hTTPAdv.setServerEnabled(bl);
        return hTTPAdv;
    }

    private static PSEConfigAdv createPSEAdv() {
        PSEConfigAdv pSEConfigAdv = (PSEConfigAdv)AdvertisementFactory.newAdvertisement((String)PSEConfigAdv.getAdvertisementType());
        PSEUtils.IssuerInfo issuerInfo = PSEUtils.genCert((String)ConfigurationFactory.factory.principal, null);
        pSEConfigAdv.setCertificate(issuerInfo.cert);
        pSEConfigAdv.setPrivateKey(issuerInfo.subjectPkey, ConfigurationFactory.factory.password.toCharArray());
        return pSEConfigAdv;
    }

    private static RdvConfigAdv createRdvConfigAdv() {
        return ConfigurationFactory.createRdvConfigAdv(ConfigurationFactory.factory.rdvSeedingURI);
    }

    private static RdvConfigAdv createRdvConfigAdv(URI uRI) {
        RdvConfigAdv rdvConfigAdv = (RdvConfigAdv)AdvertisementFactory.newAdvertisement((String)RdvConfigAdv.getAdvertisementType());
        if (uRI != null) {
            rdvConfigAdv.addSeedingURI(uRI);
        }
        Iterator iterator = ConfigurationFactory.factory.seedRendezvous.iterator();
        while (iterator.hasNext()) {
            rdvConfigAdv.addSeedRendezvous((URI)iterator.next());
        }
        rdvConfigAdv.setUseOnlySeeds(ConfigurationFactory.factory.useOnlyRendezvouSeeds);
        if (ConfigurationFactory.factory.mode == 0) {
            rdvConfigAdv.setConfiguration(RdvConfigAdv.RendezVousConfiguration.EDGE);
        } else if ((ConfigurationFactory.factory.mode & 2) == 2) {
            rdvConfigAdv.setConfiguration(RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS);
        }
        return rdvConfigAdv;
    }

    private static RelayConfigAdv createRelayConfigAdv() {
        return ConfigurationFactory.createRelayConfigAdv(ConfigurationFactory.factory.relaySeedingURI);
    }

    private static RelayConfigAdv createRelayConfigAdv(URI uRI) {
        RelayConfigAdv relayConfigAdv = (RelayConfigAdv)AdvertisementFactory.newAdvertisement((String)RelayConfigAdv.getAdvertisementType());
        if (uRI != null) {
            relayConfigAdv.addSeedingURI(uRI);
        }
        Iterator iterator = ConfigurationFactory.factory.seedRelay.iterator();
        while (iterator.hasNext()) {
            relayConfigAdv.addSeedRelay(((URI)iterator.next()).toString());
        }
        relayConfigAdv.setUseOnlySeeds(ConfigurationFactory.factory.useOnlyRelaySeeds);
        relayConfigAdv.setClientEnabled(true);
        relayConfigAdv.setServerEnabled((ConfigurationFactory.factory.mode & 4) == 4);
        return relayConfigAdv;
    }

    private static TCPAdv createTcpAdv() {
        TCPAdv tCPAdv = (TCPAdv)AdvertisementFactory.newAdvertisement((String)TCPAdv.getAdvertisementType());
        tCPAdv.setProtocol("tcp");
        tCPAdv.setInterfaceAddress(null);
        if (!ConfigurationFactory.factory.rangeSet) {
            tCPAdv.setPort(ConfigurationFactory.factory.tcpPort);
        } else {
            tCPAdv.setPort(ConfigurationFactory.factory.tcpStartPort);
            tCPAdv.setStartPort(ConfigurationFactory.factory.tcpStartPort);
            tCPAdv.setEndPort(ConfigurationFactory.factory.tcpEndPort);
        }
        tCPAdv.setMulticastAddr("224.0.1.85");
        tCPAdv.setMulticastPort(ConfigurationFactory.factory.mcastPort);
        tCPAdv.setMulticastSize(ConfigurationFactory.factory.bufferSize);
        tCPAdv.setMulticastState(ConfigurationFactory.factory.mutlicastOn);
        tCPAdv.setServer(null);
        tCPAdv.setClientEnabled(ConfigurationFactory.factory.tcp_outgoing);
        tCPAdv.setServerEnabled(ConfigurationFactory.factory.tcp_incoming);
        return tCPAdv;
    }

    private static StructuredDocument getParmDoc(boolean bl, Advertisement advertisement) {
        StructuredDocument structuredDocument = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (String)"Parm");
        StructuredDocument structuredDocument2 = (StructuredDocument)advertisement.getDocument(MimeMediaType.XMLUTF8);
        StructuredDocumentUtils.copyElements((StructuredDocument)structuredDocument, (Element)structuredDocument, (Element)structuredDocument2);
        if (!bl) {
            structuredDocument.appendChild(structuredDocument.createElement((Object)"isOff"));
        }
        return structuredDocument;
    }

    public static Advertisement newPlatformConfig() {
        XMLDocument xMLDocument;
        RelayConfigAdv relayConfigAdv;
        PlatformConfig platformConfig = (PlatformConfig)AdvertisementFactory.newAdvertisement((String)PlatformConfig.getAdvertisementType());
        platformConfig.setName(ConfigurationFactory.factory.name);
        platformConfig.setDescription(ConfigurationFactory.factory.description);
        if (ConfigurationFactory.factory.peerid != null) {
            platformConfig.setPeerID(ConfigurationFactory.factory.peerid);
        }
        TCPAdv tCPAdv = ConfigurationFactory.createTcpAdv();
        platformConfig.putServiceParam((ID)PeerGroup.tcpProtoClassID, (Element)ConfigurationFactory.getParmDoc(true, (Advertisement)tCPAdv));
        HTTPAdv hTTPAdv = ConfigurationFactory.createHttpAdv(ConfigurationFactory.factory.httpPort, false, true);
        platformConfig.putServiceParam((ID)PeerGroup.httpProtoClassID, (Element)ConfigurationFactory.getParmDoc(true, (Advertisement)hTTPAdv));
        if (ConfigurationFactory.factory.relayed) {
            relayConfigAdv = ConfigurationFactory.createRelayConfigAdv();
            xMLDocument = (XMLDocument)relayConfigAdv.getDocument(MimeMediaType.XMLUTF8);
            platformConfig.putServiceParam((ID)PeerGroup.relayProtoClassID, (Element)xMLDocument);
        }
        relayConfigAdv = ConfigurationFactory.createRdvConfigAdv();
        xMLDocument = (XMLDocument)relayConfigAdv.getDocument(MimeMediaType.XMLUTF8);
        platformConfig.putServiceParam((ID)PeerGroup.rendezvousClassID, (Element)xMLDocument);
        XMLDocument xMLDocument2 = (XMLDocument)platformConfig.getServiceParam((ID)PeerGroup.endpointClassID);
        if (null != xMLDocument2) {
            xMLDocument2 = (XMLDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (String)"Parm");
            xMLDocument2.appendChild((Element)xMLDocument2.createElement("MessengerQueueSize", "20"));
            platformConfig.putServiceParam((ID)PeerGroup.endpointClassID, (Element)xMLDocument2);
        }
        if (ConfigurationFactory.factory.principal != null && ConfigurationFactory.factory.password != null) {
            PSEConfigAdv pSEConfigAdv = ConfigurationFactory.createPSEAdv();
            XMLDocument xMLDocument3 = (XMLDocument)pSEConfigAdv.getDocument(MimeMediaType.XMLUTF8);
            platformConfig.putServiceParam((ID)PeerGroup.membershipClassID, (Element)xMLDocument3);
        }
        if (!(ConfigurationFactory.factory.debugLevel.equals("error") || ConfigurationFactory.factory.debugLevel.equals("warn") || ConfigurationFactory.factory.debugLevel.equals("info") || ConfigurationFactory.factory.debugLevel.equals("debug"))) {
            ConfigurationFactory.factory.debugLevel = "info";
        }
        platformConfig.setDebugLevel(ConfigurationFactory.factory.debugLevel);
        return platformConfig;
    }

    public static void save(Advertisement advertisement, boolean bl) throws IOException {
        if (!(advertisement instanceof PlatformConfig)) {
            throw new IllegalArgumentException("Invalid PlatformConfig Advertisement");
        }
        FileOutputStream fileOutputStream = null;
        ConfigurationFactory.factory.home.mkdirs();
        File file = new File(ConfigurationFactory.factory.home, "PlatformConfig");
        if (!bl && file.exists()) {
            return;
        }
        fileOutputStream = new FileOutputStream(file);
        XMLDocument xMLDocument = (XMLDocument)advertisement.getDocument(MimeMediaType.XMLUTF8);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        xMLDocument.sendToWriter((Writer)outputStreamWriter);
        outputStreamWriter.flush();
        if (null != fileOutputStream) {
            fileOutputStream.close();
        }
        if (ConfigurationFactory.factory.configProps != null) {
            File file2 = new File(ConfigurationFactory.factory.home, "config.properties");
            FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
            ConfigurationFactory.factory.configProps.store(fileOutputStream2, "# Infrastructure group");
            fileOutputStream2.close();
        }
    }

    public static void setInfrastructureID(PeerGroupID peerGroupID) {
        if (peerGroupID == null || peerGroupID.equals(ID.nullID)) {
            throw new IllegalArgumentException("PeerGroup ID may not be null");
        }
        PeerGroupFactory.setNetPGID((PeerGroupID)peerGroupID);
        ConfigurationFactory.setInfrastructureID(peerGroupID.getUniqueValue().toString());
    }

    public static void setInfrastructureID(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("PeerGroup ID string may not be empty or null");
        }
        ConfigurationFactory.factory.configProps = new Properties();
        ConfigurationFactory.factory.configProps.setProperty("NetPeerGroupID", string);
        ConfigurationFactory.factory.configProps.setProperty("NetPeerGroupName", "InfraGrp");
        ConfigurationFactory.factory.configProps.setProperty("NetPeerGroupDesc", "Infrastructure Group");
    }

    public static void setHome(File file) {
        ConfigurationFactory.factory.home = file;
        System.setProperty("JXTA_HOME", file.getAbsolutePath());
    }

    public static void setMulticastPort(int n) {
        ConfigurationFactory.factory.mcastPort = n;
    }

    public static void setName(String string) {
        ConfigurationFactory.factory.name = string;
    }

    public static void setPrincipal(String string) {
        ConfigurationFactory.factory.principal = string;
    }

    public static void setPassword(String string) {
        ConfigurationFactory.factory.password = string;
    }

    public static void setPeerID(PeerID peerID) {
        ConfigurationFactory.factory.peerid = peerID;
    }

    public static void setRelayed(boolean bl) {
        ConfigurationFactory.factory.relayed = bl;
    }

    public static void setTcpIncoming(boolean bl) {
        ConfigurationFactory.factory.tcp_incoming = bl;
    }

    public static void setTcpOutgoing(boolean bl) {
        ConfigurationFactory.factory.tcp_outgoing = bl;
    }

    public static void setTcpPort(int n) {
        ConfigurationFactory.factory.tcpPort = n;
    }

    public static void setUseMulticast(boolean bl) {
        ConfigurationFactory.factory.mutlicastOn = bl;
    }

    public static void setRdvSeedingURI(URI uRI) {
        ConfigurationFactory.factory.rdvSeedingURI = uRI;
    }

    public static void setRelaySeedingURI(URI uRI) {
        ConfigurationFactory.factory.relaySeedingURI = uRI;
    }

    public static void addSeedRendezvous(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("uri may not be null");
        }
        ConfigurationFactory.factory.seedRendezvous.add(uRI);
    }

    public static void addSeedRelay(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("uri may not be null");
        }
        ConfigurationFactory.factory.seedRelay.add(uRI);
    }

    public static void setTCPPortRange(int n, int n2) {
        ConfigurationFactory.factory.tcpStartPort = n;
        ConfigurationFactory.factory.tcpEndPort = n2;
        ConfigurationFactory.factory.rangeSet = true;
    }

    public static void setDescription(String string) {
        ConfigurationFactory.factory.description = string;
    }

    public static void setUseOnlyRelaySeeds(boolean bl) {
        ConfigurationFactory.factory.useOnlyRelaySeeds = bl;
    }

    public static void setUseOnlyRendezvousSeeds(boolean bl) {
        ConfigurationFactory.factory.useOnlyRendezvouSeeds = bl;
    }

    public static void setDebugLevel(String string) {
        ConfigurationFactory.factory.debugLevel = string;
    }

    public static void main(String[] stringArray) {
        PeerGroup peerGroup = null;
        ConfigurationFactory.setPeerID(IDFactory.newPeerID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID));
        ConfigurationFactory.setName("peer");
        ConfigurationFactory.setPrincipal("username");
        ConfigurationFactory.setPassword("password");
        ConfigurationFactory.setDescription("Configuration tutorial");
        ConfigurationFactory.setTCPPortRange(9841, 9999);
        try {
            ConfigurationFactory.setRdvSeedingURI(new URI("http://rdv.jxtahosts.net/cgi-bin/rendezvous.cgi?2"));
            ConfigurationFactory.setRelaySeedingURI(new URI("http://rdv.jxtahosts.net/cgi-bin/relays.cgi?2"));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        Advertisement advertisement = ConfigurationFactory.newPlatformConfig();
        try {
            ConfigurationFactory.save(advertisement, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            peerGroup = PeerGroupFactory.newNetPeerGroup();
        }
        catch (PeerGroupException peerGroupException) {
            peerGroupException.printStackTrace();
        }
    }
}

