/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p;

import com.fe.Config;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import net.jxta.document.AdvertisementFactory;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Logger;

public class P2PAdvertisement {
    public static final String PIPEIDSTR = "urn:jxta:uuid-59616261646162614E50472050325033C0C1DE89719B456691A596B983BA0E1004";
    private String taskpip = "taskpip";
    private Logger log = Logger.getLogger(P2PAdvertisement.class);

    public P2PAdvertisement() {
        if (Config.getValue("p2p.taskpip") != null && !Config.getValue("p2p.taskpip").equals("")) {
            this.taskpip = Config.getValue("p2p.taskpip");
        }
    }

    public P2PAdvertisement(boolean bl) {
        if (Config.getValue("p2p.taskpip") != null && !Config.getValue("p2p.taskpip").equals("")) {
            this.taskpip = Config.getValue("p2p.taskpip");
        }
    }

    public PipeAdvertisement getPipeAdvertisement(String string, PeerGroup peerGroup) {
        this.log.debug((Object)("creating advertishment for computer:" + string + " pg:" + peerGroup.getPeerGroupName() + " peerrname:" + peerGroup.getPeerName()));
        PipeID pipeID = null;
        try {
            pipeID = this.createPipeID(peerGroup.getPeerGroupID(), string, this.taskpip);
            this.log.debug((Object)("Pipe Advert ID:" + pipeID));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        pipeAdvertisement.setPipeID((ID)pipeID);
        pipeAdvertisement.setType("JxtaPropagate");
        pipeAdvertisement.setName(string);
        return pipeAdvertisement;
    }

    public PipeAdvertisement getPipeAdvertisement(PipeID pipeID, PeerGroup peerGroup) {
        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        pipeAdvertisement.setPipeID((ID)pipeID);
        pipeAdvertisement.setType("JxtaPropagate");
        return pipeAdvertisement;
    }

    public PeerAdvertisement getPeerAdvertisement(String string, PeerGroup peerGroup) throws Exception {
        PeerID peerID = null;
        this.log.debug((Object)("creating advertishment for computer:" + string + " pg:" + peerGroup.getPeerGroupName() + " peerrname:" + peerGroup.getPeerName()));
        try {
            peerID = this.createPeerID(peerGroup.getPeerGroupID(), string + "peer", this.taskpip);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PeerAdvertisement peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement((String)PeerAdvertisement.getAdvertisementType());
        peerAdvertisement.setPeerID(IDFactory.newPeerID((PeerGroupID)PeerGroupID.worldPeerGroupID));
        peerAdvertisement.setPeerGroupID(IDFactory.newPeerGroupID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID));
        peerAdvertisement.setName(string);
        return peerAdvertisement;
    }

    private final byte[] generateHash(String string, String string2) throws Exception {
        String string3 = string2 == null ? string : string + "" + string2;
        byte[] byArray = string3.getBytes();
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return byArray2;
    }

    private final PipeID createPipeID(PeerGroupID peerGroupID, String string, String string2) throws Exception {
        byte[] byArray = this.generateHash(string, string2);
        return IDFactory.newPipeID((PeerGroupID)peerGroupID, (byte[])byArray);
    }

    private final PeerID createPeerID(PeerGroupID peerGroupID, String string, String string2) throws Exception {
        byte[] byArray = this.generateHash(string, string2);
        return IDFactory.newPeerID((PeerGroupID)peerGroupID, (byte[])byArray);
    }
}

