/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.msg;

import com.fe.p2p.msg.MessageNames;
import com.fe.p2p.websocket.TomcatWSConsole;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommunicationTrace {
    private String peername = null;
    public static ArrayList<String> PEERS = new ArrayList();
    public static ArrayList<String> IGNORE_CLASS = new ArrayList();
    private ArrayList ignoreprops = new ArrayList();
    private static final int OUTGOING = 1;
    private static final int INCOMING = 2;
    private Logger log = Logger.getLogger(CommunicationTrace.class);

    public CommunicationTrace(String string) {
        this.peername = string;
        if (!IGNORE_CLASS.contains("PeerOnlineStatus")) {
            IGNORE_CLASS.add("PeerOnlineStatus");
        }
        this.ignoreprops.add("class");
        this.ignoreprops.add("RendezVousPropagatejxta-NetGroup");
        this.ignoreprops.add("JxtaWireHeader");
        this.ignoreprops.add("msgCreator");
        this.ignoreprops.add("msgRecipient");
        this.ignoreprops.add(MessageNames.MESSAGE_BEAN_NAME);
        this.ignoreprops.add(MessageNames.MESSAGE_TYPE_CALLBACK);
        this.ignoreprops.add("next_trigger_time");
    }

    public void outgoing(Map map) {
        if (PEERS.contains(this.peername)) {
            this.produceOutPut(1, map);
        }
    }

    public void incoming(Map map) {
        if (PEERS.contains(this.peername)) {
            this.produceOutPut(2, map);
        }
    }

    private void produceOutPut(int n, Map map) {
        String string = (String)map.get(MessageNames.MESSAGE_BEAN_NAME);
        string = string.replaceAll("^(.*\\.)(\\S+)$", "$2");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss S");
        if (!IGNORE_CLASS.contains(string)) {
            String string2 = "<span class='time'>" + simpleDateFormat.format(new Date()) + "</span>";
            String string3 = "";
            String string4 = this.peername;
            try {
                string4 = string4.toLowerCase().replaceAll("4ecap(pc|sv|lt|vm)sg(\\d+)", "$1$2");
            }
            catch (Exception exception) {
                this.log.error((Object)("error while parsing computer name:" + exception.getMessage()));
            }
            if (n == 1) {
                string3 = string3 + string2 + " :<span class='hclass'>" + string + "</span>:<span class='p " + string4 + "'>" + this.peername + "</span><span class='out'>--&gt;</span>";
            }
            if (n == 2) {
                string3 = string3 + string2 + " :<span class='hclass'>" + string + "</span>:<span class='p " + string4 + "'>" + this.peername + "</span><span class='in'>&lt;--</span>";
            }
            for (String string5 : map.keySet()) {
                if (this.ignoreprops.contains(string5) || map.get(string5) == null) continue;
                if (string5.equals("scheduler_id")) {
                    string3 = string3 + string5 + ":<span class='sc_id'>" + map.get(string5) + "</span>, ";
                    continue;
                }
                string3 = string3 + string5 + ":" + map.get(string5) + ", ";
            }
            this.out(string3);
        }
    }

    private void out(String string) {
        TomcatWSConsole.consoleToAll(string);
    }
}

