/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.msg.scheduler;

import com.fe.client.BBSyncMgmt;
import com.fe.client.Debugger;
import com.fe.db.SchedulerDB;
import com.fe.p2p.listener.IncomingMessage;
import com.fe.p2p.listener.P2PPipeLog;
import com.fe.p2p.msg.ExceptionMessageHandler;
import com.fe.p2p.msg.scheduler.PeerCacheLock;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.SchedulerAlert;
import com.fe.scheduler.SchedulerEngine;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.exception.ExceptionRServeUnixFailure;
import com.fe.scheduler.exception.ExceptionRServeWindowsFailure;
import com.fe.scheduler.exception.ExceptionWarningNoFullData;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.Map;
import org.apache.log4j.Logger;

public class PeerFinishedTask
extends ExceptionMessageHandler {
    private String scheduler_id;
    private String trigger_time;
    private String taskuid;
    private String status;
    private Logger log = Logger.getLogger(PeerFinishedTask.class);

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getTaskuid() {
        return this.taskuid;
    }

    public void setTaskuid(String string) {
        this.taskuid = string;
    }

    public String getScheduler_id() {
        return this.scheduler_id;
    }

    public void setScheduler_id(String string) {
        this.scheduler_id = string;
    }

    public String getTrigger_time() {
        return this.trigger_time;
    }

    public void setTrigger_time(String string) {
        this.trigger_time = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map executeAtDestination() {
        this.log.debug((Object)("finished:" + this.getScheduler_id() + " tri_time:" + this.getTrigger_time() + " from :" + this.getMsgCreator()));
        this.log.debug((Object)("===========>PeerFinishedTask receiving message with Exception " + this.exception()));
        if (this.exception() != null) {
            this.log.debug((Object)("   ===========>Message " + this.exception().getMessage()));
        }
        P2PPipeLog.receiveMsg("Task Execution Finished:Schduler ID:" + this.getScheduler_id() + " Trigger Time:" + this.getTrigger_time(), this.getMsgCreator() + " Status:" + this.getStatus());
        Debugger.addDebugMsg("Msg from peer " + this.getMsgCreator() + " sc_id:" + this.getScheduler_id() + " tr_time: " + this.getTrigger_time(), this.getMsgCreator() + " " + this.getScheduler_id() + " " + this.getTrigger_time());
        int n = 0;
        try {
            n = Integer.parseInt(this.getScheduler_id());
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l = 0L;
        try {
            l = Long.parseLong(this.getTrigger_time());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PeerCacheLock.releasePeer(this.getMsgCreator(), this.getTaskuid());
        LoadBalancingQueue.getDefault().releasePeersCache4PriorityGr();
        if (this.getExceptionClass() != null && this.getExceptionClass().equals(ExceptionRServeUnixFailure.class.getName()) || this.getExceptionClass() != null && this.getExceptionClass().equals(ExceptionRServeWindowsFailure.class.getName())) {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            try {
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                LoadBalancingQueue.getDefault().executionFailed(n, l, this.getMsgCreator());
                LoadBalancingQueue.getDefault().releasePeersCache4PriorityGr();
                LoadBalancingQueue.getDefault().peerStarted(n, l, this.getMsgCreator());
                schedulerDB.updateQueueLogStatus(n, l, null);
            }
            catch (Exception exception) {
                this.log.error((Object)("error while saving peerstarted Error:" + exception.getMessage() + " scd_id:" + n + " trig_time:" + l));
            }
            finally {
                try {
                    schedulerDB.closeDB();
                }
                catch (Exception exception) {
                    this.log.error((Object)("Error while closing sdb connection, error:" + exception.getMessage()));
                }
            }
        } else if (n >= 0) {
            new SchedulerExePlanLogs(n, l).log("Server rcvd completed signal, Status:" + this.getStatus(), 2002);
            LoadBalancingQueue.getDefault().executionEnded(n, l);
            IncomingMessage.updateFinishedPeersTime(this.getMsgCreator(), n, l);
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            try {
                Object object;
                String string;
                String string2;
                Map map;
                String string3;
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                try {
                    if (this.exception() != null) {
                        schedulerDB.updateResponseCode(n, l, this.exception().getErrorcode());
                    }
                }
                catch (Exception exception) {
                    this.log.error((Object)("Couldn't get Scheduler Exception, Error:" + exception.getMessage()));
                }
                if (this.getStatus() != null && !this.getStatus().equals("")) {
                    for (int i = 0; i < 5; ++i) {
                        try {
                            schedulerDB.updateQueueNullStatus(n, l, this.getStatus());
                            i = 100;
                            continue;
                        }
                        catch (SQLServerException sQLServerException) {
                            this.log.error((Object)("SQL Error:" + sQLServerException.getMessage() + " trying " + i));
                            Thread.sleep(500L);
                        }
                    }
                }
                if ((string3 = schedulerDB.getErrorMessageEvenNull(n, l)) == null && this.getExceptionMessage() != null) {
                    if (!this.getExceptionClass().equalsIgnoreCase(ExceptionWarningNoFullData.class.getName())) {
                        string3 = this.getExceptionMessage();
                    }
                } else if (string3 != null && this.getExceptionMessage() != null) {
                    string3 = string3 + "\n " + this.getExceptionMessage();
                }
                this.log.debug((Object)("~~~~ Server rcvd completed signal:" + string3 + " sc_id:" + n + " tri_time:" + l));
                if (string3 != null) {
                    map = schedulerDB.getScheduler(n);
                    string2 = (String)map.get("alert_type");
                    string = (String)map.get("name");
                    if (string2 != null && !string2.equals("")) {
                        object = new SchedulerAlert(n, l);
                        ((SchedulerAlert)object).alert(string2, string, SchedulerAlert.ALERT_SUB_FAILED, string3, this.getMsgCreator(), schedulerDB, this.exception(), map);
                    }
                }
                if ((map = schedulerDB.getTaskEventActions(n, l)).containsKey(string2 = "status") && ((String)map.get(string2)).equals(ScheduledTask.EXCECUTION_SUCCESS) && map.containsKey(ScheduledTask.FIELD_DEPENDENCY_SUCCESS) && map.get(ScheduledTask.FIELD_DEPENDENCY_SUCCESS) != null && !((String)map.get(ScheduledTask.FIELD_DEPENDENCY_SUCCESS)).trim().equals("")) {
                    string = (String)map.get(ScheduledTask.FIELD_DEPENDENCY_SUCCESS);
                    object = ScheduledTask.TASK_EVENT_CALL_EXP_ID_VARIABLE + "=" + n + "\n";
                    object = (String)object + ScheduledTask.TASK_EVENT_CALL_EXP_TRIGGERTIME_VARIABLE + "=" + l + "\n";
                    new SchedulerEngine().executeScriptExpression(string, "onSuccess of " + n, (String)object);
                }
                if (map.containsKey(string2) && ((String)map.get(string2)).equals(ScheduledTask.EXCECUTION_FAIL) && map.containsKey(ScheduledTask.FIELD_DEPENDENCY_FAIL) && map.get(ScheduledTask.FIELD_DEPENDENCY_FAIL) != null && !((String)map.get(ScheduledTask.FIELD_DEPENDENCY_FAIL)).trim().equals("")) {
                    string = (String)map.get(ScheduledTask.FIELD_DEPENDENCY_FAIL);
                    object = ScheduledTask.TASK_EVENT_CALL_EXP_ID_VARIABLE + "=" + n + "\n";
                    object = (String)object + ScheduledTask.TASK_EVENT_CALL_EXP_TRIGGERTIME_VARIABLE + "=" + l + "\n";
                    if (string3 != null) {
                        object = (String)object + ScheduledTask.TASK_EVENT_CALL_EXP_ERRORMSG_VARIABLE + "=\"" + l + "\";\n";
                    }
                    new SchedulerEngine().executeScriptExpression(string, "onFailure of " + n, (String)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    schedulerDB.closeDB();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    @Override
    public void onSendingFailed() {
    }
}

