/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.msg.scheduler;

import com.fe.client.BBSyncMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.listener.IncomingMessage;
import com.fe.p2p.listener.OutgoingMessageCallBack;
import com.fe.p2p.msg.MessageHandler;
import com.fe.p2p.msg.PostCallBack;
import com.fe.p2p.peer.PeerMachine;
import com.fe.p2p.peer.PeerManagerHSQL;
import com.fe.scheduler.peer.QueueFactory;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class PeerOnlineStatus
extends MessageHandler
implements PostCallBack {
    private String status = null;
    private String peerversion = null;
    private Logger log = Logger.getLogger(PeerOnlineStatus.class);
    private static JCS cache = null;

    public String getPeerversion() {
        return this.peerversion;
    }

    public void setPeerversion(String string) {
        this.peerversion = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    @Override
    public int getPriority() {
        return OutgoingMessageCallBack.PRIORITY_LOW;
    }

    @Override
    public Map executeAtDestination() {
        Map<Object, Object> map = new HashMap();
        QueueFactory queueFactory = new QueueFactory();
        this.setPeerversion(PeerMachine.getLastVersion());
        if (queueFactory.countExcTasksInPeer() > 0) {
            String string = "";
            String string2 = "";
            map = queueFactory.getExecutingIDAndSTimes();
            this.setStatus("BUSY");
        } else {
            this.setStatus("NOBUSY");
        }
        return map;
    }

    @Override
    public void callBack(Map map) {
        String string = this.getMsgCreator();
        this.updatePeerStatus(map, string);
        this.log.debug((Object)("Message reccied from client:~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ peer " + string + " ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
    }

    public void updatePeerStatus(Map map, String string) {
        try {
            if (PeerOnlineStatus.getCache().get((Object)("peer_" + string)) == null) {
                IElementAttributes iElementAttributes = PeerOnlineStatus.getCache().getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds(30L);
                PeerOnlineStatus.getCache().put((Object)("peer_" + string), (Object)string, iElementAttributes);
                this.updateLastOnline(string);
                this.log.debug((Object)("----->caching peer:" + string));
            }
        }
        catch (Exception exception) {
            this.log.error((Object)"Error while caching peer online status");
        }
        IncomingMessage.peersUpdate(string, this.getStatus());
        new PeerManagerHSQL().updatePeerResponse(string, map, this.getPeerversion());
    }

    private static JCS getCache() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)"PeerOnlineStatus");
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateLastOnline(String string) {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.updatePeersLastOnline(string, new Date().getTime());
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removePeerThreadStatus(String string) {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.removeAllPeerThreadStatus(string);
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {}
        }
    }

    public static Collection getOnlineRespondingPeers() throws Exception {
        HashMap hashMap = PeerOnlineStatus.getCache().getMatching("^[A-Za-z0-9_]+$");
        return hashMap.values();
    }

    @Override
    public void onCallBackSendingFailed() {
    }

    @Override
    public void onSendingFailed() {
    }
}

