/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.websocket;

import com.fe.p2p.websocket.CommandMain;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public abstract class CommandAbstract {
    private Logger log = Logger.getLogger(CommandAbstract.class);

    public Options getOptionsWithHelp() {
        Options options = this.getOptions();
        options.addOption("h", "help", false, "Show help of this command");
        return options;
    }

    public String showHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        StringWriter stringWriter = new StringWriter();
        String string = this.getClass().getSimpleName();
        string = CommandMain.classToCommand(string);
        helpFormatter.printHelp(new PrintWriter(stringWriter), 200, string, this.getHeader(), this.getOptionsWithHelp(), 0, 5, this.getFooter(), true);
        return stringWriter.toString();
    }

    public String getCommand() {
        String string = this.getClass().getSimpleName();
        string = CommandMain.classToCommand(string);
        return string;
    }

    public String executeCommand(String string) throws Exception {
        String string2 = "";
        try {
            PosixParser posixParser = new PosixParser();
            CommandLine commandLine = posixParser.parse(this.getOptionsWithHelp(), string.split(" "));
            if (commandLine.hasOption('h')) {
                string2 = this.showHelp();
            } else {
                this.log.debug((Object)"executeValidCommand()");
                string2 = this.executeValidCommand(commandLine, string);
            }
        }
        catch (ParseException parseException) {
            string2 = this.showHelp();
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        return string2;
    }

    public abstract String executeValidCommand(CommandLine var1, String var2);

    public abstract Options getOptions();

    public abstract String getHeader();

    public abstract String getFooter();
}

