/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.websocket;

import com.fe.p2p.websocket.TomcatWSServer;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptAsyncWebsocket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.log4j.Logger;

public class TomcatWSExecuteRService
extends WebSocketServlet {
    private Logger log = Logger.getLogger(TomcatWSServer.class);
    private static final Set<ChatMessageInbound> connections = new CopyOnWriteArraySet<ChatMessageInbound>();

    protected StreamInbound createWebSocketInbound(String string, HttpServletRequest httpServletRequest) {
        return new ChatMessageInbound(httpServletRequest.getRemoteHost());
    }

    public static void broadcast(String string) {
        for (ChatMessageInbound chatMessageInbound : connections) {
            Logger logger = Logger.getLogger(TomcatWSServer.class);
            logger.debug((Object)("# connections:" + connections.size()));
            logger.debug((Object)("# Msg:" + string));
            try {
                CharBuffer charBuffer = CharBuffer.wrap(string);
                chatMessageInbound.getWsOutbound().writeTextMessage(charBuffer);
            }
            catch (IOException iOException) {}
        }
    }

    private final class ChatMessageInbound
    extends MessageInbound {
        private String ip;

        public ChatMessageInbound(String string) {
            this.ip = string;
        }

        protected void onOpen(WsOutbound wsOutbound) {
            connections.add(this);
            TomcatWSExecuteRService.this.log.debug((Object)"connected...");
        }

        protected void onClose(int n) {
            connections.remove((Object)this);
            TomcatWSExecuteRService.this.log.debug((Object)"closed...");
        }

        protected void onBinaryMessage(ByteBuffer byteBuffer) throws IOException {
            throw new UnsupportedOperationException("Binary message not supported.");
        }

        protected void onTextMessage(CharBuffer charBuffer) throws IOException {
            String string = charBuffer.toString();
            Pattern pattern = Pattern.compile("^(.*?)~~(.*?)~~(.*?)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find() && matcher.groupCount() > 2) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                String string4 = matcher.group(3);
                RScript rScript = new RScript();
                rScript.setUniquename(string2);
                rScript.setRequesthost(this.ip);
                rScript.setTaskuid("direct_script");
                if (string3 != null && string3.equalsIgnoreCase("rserve")) {
                    rScript.setTaskuid("direct_script_unix");
                }
                rScript.setScript(string4);
                RScriptAsyncWebsocket rScriptAsyncWebsocket = new RScriptAsyncWebsocket(string2, this);
                try {
                    LoadBalancingQueue.getExecuteRScriptDefault().addExecuteR(rScript, rScriptAsyncWebsocket);
                }
                catch (Exception exception) {
                    TomcatWSExecuteRService.this.log.error((Object)("error:" + exception.getMessage()));
                }
            } else {
                String string5 = "Script can't executed without ID or script body, format: unique-id~~script_content";
                this.getWsOutbound().writeTextMessage(CharBuffer.wrap(string5));
                this.getWsOutbound().flush();
            }
        }
    }
}

