/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.websocket.cmd;

import com.fe.io.server.ServerConnection;
import com.fe.io.server.ServerConnectionHandler;
import com.fe.p2p.websocket.CommandAbstract;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class Peers
extends CommandAbstract {
    @Override
    public String executeValidCommand(CommandLine commandLine, String string) {
        String string2 = "";
        if (commandLine.hasOption("p")) {
            try {
                String string3 = commandLine.getOptionValue("p");
                ServerConnection serverConnection = ServerConnectionHandler.getServerConnection(string3);
                long l = new Date().getTime() - serverConnection.getConnectedtime();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM,yy HH:mm:ss ");
                Date date = new Date();
                date.setTime(serverConnection.getConnectedtime());
                string2 = string2 + serverConnection.getUser() + " (" + serverConnection.getIp() + ") " + simpleDateFormat.format(date) + "  - " + (l /= 1000L) + " secs\n";
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                Iterator<ServerConnection> iterator = ServerConnectionHandler.getAllServerConnection();
                while (iterator.hasNext()) {
                    ServerConnection serverConnection = iterator.next();
                    long l = new Date().getTime() - serverConnection.getConnectedtime();
                    string2 = string2 + serverConnection.getUser() + " (" + serverConnection.getIp() + ")  " + (l /= 1000L) + " secs\n";
                }
                if (string2.equals("")) {
                    string2 = "No peers online now";
                }
            }
            catch (Exception exception) {
                string2 = "Error, " + exception.getMessage();
            }
        }
        return string2;
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption("p", "peer", true, "Show online peer - example: -p 4ecappcsg2");
        return options;
    }

    @Override
    public String getHeader() {
        return "Show online peers";
    }

    @Override
    public String getFooter() {
        return "";
    }
}

