/*
 * Decompiled with CFR 0.152.
 */
package com.fe.rhino;

import com.fe.client.BBSyncMgmt;
import com.fe.data.Contract;
import com.fe.data.Strategy;
import com.fe.db.ContractDB;
import com.fe.db.SuperDB;
import com.fe.migrate.historical.HistoricalData;
import com.fe.rhino.DatabaseSelector;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DbWrapper
extends DatabaseSelector {
    private Logger log = Logger.getLogger(DbWrapper.class);
    private String commodity = null;
    private String tablename = null;
    private boolean duplicateCheck = true;

    public void syncNewReferenceSecuritiesWithBB() throws Exception {
        BBSyncMgmt bBSyncMgmt = new BBSyncMgmt("rhinoexposure");
        bBSyncMgmt.bbSynchSecurites(true);
    }

    public void syncAllReferenceSecuritiesWithBB() throws Exception {
        BBSyncMgmt bBSyncMgmt = new BBSyncMgmt("rhinoexposure");
        bBSyncMgmt.bbSynchSecurites(false);
    }

    public void syncNewContractSecuritiesWithBB() throws Exception {
        BBSyncMgmt bBSyncMgmt = new BBSyncMgmt("rhinoexposure");
        bBSyncMgmt.bbSynchContracts(true);
    }

    public void syncAllContractSecuritiesWithBB() throws Exception {
        BBSyncMgmt bBSyncMgmt = new BBSyncMgmt("rhinoexposure");
        bBSyncMgmt.bbSynchContracts(false);
    }

    public void setDuplicateCheck(boolean bl) {
        this.duplicateCheck = bl;
    }

    public void setCommodity(String string) throws Exception {
        this.commodity = string;
    }

    public void setSecurity(String string) throws Exception {
        this.commodity = string;
    }

    public void setFieldname(String string) throws Exception {
        this.tablename = string;
    }

    public void createNumericRecord(String string, double d, Date date) throws Exception {
        this.log.debug((Object)"createRecord() called");
        this.log.debug((Object)("createRecord() name:" + string + " val:" + d + " cdate:" + date));
        Contract contract = new Contract();
        contract.setName(string);
        contract.setCdate(date);
        contract.setValue(d);
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalData.resolvedColName(this.commodity) + "_" + HistoricalData.resolvedColName(this.tablename), this.db);
        contractDB.connectDB(this.db);
        Vector<Contract> vector = new Vector<Contract>();
        vector.add(contract);
        contractDB.addRecords(contractDB.connection(), vector);
    }

    public void updateNumericRecord(String string, double d, Date date) throws Exception {
        this.log.debug((Object)"createRecord() called");
        this.log.debug((Object)("createRecord() name:" + string + " val:" + d + " cdate:" + date));
        Contract contract = new Contract();
        contract.setName(string);
        contract.setCdate(date);
        contract.setValue(d);
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalData.resolvedColName(this.commodity) + "_" + HistoricalData.resolvedColName(this.tablename), this.db);
        contractDB.connectDB(this.db);
        Vector<Contract> vector = new Vector<Contract>();
        vector.add(contract);
        contractDB.updateRecords(contractDB.connection(), vector);
    }

    public void createStringRecord(String string, String string2, Date date) throws Exception {
        this.log.debug((Object)"createRecord() called");
        this.log.debug((Object)("createRecord() name:" + string + " val:" + string2 + " cdate:" + date));
        Strategy strategy = new Strategy();
        strategy.setName(string);
        strategy.setCdate(date);
        strategy.setSvalue(string2);
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalData.resolvedColName(this.commodity) + "_" + HistoricalData.resolvedColName(this.tablename), this.db);
        contractDB.connectDB(this.db);
        Vector<Strategy> vector = new Vector<Strategy>();
        vector.add(strategy);
        contractDB.addSValRecords(contractDB.connection(), vector);
    }

    public void updateStringRecord(String string, String string2, Date date) throws Exception {
        this.log.debug((Object)"createRecord() called");
        this.log.debug((Object)("createRecord() name:" + string + " val:" + string2 + " cdate:" + date));
        Strategy strategy = new Strategy();
        strategy.setName(string);
        strategy.setCdate(date);
        strategy.setSvalue(string2);
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalData.resolvedColNameNoTrim(this.commodity) + "_" + HistoricalData.resolvedColName(this.tablename), this.db);
        contractDB.connectDB(this.db);
        Vector<Strategy> vector = new Vector<Strategy>();
        vector.add(strategy);
        contractDB.updateSValRecords(contractDB.connection(), vector);
    }

    public void createSchemaIfNotExist() throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalData.resolvedColNameNoTrim(this.commodity) + "_" + HistoricalData.resolvedColName(this.tablename), this.db);
        contractDB.connectDB(this.db);
        contractDB.updateMasterTable(contractDB.connection(), this.commodity, this.tablename);
        contractDB.createTable(contractDB.connection(), 8);
        contractDB.closeDB();
    }

    public void createSValSchemaIfNotExist() throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalData.resolvedColNameNoTrim(this.commodity) + "_" + HistoricalData.resolvedColName(this.tablename), this.db);
        contractDB.connectDB(this.db);
        contractDB.updateMasterTable(contractDB.connection(), this.commodity, this.tablename);
        contractDB.createSValTable(contractDB.connection(), 8);
        contractDB.closeDB();
    }
}

