/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.Config;
import com.fe.db.SchedulerDB;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.exception.ExceptionSchedulerTeamRelated;
import com.fe.scheduler.exception.SchedulerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class SchedulerAlert {
    public static String ALERT_SUB_FAILED = "Failed";
    public static String ALERT_SUB_TIMEOUT = "Timeout";
    public static String ALERT_SUB_CRASHED = "Crashed";
    public static String SCHEDULER_TEAM_THEME = "computing";
    private Logger log = Logger.getLogger(SchedulerAlert.class);
    private int scheduler_id = 0;
    private long trigger_time = 0L;

    public SchedulerAlert(int n, long l) {
        this.scheduler_id = n;
        this.trigger_time = l;
    }

    public void alert(String string, String string2, String string3, String string4, String string5, SchedulerDB schedulerDB, SchedulerException schedulerException, Map map) throws Exception {
        boolean bl;
        String string6 = Config.getValue("scheduler.ignore.alert");
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.fe.scheduler.scheduleralert");
        String string7 = resourceBundle.getString("scheduler.ignore.phone.alert");
        List<String> list = Arrays.asList(string7.split(","));
        boolean bl2 = bl = string.equalsIgnoreCase("phone") && list.contains(Integer.toString(schedulerException.getErrorcode()));
        if (bl) {
            string = "email";
        }
        boolean bl3 = false;
        bl3 = schedulerDB.execLogsRepcodeExist(this.scheduler_id, this.trigger_time, 3005);
        if (bl3) {
            this.log.error((Object)("--tried sending alert for alert sent failure, trigger_time:" + this.trigger_time + " scheduler_id:" + this.scheduler_id));
        }
        if (!(string != null && string.equalsIgnoreCase("No Alert") || string == null || string != null && string.trim().equalsIgnoreCase("") || string6 != null && string6.equalsIgnoreCase("true") || bl3)) {
            String string8;
            new SchedulerExePlanLogs(this.scheduler_id, this.trigger_time).log("Alarm sent", schedulerDB, 3005);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss");
            List list2 = schedulerDB.getThemeTags(this.scheduler_id);
            String string9 = schedulerDB.getOwnerTheme(this.scheduler_id);
            if (string9 != null && list2.contains(string9)) {
                list2.remove(string9);
                list2.add(0, string9);
            }
            Map map2 = schedulerDB.getQueueLog(this.scheduler_id, this.trigger_time);
            int n = 0;
            try {
                n = ((Number)map2.get("response_code")).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string10 = "";
            if (string5 != null) {
                string8 = schedulerDB.getPeerFriendlyName(string5);
                string10 = "" + (string8 != null ? string8 + "(" + string5 + ") " : string5 + " ");
            }
            if (list2 != null && list2.size() > 0) {
                string8 = "";
                Object object = list2.iterator();
                while (object.hasNext()) {
                    string8 = string8 + (string8.equals("") ? (String)object.next() : "," + (String)object.next());
                }
                object = string.equalsIgnoreCase("phone") ? "Phone:" : "";
                String string11 = "Task " + this.scheduler_id + " (" + string2 + ") " + string3 + (n > 0 ? ",Err Code:" + n : "");
                boolean bl4 = true;
                if (bl4) {
                    String string12 = "<div style='marging-bottom:30px;border:3px solid #D1D1D1;font-size:1.3em;background-color:#F0F0F0;padding:10px 20px;border-radius: 5px;'>";
                    string12 = string12 + "<div>Script:<strong>" + string2 + " (" + this.scheduler_id + ")" + "</strong></div>";
                    string12 = string12 + "<div>Scheduled At:<strong>" + simpleDateFormat.format(new Date(this.trigger_time)) + "</strong></div>";
                    string12 = string12 + "<div>Peer:<strong>" + string10 + "</strong></div>";
                    string12 = string12 + "<div>Status:<strong>" + string3 + "</strong></div>";
                    string12 = string12 + "<div>Response Code:<strong>" + n + "</strong></div>";
                    string12 = string12 + "<div><u>Message:</u></div>";
                    string12 = string12 + "<div><pre style='margin:0px;color:red'>" + string4 + "</pre></div>";
                    string12 = string12 + "</div>";
                    string12 = string12 + "<div>";
                    this.log.debug((Object)("resp_code:" + string12.length()));
                    string12 = string12 + this.collectExecLogs(schedulerDB);
                    if (n > 0) {
                        string12 = string12 + this.getRespCodeError(n);
                    }
                    string12 = string12 + this.getConsoleMsg(schedulerDB);
                    string12 = string12 + "</div>";
                    this.log.debug((Object)("composed:" + string12));
                    boolean bl5 = true;
                    if (schedulerException != null && schedulerException instanceof ExceptionSchedulerTeamRelated) {
                        list2.add(SCHEDULER_TEAM_THEME);
                        string11 = "[TO_COMPUTING]" + string11;
                    }
                    String string13 = this.getXML(list2, string11, string12, bl5, string.equalsIgnoreCase("email"), string.equalsIgnoreCase("phone"));
                    this.log.debug((Object)("size of xml:" + string13.length()));
                    resourceBundle = ResourceBundle.getBundle("com.fe.scheduler.scheduleralert");
                    boolean bl6 = Boolean.parseBoolean(resourceBundle.getString("scheduler.alert.dump"));
                    if (bl6) {
                        String string14 = resourceBundle.getString("scheduler.alert.dump.folder");
                        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyyMMdd");
                        string14 = string14 + simpleDateFormat2.format(new Date()) + "/";
                        File file = new File(string14);
                        file.mkdirs();
                        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("HHmmss");
                        PrintWriter printWriter = new PrintWriter(string14 + simpleDateFormat3.format(new Date(this.trigger_time)) + "-" + this.scheduler_id + "-" + n + ".xml", "UTF-8");
                        printWriter.println(string13);
                        printWriter.close();
                    } else {
                        SchedulerAlert.sendXML(string13);
                    }
                }
            }
        }
    }

    private String getRespCodeError(int n) throws Exception {
        String string = SchedulerAlert.class.getResource("").getPath() + "codehelp" + File.separator + n + ".html";
        File file = new File(string);
        this.log.debug((Object)("log resp help path:" + string + " exists():::" + file.exists()));
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            StringWriter stringWriter = new StringWriter();
            IOUtils.copy((InputStream)fileInputStream, (Writer)stringWriter);
            return "<br><span style='margin-top:30px;margin-bottom:0px;font-size:1.5em'>Learn more about the issue</span>" + stringWriter.toString();
        }
        this.log.error((Object)("File filepath:" + string + " doesn't exist"));
        return "";
    }

    private String getConsoleMsg(SchedulerDB schedulerDB) {
        try {
            String string = schedulerDB.getConsoleMsg(this.scheduler_id, this.trigger_time);
            if (string != null && !string.trim().equals("")) {
                String string2 = "<br><span style='margin-top:30px;margin-bottom:0px;font-size:1.5em'>Console Output</span><div style='font-family: courier;'><pre style='margin-top:0px'>" + string + "</pre></div>";
                return string2;
            }
            return "";
        }
        catch (Exception exception) {
            return "Error: couldn't get console message, Error:" + exception.getMessage();
        }
    }

    private String collectExecLogs(SchedulerDB schedulerDB) throws Exception {
        try {
            String string = "<br><span style='margin-top:30px;margin-bottom:0px;font-size:1.5em'>Execution Log</span><table width='100%' cellpadding='3' cellspacing='0' border='1' style='border:1px solid #D1D1D1;border-collapse:collapse;'><thead><tr>  <th align='left'>Date&Time</th> <th align='left'>Machine</th> <th align='left'>Code</th> <th align='left'>Message</th>  </tr></thead>";
            Vector vector = schedulerDB.getSchedulerExeLogs(this.scheduler_id, this.trigger_time);
            this.log.debug((Object)("collectExecLogs, list:" + vector));
            if (vector == null || vector != null && vector.size() == 0) {
                return null;
            }
            string = string + "<tbody>";
            for (Map map : vector) {
                String string2 = "";
                int n = 0;
                try {
                    n = ((Number)map.get("repcode")).intValue();
                    if (n >= 3000 && n <= 4999 || n >= 6000 && n <= 7999) {
                        string2 = " style='color:#d14836' ";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n == 3005) continue;
                string = string + "<tr " + string2 + ">";
                string = string + "<td width='width:105px'>" + map.get("trans_datetime1") + "</td>";
                string = string + "<td>" + map.get("machine") + "</td>";
                string = string + "<td>" + (n > 0 ? n + "" : "") + "</td>";
                string = string + "<td>" + map.get("message") + "</td>";
                string = string + "</tr>";
            }
            string = string + "</tbody></table>";
            return string;
        }
        catch (Exception exception) {
            return "Couldn't get execution logs, error:" + exception.getMessage();
        }
    }

    private String getXML(List<String> list, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        string = SchedulerAlert.escapeChar(string);
        String string3 = "<IMONITOR>";
        for (String string4 : list) {
            string3 = string3 + "<THEME>" + string4 + "</THEME>";
        }
        string3 = string3 + "<SUBJECT>" + string + "</SUBJECT>";
        string3 = string3 + "<BODY><![CDATA[" + string2 + "]]></BODY>";
        string3 = string3 + "<OVERRIDEALARMLEVEL>m</OVERRIDEALARMLEVEL> ";
        string3 = string3 + "<SAY>" + (bl + "").toUpperCase() + "</SAY> ";
        string3 = string3 + "<EMAIL>" + (bl2 + "").toUpperCase() + "</EMAIL>";
        string3 = string3 + "<PHONE>" + (bl3 + "").toUpperCase() + "</PHONE>";
        string3 = string3 + "<ESCALATETICKS>5</ESCALATETICKS>";
        string3 = string3 + "<ESCALATEINTERVAL>15</ESCALATEINTERVAL>";
        string3 = string3 + "</IMONITOR>";
        return string3;
    }

    public static void alert(ArrayList arrayList, String string, String string2, String string3, String string4, String string5) throws Exception {
        if (arrayList != null && arrayList.size() > 0 && string3 != null && string != null) {
            String string6 = Config.getValue("scheduler.ignore.alert");
            if (!(string.trim().equalsIgnoreCase("No Alert") || string6 != null && string6.equalsIgnoreCase("true"))) {
                String string7 = string.equalsIgnoreCase("phone") ? "Phone:" : "";
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = false;
                String string8 = SchedulerAlert.getXMLWithFile(arrayList, string2, string3, bl, bl2, bl3, string4, string5);
                Logger logger = Logger.getLogger(SchedulerAlert.class);
                logger.debug((Object)("Sending alert:xml:" + string8));
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.fe.scheduler.scheduleralert");
                boolean bl4 = Boolean.parseBoolean(resourceBundle.getString("scheduler.alert.dump"));
                if (bl4) {
                    String string9 = resourceBundle.getString("scheduler.alert.dump.folder");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                    string9 = string9 + simpleDateFormat.format(new Date()) + "/";
                    File file = new File(string9);
                    file.mkdirs();
                    SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HHmmss");
                    PrintWriter printWriter = new PrintWriter(string9 + simpleDateFormat2.format(new Date()) + "-" + string5 + "-" + string + ".xml", "UTF-8");
                    printWriter.println(string8);
                    printWriter.close();
                } else {
                    SchedulerAlert.sendXML(string8);
                }
            }
        }
    }

    private static String getXMLWithFile(List<String> list, String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4) {
        string = SchedulerAlert.escapeChar(string);
        String string5 = "<IMONITOR>";
        for (String string6 : list) {
            string5 = string5 + "<THEME>" + string6 + "</THEME>";
        }
        string5 = string5 + "<SUBJECT>" + string + "</SUBJECT>";
        string5 = string5 + "<BODY><![CDATA[" + string2 + "]]></BODY>";
        string5 = string5 + "<OVERRIDEALARMLEVEL>m</OVERRIDEALARMLEVEL> ";
        string5 = string5 + "<SAY>" + (bl + "").toUpperCase() + "</SAY> ";
        string5 = string5 + "<EMAIL>" + (bl2 + "").toUpperCase() + "</EMAIL>";
        string5 = string5 + "<PHONE>" + (bl3 + "").toUpperCase() + "</PHONE>";
        string5 = string5 + "<ESCALATETICKS>5</ESCALATETICKS>";
        string5 = string5 + "<ESCALATEINTERVAL>15</ESCALATEINTERVAL>";
        if (string3 != null) {
            string5 = string5 + "<EMAILIMAGES>" + string3 + "</EMAILIMAGES>";
        }
        if (string4 != null) {
            string5 = string5 + "<EXCLUDEADDRESS>" + string4 + "</EXCLUDEADDRESS>";
        }
        string5 = string5 + "</IMONITOR>";
        return string5;
    }

    private static String sendXML(String string) throws Exception {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.fe.scheduler.scheduleralert");
            String string2 = resourceBundle.getString("imonitor.url");
            String string3 = null;
            PostMethod postMethod = new PostMethod(string2);
            try {
                postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(string, "text/xml", null));
                postMethod.setRequestHeader("Content-type", "text/xml; utf-8");
                HttpClient httpClient = new HttpClient();
                int n = httpClient.executeMethod((HttpMethod)postMethod);
                string3 = postMethod.getResponseBodyAsString();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                postMethod.releaseConnection();
            }
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private static String escapeChar(String string) {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("\"", "&quot;");
        string2 = string2.replaceAll("'", "&apos;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        return string2;
    }
}

