/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.client.BBSyncMgmt;
import com.fe.db.SchedulerDB;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SchedulerExePlanLogs {
    public static final int SERVER_OK_FIXEDPEER = 2000;
    public static final int SERVER_OK_REMOVED_FROM_PQUEUE = 2001;
    public static final int SERVER_OK_RECEIVED_STATUS_FROM_PEER = 2002;
    public static final int SERVER_OK_PEER_ACCEPTED_TASK = 2003;
    public static final int SERVER_ERROR_EXEC_TIMEDOUT = 3000;
    public static final int SERVER_ERROR_QUEUE_KILLED_BYUSER = 3001;
    public static final int SERVER_ERROR_PEER_CRASHED_REMOVED_QUEUE = 3002;
    public static final int SERVER_ERROR_PEER_NORESP_REMOVED_QUEUE = 3003;
    public static final int SERVER_ERROR_WHILE_ADDING_QUEUE = 3004;
    public static final int SERVER_ERROR_ALARM_SENT = 3005;
    public static final int SERVER_ERROR_REMOVING_QUEUE_BASEDON_LOG = 3006;
    public static final int SERVER_ERROR_DEPENDENCY_TIMEDOUT = 3007;
    public static final int SERVER_ERROR_REMOVING_QUEUE_PEER_NO_RESPONSE = 3008;
    public static final int SERVER_ERROR_REMOVE_QUEUE_NOTRUNNING_INPEER = 3009;
    public static final int SERVER_WARNING_OVERLAPPED = 4000;
    public static final int SERVER_WARNING_BOUNCEDTASK_FROMPEER = 4002;
    public static final int PEER_OK_BLOOMBERG_DOWNLOAD = 5000;
    public static final int PEER_OK_UNIX_RSERVE_CAPTURE_PROCESSINFO = 5001;
    public static final int PEER_OK_RSERVE_SCRIPT_EVAL_STARTING = 5002;
    public static final int PEER_OK_RENGINE_SCRIPT_EVAL_STARTING = 5003;
    public static final int PEER_OK_ADDED_PEER_QUEUE = 5004;
    public static final int PEER_OK_EXECUTION_STARTING = 5005;
    public static final int PEER_OK_EXECUTION_COMPLETED_WITH_NOEXCEPTION = 5006;
    public static final int PEER_OK_PEER_RECEVED_TASK = 5007;
    public static final int PEER_OK_RESPOND_TASKCOMPLETED_WITHSTATUS = 5008;
    public static final int PEER_OK_RESPOND_RSERVE_SESSIONSTARTED = 5009;
    public static final int PEER_ERROR_WHILE_RECEIVINGTASK = 6000;
    public static final int PEER_ERROR_EXECUTION_FAILURE = 6001;
    public static final int PEER_ERROR_EXECUTION_COMPLETED_WITH_EXCEPTION = 6002;
    public static final int PEER_WARNING_NOROOM_TO_EXEC = 7000;
    public static final int IGNORE_CODE = 0;
    private long trigger_time;
    private int scheduler_id;
    private Logger log = Logger.getLogger(SchedulerExePlanLogs.class);

    public SchedulerExePlanLogs(int n, long l) {
        this.scheduler_id = n;
        this.trigger_time = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String string, int n) {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.addSchedulerExeLogs(this.scheduler_id, this.trigger_time, new Date(), string, n);
        }
        catch (Exception exception) {
            this.log.error((Object)("error:" + exception.getMessage()));
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {
                this.log.error((Object)("error:" + exception.getMessage()));
            }
        }
    }

    public void log(String string, Map map, int n) {
        try {
            String string2 = this.getMessage(string, map);
            this.log(string2, n);
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    public void log(String string, SchedulerDB schedulerDB, int n) {
        try {
            schedulerDB.addSchedulerExeLogs(this.scheduler_id, this.trigger_time, new Date(), string, n);
        }
        catch (Exception exception) {
            this.log.error((Object)("error:" + exception.getMessage()));
        }
    }

    private String getMessage(String string, Map map) throws Exception {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.fe.scheduler.logmessages");
        String string2 = string;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string + " !key:not_found!";
        }
        string2 = this.replaceNewValues(string2, map != null ? map : new HashMap());
        return string2;
    }

    private String replaceNewValues(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("\\[(.*?)\\]", 32);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (map.get(string2) != null) {
                String string3 = map.get(string2).toString();
                if (string3 == null) {
                    matcher.appendReplacement(stringBuffer, "");
                    continue;
                }
                matcher.appendReplacement(stringBuffer, string3);
                continue;
            }
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

