/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance;

import com.fe.client.BBSyncMgmt;
import com.fe.db.SchedulerDB;
import com.fe.db.SuperDB;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.SchedulerAlert;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.balance.LoadBalancingQueueTimeout;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class WaitingQueueList<E>
extends ConcurrentLinkedQueue {
    private static TreeMap<String, Long> task_stat_max_waiting = new TreeMap();
    private static Timer timer = null;
    private static Map<String, String> alert_range = null;
    private static JCS cache = null;
    private Logger log = Logger.getLogger(WaitingQueueList.class);
    private static int ALERT_FREQUENCY_MINUTES = 5;
    private static WaitingQueueList localqueue = null;

    @Override
    public boolean add(Object object) {
        boolean bl = super.add(object);
        if (localqueue == null) {
            localqueue = this;
        }
        if (timer == null) {
            this.startTimer();
        }
        return bl;
    }

    public static void setAlertRange(Map<String, String> map) {
        alert_range = map;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void calculateQueueAndAlertTraffic() throws Exception {
        if (alert_range != null && WaitingQueueList.getCache().get((Object)"alerted") == null && localqueue.size() > 0) {
            String string;
            Object exception2;
            Object object;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object722;
            task_stat_max_waiting.clear();
            for (Object object722 : localqueue) {
                object6 = ((LoadBalancingQueueItem)object722).getSf().getData();
                object5 = (String)object6.get(ScheduledTask.FIELD_DEPENDENCY_IDS);
                if (object5 != null) continue;
                object4 = ((LoadBalancingQueueItem)object722).getSf().getTask().getUniqueid();
                object3 = new Date().getTime() - ((LoadBalancingQueueItem)object722).getSf().getTrigger_time();
                if (task_stat_max_waiting.containsKey(object4)) {
                    object3 = task_stat_max_waiting.get(object4) > (Long)object3 ? task_stat_max_waiting.get(object4) : object3;
                }
                task_stat_max_waiting.put((String)object4, (Long)object3);
            }
            Object object8 = "";
            object722 = new ScheduledTaskFactory();
            object6 = new SimpleDateFormat("HH:mm:ss 'Hrs'");
            ((DateFormat)object6).setTimeZone(TimeZone.getTimeZone("GMT"));
            object5 = new SimpleDateFormat("mm:ss 'Mins'");
            ((DateFormat)object5).setTimeZone(TimeZone.getTimeZone("GMT"));
            object4 = new Date();
            for (String object9 : alert_range.keySet()) {
                object = null;
                try {
                    object = Long.parseLong(alert_range.get(object9));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object == null || !task_stat_max_waiting.containsKey(object9) || task_stat_max_waiting.get(object9) <= (Long)object * 1000L * 60L) continue;
                exception2 = ((ScheduledTaskFactory)object722).getTask(object9);
                ((Date)object4).setTime(task_stat_max_waiting.get(object9));
                object8 = task_stat_max_waiting.get(object9) >= 3600000L ? (String)object8 + ((ScheduledTask)exception2).getName() + "(" + ((DateFormat)object6).format((Date)object4) + ") " : (String)object8 + ((ScheduledTask)exception2).getName() + "(" + ((DateFormat)object5).format((Date)object4) + ") ";
                string = WaitingQueueList.getCache().getDefaultElementAttributes();
                string.setMaxLifeSeconds((long)(ALERT_FREQUENCY_MINUTES * 60));
                WaitingQueueList.getCache().put((Object)"alerted", (Object)"alerted", (IElementAttributes)string);
            }
            if (!((String)object8).equals("")) {
                object3 = SchedulerDB.getSchedulerDB();
                try {
                    ((SuperDB)object3).connectDB(BBSyncMgmt.getDBName());
                    LoadBalancingQueueTimeout exception = new LoadBalancingQueueTimeout((SchedulerDB)object3, ((ScheduledTaskFactory)object722).getTaskUids());
                    object = exception.getAlert_theme();
                    exception2 = exception.getAlert_type();
                    string = "Slow moving of Scheduler Queue";
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(object);
                    SchedulerAlert.alert(arrayList, (String)exception2, string, (String)object8, null, null);
                }
                catch (Exception exception) {
                    System.out.println("Error WaitingQueueList.calculateQueueAndAlertTraffic(): e:" + exception.getMessage());
                }
            }
        }
    }

    private static JCS getCache() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)WaitingQueueList.class.getName());
        }
        return cache;
    }

    private void startTimer() {
        timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    WaitingQueueList.calculateQueueAndAlertTraffic();
                }
                catch (Exception exception) {
                    WaitingQueueList.this.log.error((Object)("Error " + exception.getMessage()));
                }
            }
        };
        timer.schedule(timerTask, 60000L, 60000L);
    }
}

