/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.engines;

import com.fe.Config;
import com.fe.client.ClientErrorMgmt;
import com.fe.p2p.P2PService;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.exception.ExceptionRServeUnixFailure;
import com.fe.scheduler.rserve.RServeConnectionPool;
import com.fe.scheduler.rserve.RServeSession;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionException;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;

public abstract class ExecuteRUnix
extends ScheduledTask {
    private Logger log = Logger.getLogger(ExecuteRUnix.class);
    private StackFrame stackframe = null;

    public ExecuteRUnix(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void execute(StackFrame stackFrame) throws JobExecutionException, Exception {
        this.stackframe = stackFrame;
        Map map = stackFrame.getData();
        if (stackFrame.getRscript() == null) {
            throw new JobExecutionException("Script failed as StackFrame doesn't containt RScript object");
        }
        String string = stackFrame.getRscript().getScript();
        if (string == null) {
            throw new JobExecutionException("Task Failed because no R script found or empty");
        }
        this.log.debug((Object)"R Engine initiated.");
        if (string != null && !string.equals("")) {
            try {
                block15: {
                    String string2;
                    this.log.debug((Object)"R init source file initiated.");
                    String string3 = System.getProperty("java.io.tmpdir");
                    this.log.debug((Object)("set temporary directory:" + string3));
                    File file = new File(string3 + File.separator + "rscript" + new SimpleDateFormat("mmddyyy_hh_mmss_").format(new Date()) + new Random().nextInt() + ".R");
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(Config.getString("r_script_init")));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2 == null || string2.equals("")) continue;
                        stringBuffer.append(string2 + "\n");
                    }
                    bufferedReader.close();
                    this.log.debug((Object)"R init source file initiated.");
                    String string4 = file.getPath().replaceAll("\\\\", "\\\\\\\\");
                    RConnection rConnection = null;
                    RServeSession rServeSession = null;
                    try {
                        this.log.debug((Object)"before opening session----<");
                        this.log.debug((Object)("rs:" + rServeSession));
                        rServeSession = this.getRServeSession(stackFrame.getRscript().getUid(), stringBuffer.toString());
                        if (rServeSession != null && rServeSession.getRconnection() != null) {
                            String string5;
                            rConnection = rServeSession.getRconnection();
                            this.log.debug((Object)("c:" + rConnection.isConnected()));
                            REXP rEXP = rConnection.eval(".r_session_id");
                            if (rEXP != null) {
                                string5 = rEXP.asString();
                                this.log.debug((Object)(".r_session_id:" + string5));
                            }
                            rConnection.assign(".machine", P2PService.getComputerName());
                            this.log.debug((Object)("rscript:" + string));
                            string5 = rConnection.parseAndEval(string);
                            String string6 = this.parse((REXP)string5);
                            stackFrame.getRscript().setResultXML(string6);
                            this.log.debug((Object)"Script from temp file Evaluated");
                            this.log.debug((Object)("x1:" + string5));
                            if (string5 != null && string5.inherits("try-error")) {
                                throw new Exception("Error in R Script: " + string5.asString());
                            }
                            if (string5 == null) {
                                throw new Exception("R script:" + map.get("name") + " failed");
                            }
                            stackFrame.setTasklog(null);
                        }
                        file.delete();
                        if (rConnection == null) break block15;
                    }
                    catch (Exception exception) {
                        try {
                            stackFrame.setTasklog(exception.getMessage());
                            stackFrame.getRscript().setError(exception.getMessage());
                            throw new Exception("Error:" + exception.getMessage());
                        }
                        catch (Throwable throwable) {
                            if (rConnection != null) {
                                this.closeRconnection(rServeSession);
                            }
                            Runtime.getRuntime().gc();
                            throw throwable;
                        }
                    }
                    this.closeRconnection(rServeSession);
                }
                Runtime.getRuntime().gc();
            }
            catch (Exception exception) {
                ClientErrorMgmt.reportError(exception, null);
                throw exception;
            }
        }
    }

    private String parse(REXP rEXP) throws Exception {
        String string = "";
        if (rEXP.isNumeric()) {
            string = string + "<double>" + rEXP.asDouble() + "</double>";
        }
        if (rEXP.isInteger()) {
            string = string + "<integer>" + rEXP.asInteger() + "</integer>";
        }
        if (rEXP.isList()) {
            RList rList = rEXP.asList();
            string = string + "<array>";
            for (Object e : rList) {
                if (!(e instanceof REXP)) continue;
                if (rEXP.isNumeric()) {
                    string = string + "<double>" + ((REXP)e).asDouble() + "</double>";
                }
                if (rEXP.isString()) {
                    string = string + "<string>" + ((REXP)e).asString() + "</string>";
                }
                if (!rEXP.isString()) continue;
                string = string + "<integer>" + ((REXP)e).asInteger() + "</integer>";
            }
            string = string + "</array>";
        }
        if (rEXP.isString()) {
            string = string + "<string>" + rEXP.asString() + "</string>";
        }
        return string;
    }

    public RServeSession getRServeSession(String string, String string2) throws Exception {
        RServeSession rServeSession = null;
        RConnection rConnection = null;
        try {
            rServeSession = RServeConnectionPool.getRSession(string2);
        }
        catch (Exception exception) {
            throw new ExceptionRServeUnixFailure("Not able to get RSession from ConnectionPool!, Error:" + exception.getMessage());
        }
        try {
            this.log.debug((Object)"+++++++attaches Rconnection from RServeSession....+++");
            rConnection = rServeSession.getRconnection() != null ? rServeSession.getRconnection() : rServeSession.getRsession().attach();
            rServeSession.setRconnection(rConnection);
        }
        catch (Exception exception) {
            throw new ExceptionRServeUnixFailure("Not able to attach connection to RSession!, Error:" + exception.getMessage());
        }
        if (rConnection != null) {
            this.log.debug((Object)("c:" + rConnection.isConnected()));
            rServeSession.setRunning(true);
            rServeSession.setExecute_r_uid(string);
            rServeSession.setStarted_time(new Date().getTime());
            rServeSession.setThread(Thread.currentThread());
        }
        return rServeSession;
    }

    private void closeRconnection(RServeSession rServeSession) throws Exception {
        try {
            rServeSession.finished(rServeSession.getRconnection());
            RServeConnectionPool.done(rServeSession);
        }
        catch (Exception exception) {
            if (rServeSession.getKillmessage() != null) {
                throw new ExceptionRServeUnixFailure(rServeSession.getKillmessage());
            }
            throw new ExceptionRServeUnixFailure("Not able to detach RSession!, Error:" + exception.getMessage());
        }
    }
}

