/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.rscript;

import com.fe.Config;
import com.fe.client.ClientErrorMgmt;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptListener;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class RScriptAsyncListenerImpl
implements RScriptListener {
    private Logger log = Logger.getLogger(RScriptAsyncListenerImpl.class);
    private String peer = null;
    private String result = null;
    private JCS cache;
    private IElementAttributes att;
    private Date started = null;
    public static String ALIVE = "alive";

    public RScriptAsyncListenerImpl(JCS jCS, IElementAttributes iElementAttributes) throws Exception {
        this.cache = jCS;
        this.att = iElementAttributes;
    }

    @Override
    public void onScriptSent(RScript rScript, String string) throws Exception {
        this.peer = string;
        this.log.debug((Object)("+++++  Script started....started:" + rScript.getScript() + " peer:" + string));
        if (this.cache != null) {
            this.cache.put((Object)rScript.getUid(), (Object)ALIVE, this.att);
        }
        this.started = new Date();
    }

    public String getPeer() {
        return this.peer;
    }

    public String getResult() {
        return this.result;
    }

    @Override
    public void onScriptFinished(RScript rScript, String string, String string2, String string3) throws Exception {
        this.peer = string;
        this.result = string2;
        this.log.debug((Object)("~~~~~~ rscript.getUid():" + rScript.getUid() + " result:" + string2 + " this.att:" + this.att));
        if (this.cache != null) {
            this.cache.put((Object)rScript.getUid(), (Object)string2, this.att);
        }
        String string4 = "";
        String string5 = this.started != null ? this.started.getTime() + "" : "";
        string4 = string4 + string3 + "\t" + rScript.getPeer() + "\t" + rScript.getQueued_time() + "\t" + string5 + "\t" + new Date().getTime() + "\t" + rScript.getRequesthost() + "\t" + rScript.getUniquename();
        this.log.debug((Object)("~~~~~~ Script started....rscript.getError():" + rScript.getError()));
        if (string3.equalsIgnoreCase("fail") && rScript.getError() != null) {
            string4 = string4 + "\tError:" + RScriptAsyncListenerImpl.readFirst(rScript.getError(), 100);
        }
        RScriptAsyncListenerImpl.log(string4);
    }

    @Override
    public void onScriptTimedOut(RScript rScript) throws Exception {
        this.result = "<?xml version=\"1.0\"?><output status=\"TimedOut\">Script kicked out from the queue because scheduler couldn't find peer within the time limit</output>";
        if (this.cache != null) {
            this.cache.put((Object)rScript.getUid(), (Object)this.result, this.att);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm SSS");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd MMM-yy HH:mm:ss SSS");
        String string = "TimedOut\t\t" + rScript.getQueued_time() + "\t\t" + new Date().getTime() + "\t" + rScript.getRequesthost() + "\t" + rScript.getUniquename();
        RScriptAsyncListenerImpl.log(string);
    }

    protected static String readFirst(String string, int n) {
        String string2 = string.length() > n ? string.substring(0, n) + "...." : string;
        string2 = string2.trim();
        string2 = string2.replaceAll("\n", " ");
        string2 = string2.replaceAll("\r", " ");
        return string2;
    }

    protected static void log(String string) {
        String string2;
        File file;
        Date date = new Date();
        String string3 = Config.getString("log_executeR_folder") != null && !Config.getString("log_executeR_folder").equals("") ? Config.getString("log_executeR_folder") : Config.getString("log_error_folder");
        String string4 = string3 + "direct_scripts";
        if (!new File(string4).isDirectory()) {
            new File(string4).mkdirs();
        }
        if (!(file = new File(string2 = string3 + "direct_scripts" + File.separator + "" + new SimpleDateFormat("dd_MM_yyyy").format(date) + ".txt")).exists()) {
            try {
                FileWriter fileWriter = new FileWriter(file, true);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            boolean bl = true;
            FileWriter fileWriter = new FileWriter(file, bl);
            fileWriter.append(string + "\r\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "Error in external log file writing");
        }
    }
}

