/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.rserve;

import com.fe.util.RandomString;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RSession;

public class ConnectionPool {
    private static Vector<RSession> sessions = new Vector();
    private static Vector<RSession> sessInUse = new Vector();
    private static final Semaphore sessLock = new Semaphore(1, true);
    private static long TIMEOUT_MS = 2000L;

    private static void acquireLock() {
        try {
            Date date = new Date();
            sessLock.tryAcquire(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            Logger.getLogger(ConnectionPool.class).error((Object)("acquireLock() error:" + exception.getMessage()));
        }
    }

    private static void releaseLock() {
        try {
            sessLock.release();
            Logger.getLogger(ConnectionPool.class).debug((Object)("....releasing lock: thread:" + Thread.currentThread().getId()));
        }
        catch (Exception exception) {
            Logger.getLogger(ConnectionPool.class).error((Object)("acquireLock() error:" + exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized RSession getRSession() throws Exception {
        ConnectionPool.acquireLock();
        try {
            RSession rSession = null;
            if (sessions.size() > 0) {
                rSession = sessions.lastElement();
                sessions.remove(rSession);
                sessInUse.add(rSession);
            } else {
                RConnection rConnection = null;
                for (int i = 0; rConnection == null && i < 10; ++i) {
                    try {
                        rConnection = new RConnection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (rConnection != null) {
                    rConnection.assign(".r_session_id", new RandomString(30).nextString());
                    rSession = rConnection.detach();
                    sessInUse.add(rSession);
                }
            }
            RSession rSession2 = rSession;
            return rSession2;
        }
        finally {
            ConnectionPool.releaseLock();
        }
    }

    public static List<RSession> getInActiveSessions() {
        ArrayList<RSession> arrayList = new ArrayList<RSession>();
        for (RSession rSession : sessions) {
            arrayList.add(rSession);
        }
        return arrayList;
    }

    public static List<RSession> getActiveSessions() {
        ArrayList<RSession> arrayList = new ArrayList<RSession>();
        for (RSession rSession : sessInUse) {
            arrayList.add(rSession);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void done(RSession rSession) throws Exception {
        ConnectionPool.acquireLock();
        try {
            sessInUse.remove(rSession);
            sessions.add(rSession);
        }
        finally {
            ConnectionPool.releaseLock();
        }
    }
}

