/*
 * Decompiled with CFR 0.152.
 */
package com.fe.svn;

import com.fe.Config;
import com.fe.svn.LogEntryHandler;
import com.fe.svn.SVNSync4RFunction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public abstract class SVNSyncFile {
    private Logger log = Logger.getLogger(SVNSync4RFunction.class);
    private String svnurl = null;
    private String local;
    private File dstPath = null;
    SVNClientManager cm = null;

    public abstract String getExtension();

    private void init(String string, String string2, String string3, String string4) {
        SVNSyncFile.setupLibrary();
        this.cm = SVNClientManager.newInstance((DefaultSVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (String)string, (String)string2);
        this.svnurl = string3;
        this.local = string4;
        this.dstPath = new File(this.local);
    }

    public SVNSyncFile(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4);
    }

    public SVNSyncFile(String string, String string2) {
        String string3 = Config.getString("svn_user");
        String string4 = Config.getString("svn_pwd");
        this.init(string3, string4, string, string2);
    }

    public void syncFile(String string, String string2, String string3) {
        try {
            String string4;
            SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.svnurl);
            this.log.debug((Object)("this.svnurl:" + this.svnurl));
            SVNUpdateClient sVNUpdateClient = this.cm.getUpdateClient();
            if (!SVNWCUtil.isVersionedDirectory((File)this.dstPath)) {
                sVNUpdateClient.doCheckout(sVNURL, this.dstPath, SVNRevision.UNDEFINED, SVNRevision.HEAD, true);
                sVNUpdateClient.doUpdate(this.dstPath, SVNRevision.HEAD, true);
            } else {
                this.log.debug((Object)("~~~~~~" + this.dstPath.getPath() + " it is already working copy...."));
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
            StringBuffer stringBuffer = new StringBuffer();
            File file = new File(this.local.endsWith(File.separator) ? this.local : this.local + File.separator, string + this.getExtension());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4 != null && string4.equals("")) {
                    bufferedWriter.write(string4 + "\n");
                }
                if (string4 == null || string4.equals("")) continue;
                bufferedWriter.write(string4 + "\n");
            }
            bufferedWriter.close();
            bufferedReader.close();
            SVNWCClient sVNWCClient = this.cm.getWCClient();
            try {
                sVNWCClient.doInfo(file, SVNRevision.HEAD);
            }
            catch (SVNException sVNException) {
                if (sVNException.getMessage().contains("is not under version control")) {
                    sVNWCClient.doAdd(file, false, false, false, true);
                    this.log.debug((Object)("~~~~~ file:" + file + " is not under version control"));
                }
                this.log.debug((Object)("~~~~~ file:" + file + " is under version control"));
            }
            SVNCommitClient sVNCommitClient = this.cm.getCommitClient();
            sVNCommitClient.doCommit(new File[]{file}, false, string3, false, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteFile(String string) {
        try {
            SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.svnurl);
            this.log.debug((Object)("this.svnurl:" + this.svnurl));
            File file = new File(this.local.endsWith(File.separator) ? this.local : this.local + File.separator, string + this.getExtension());
            SVNWCClient sVNWCClient = this.cm.getWCClient();
            try {
                sVNWCClient.doDelete(file, true, false);
            }
            catch (SVNException sVNException) {
                this.log.error((Object)("Error occured while deleting, Error:" + sVNException.getMessage()));
            }
            SVNCommitClient sVNCommitClient = this.cm.getCommitClient();
            sVNCommitClient.doCommit(new File[]{file}, false, "deleted", false, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void renameFile(String string, String string2, String string3, String string4) {
        try {
            String string5;
            SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.svnurl);
            this.log.debug((Object)("this.svnurl:" + this.svnurl));
            File file = new File(this.local.endsWith(File.separator) ? this.local : this.local + File.separator, string2 + this.getExtension());
            File file2 = new File(this.local.endsWith(File.separator) ? this.local : this.local + File.separator, string + this.getExtension());
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
            StringBuffer stringBuffer = new StringBuffer();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            while ((string5 = bufferedReader.readLine()) != null) {
                if (string5 != null && string5.equals("")) {
                    bufferedWriter.write(string5 + "\n");
                }
                if (string5 == null || string5.equals("")) continue;
                bufferedWriter.write(string5 + "\n");
            }
            bufferedWriter.close();
            bufferedReader.close();
            SVNWCClient sVNWCClient = this.cm.getWCClient();
            try {
                sVNWCClient.doInfo(file2, SVNRevision.HEAD);
            }
            catch (SVNException sVNException) {
                if (sVNException.getMessage().contains("is not under version control")) {
                    sVNWCClient.doAdd(file2, false, false, false, true);
                    this.log.debug((Object)("~~~~~ file:" + file + " is not under version control"));
                }
                this.log.debug((Object)("~~~~~ file:" + file + " is under version control"));
            }
            SVNMoveClient sVNMoveClient = this.cm.getMoveClient();
            sVNMoveClient.doMove(file2, file);
            SVNCommitClient sVNCommitClient = this.cm.getCommitClient();
            sVNCommitClient.doCommit(new File[]{file2, file}, false, string4, false, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector<SVNLogEntry> log(String string) throws Exception {
        File file = new File(this.local.endsWith(File.separator) ? this.local : this.local + File.separator, string + this.getExtension());
        Vector<SVNLogEntry> vector = null;
        if (file.exists()) {
            SVNLogClient sVNLogClient = this.cm.getLogClient();
            long l = 250L;
            LogEntryHandler logEntryHandler = new LogEntryHandler();
            sVNLogClient.doLog(new File[]{file}, SVNRevision.create((long)0L), SVNRevision.create((long)0L), SVNRevision.HEAD, false, true, l, (ISVNLogEntryHandler)logEntryHandler);
            while (logEntryHandler.getLogMessages() == null) {
                Thread.sleep(100L);
            }
            vector = logEntryHandler.getLogMessages();
            Thread.sleep(100L);
        }
        return vector;
    }

    public TreeSet<Long> revisions(String string) throws Exception {
        File file = new File(this.local.endsWith(File.separator) ? this.local : this.local + File.separator, string + this.getExtension());
        TreeSet<Long> treeSet = new TreeSet<Long>();
        if (file.exists()) {
            SVNLogClient sVNLogClient = this.cm.getLogClient();
            LogEntryHandler logEntryHandler = new LogEntryHandler();
            sVNLogClient.doLog(new File[]{file}, SVNRevision.create((long)0L), SVNRevision.create((long)0L), SVNRevision.HEAD, true, true, 0L, (ISVNLogEntryHandler)logEntryHandler);
            while (logEntryHandler.getLogMessages() == null) {
                Thread.sleep(100L);
            }
            Vector<SVNLogEntry> vector = logEntryHandler.getLogMessages();
            Thread.sleep(100L);
            for (SVNLogEntry sVNLogEntry : vector) {
                treeSet.add(sVNLogEntry.getRevision());
            }
        }
        return treeSet;
    }

    public Long firstRevision(String string) throws Exception {
        TreeSet<Long> treeSet = this.revisions(string);
        return treeSet.size() > 0 ? treeSet.first() : 0L;
    }

    public Long lastRevision(String string) throws Exception {
        TreeSet<Long> treeSet = this.revisions(string);
        return treeSet.size() > 0 ? treeSet.last() : 0L;
    }

    public String getWhatChanged(String string, Long l) throws Exception {
        StringTokenizer stringTokenizer;
        long l2;
        TreeSet<Long> treeSet = this.revisions(string);
        Vector<Long> vector = new Vector<Long>(treeSet);
        String string2 = null;
        if (vector.indexOf(l) > 0 && (string2 = this.diff(string, l2 = vector.get(vector.indexOf(l) - 1).longValue(), l)) != null && (stringTokenizer = new StringTokenizer(string2, "\n\r")).countTokens() >= 4) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + stringTokenizer.nextToken() + "\n";
            }
        }
        return string2;
    }

    public String getLastChanged(String string) throws Exception {
        StringTokenizer stringTokenizer;
        long l;
        TreeSet<Long> treeSet = this.revisions(string);
        Vector<Long> vector = new Vector<Long>(treeSet);
        String string2 = null;
        if (treeSet.size() > 0 && vector.indexOf(treeSet.last()) > 0 && (string2 = this.diff(string, l = vector.get(vector.indexOf(treeSet.last()) - 1).longValue(), treeSet.last())) != null && (stringTokenizer = new StringTokenizer(string2, "\n\r")).countTokens() >= 4) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + stringTokenizer.nextToken() + "\n";
            }
        }
        return string2;
    }

    public Vector<SVNDirEntry> logTest() throws Exception {
        SVNLogClient sVNLogClient = this.cm.getLogClient();
        long l = 50L;
        LogEntryHandler logEntryHandler = new LogEntryHandler();
        SVNURL sVNURL = SVNURL.parseURIEncoded((String)this.svnurl);
        sVNLogClient.doLog(sVNURL, new String[0], SVNRevision.create((long)0L), SVNRevision.create((long)0L), SVNRevision.HEAD, true, true, 1L, (ISVNLogEntryHandler)logEntryHandler);
        while (logEntryHandler.getLogMessages() == null) {
            Thread.sleep(100L);
        }
        Vector<SVNLogEntry> vector = logEntryHandler.getLogMessages();
        Thread.sleep(100L);
        return vector;
    }

    public String diff(String string, long l, long l2) throws Exception {
        File file = new File(this.local.endsWith(File.separator) ? this.local : this.local + File.separator, string + this.getExtension());
        String string2 = null;
        if (file.exists()) {
            SVNDiffClient sVNDiffClient = this.cm.getDiffClient();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sVNDiffClient.doDiff(file, SVNRevision.create((long)l), SVNRevision.create((long)l), SVNRevision.create((long)l2), true, false, (OutputStream)byteArrayOutputStream);
            string2 = byteArrayOutputStream.toString();
        }
        return string2;
    }

    public String diffWC(String string, long l) throws Exception {
        File file = new File(this.local.endsWith(File.separator) ? this.local : this.local + File.separator, string + this.getExtension());
        String string2 = null;
        if (!file.exists()) {
            throw new Exception("File:" + file.getPath() + " doesn't exist");
        }
        SVNDiffClient sVNDiffClient = this.cm.getDiffClient();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sVNDiffClient.doDiff(file, SVNRevision.create((long)l), SVNRevision.create((long)l), SVNRevision.HEAD, true, false, (OutputStream)byteArrayOutputStream);
        string2 = byteArrayOutputStream.toString();
        return string2;
    }

    public String getScript(String string, long l, String string2) throws Exception {
        Object object;
        Object object2;
        StringTokenizer stringTokenizer;
        SVNRepository sVNRepository = this.cm.createRepository(SVNURL.parseURIEncoded((String)this.svnurl), false);
        Object object3 = string + this.getExtension();
        if (string2 != null && !string2.trim().equals("")) {
            if (string2.indexOf(",") >= 0) {
                stringTokenizer = new StringTokenizer(string2, ",");
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens() && !bl) {
                    object2 = stringTokenizer.nextToken();
                    object = sVNRepository.checkPath((String)object2, l);
                    if (object != SVNNodeKind.FILE) continue;
                    object3 = object2;
                    bl = true;
                }
            } else {
                object3 = string2;
            }
        }
        this.log.debug((Object)("filepath:" + (String)object3));
        stringTokenizer = sVNRepository.checkPath((String)object3, l);
        if (stringTokenizer == SVNNodeKind.NONE) {
            throw new Exception("There is no entry at '" + this.svnurl + "'.");
        }
        if (stringTokenizer == SVNNodeKind.DIR) {
            throw new Exception("The entry at '" + this.svnurl + "' is a directory while a file was expected.");
        }
        SVNProperties sVNProperties = new SVNProperties();
        object2 = new ByteArrayOutputStream();
        sVNRepository.getFile((String)object3, l, sVNProperties, (OutputStream)object2);
        object = sVNProperties.asMap();
        String string3 = (String)object.get("svn:mime-type");
        boolean bl = SVNProperty.isTextMimeType((String)string3);
        String string4 = null;
        if (bl) {
            string4 = ((ByteArrayOutputStream)object2).toString();
        } else {
            System.out.println("Not a text file.");
        }
        return string4;
    }

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }
}

