/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccess;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccessAttributes;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccessFactory;
import org.apache.jcs.utils.config.PropertySetter;

public class JDBCDiskCachePoolAccessManager {
    private static JDBCDiskCachePoolAccessManager instance;
    private Map pools = new HashMap();
    public static final String POOL_CONFIGURATION_PREFIX = "jcs.jdbcconnectionpool.";
    public static final String ATTRIBUTE_PREFIX = ".attributes";
    private static final Log log;
    private Properties props = null;

    private JDBCDiskCachePoolAccessManager(Properties props) {
        this.setProps(props);
    }

    public static synchronized JDBCDiskCachePoolAccessManager getInstance(Properties props) {
        if (instance == null) {
            instance = new JDBCDiskCachePoolAccessManager(props);
        }
        return instance;
    }

    public synchronized JDBCDiskCachePoolAccess getJDBCDiskCachePoolAccess(String poolName) {
        JDBCDiskCachePoolAccess poolAccess = (JDBCDiskCachePoolAccess)this.pools.get(poolName);
        if (poolAccess == null) {
            JDBCDiskCachePoolAccessAttributes poolAttributes = this.configurePoolAccessAttributes(poolName);
            try {
                poolAccess = JDBCDiskCachePoolAccessFactory.createPoolAccess(poolAttributes);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created shared pooled access for pool name [" + poolName + "]."));
                }
                this.pools.put(poolName, poolAccess);
            }
            catch (Exception e) {
                log.error((Object)("Problem creating connection poolfor pool name [" + poolName + "]."), (Throwable)e);
            }
        }
        return poolAccess;
    }

    protected JDBCDiskCachePoolAccessAttributes configurePoolAccessAttributes(String poolName) {
        JDBCDiskCachePoolAccessAttributes poolAttributes = new JDBCDiskCachePoolAccessAttributes();
        String poolAccessAttributePrefix = POOL_CONFIGURATION_PREFIX + poolName + ATTRIBUTE_PREFIX;
        PropertySetter.setProperties(poolAttributes, this.getProps(), poolAccessAttributePrefix + ".");
        poolAttributes.setPoolName(poolName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Configured attributes " + poolAttributes));
        }
        return poolAttributes;
    }

    protected void setProps(Properties props) {
        this.props = props;
    }

    protected Properties getProps() {
        return this.props;
    }

    static {
        log = LogFactory.getLog((Class)JDBCDiskCachePoolAccessManager.class);
    }
}

