/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.utils.net.HostNameUtil;
import org.apache.jcs.utils.props.PropertyLoader;

public class RemoteCacheStartupServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((Class)RemoteCacheStartupServlet.class);
    private static final int DEFAULT_REGISTRY_PORT = 1101;
    private static final String DEFAULT_PROPS_FILE_NAME = "cache";
    private static final String DEFAULT_PROPS_FILE_SUFFIX = "ccf";
    private String propsFileName = "cache";
    private String fullPropsFileName = "cache.ccf";

    public void init() throws ServletException {
        super.init();
        int registryPort = 1101;
        try {
            Properties props = PropertyLoader.loadProperties(this.propsFileName);
            if (props != null) {
                String portS = props.getProperty("registry.port", String.valueOf(1101));
                try {
                    registryPort = Integer.parseInt(portS);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Problem converting port to an int.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem loading props.", (Throwable)e);
        }
        catch (Throwable t) {
            log.error((Object)"Problem loading props.", t);
        }
        try {
            String registryHost = HostNameUtil.getLocalHostAddress();
            if (log.isDebugEnabled()) {
                log.debug((Object)("registryHost = [" + registryHost + "]"));
            }
            if ("localhost".equals(registryHost) || "127.0.0.1".equals(registryHost)) {
                log.warn((Object)("The local address [" + registryHost + "] is INVALID.  Other machines must be able to use the address to reach this server."));
            }
            try {
                LocateRegistry.createRegistry(registryPort);
            }
            catch (RemoteException e) {
                log.error((Object)("Problem creating registry.  It may already be started. " + e.getMessage()));
            }
            catch (Throwable t) {
                log.error((Object)"Problem creating registry.", t);
            }
            try {
                RemoteCacheServerFactory.startup(registryHost, registryPort, "/" + this.fullPropsFileName);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Remote JCS Server started with properties from " + this.fullPropsFileName));
                }
            }
            catch (IOException e) {
                log.error((Object)"Problem starting remote cache server.", (Throwable)e);
            }
            catch (Throwable t) {
                log.error((Object)"Problem starting remote cache server.", t);
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)"Could not get local address to use for the registry!", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String stats = CompositeCacheManager.getInstance().getStats();
        if (log.isInfoEnabled()) {
            log.info((Object)stats);
        }
        try {
            ServletOutputStream os = response.getOutputStream();
            os.write(stats.getBytes());
            os.close();
        }
        catch (IOException e) {
            log.error((Object)"Problem writing response.", (Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        log.info((Object)"Shutting down remote cache ");
        CompositeCacheManager.getInstance().shutDown();
    }
}

