/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.control.event;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.control.event.behavior.IElementEvent;
import org.apache.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.jcs.engine.control.event.behavior.IElementEventQueue;

public class ElementEventQueue
implements IElementEventQueue {
    private static final Log log = LogFactory.getLog((Class)ElementEventQueue.class);
    private static int processorInstanceCount = 0;
    private String cacheName;
    private boolean destroyed = false;
    private Thread t;
    private Object queueLock = new Object();
    private Node head;
    private Node tail = this.head = new Node();

    public ElementEventQueue(String cacheName) {
        this.cacheName = cacheName;
        this.t = new QProcessor();
        this.t.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed: " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            Object object = this.queueLock;
            synchronized (object) {
                this.t.interrupt();
            }
            this.t = null;
            log.info((Object)("Element event queue destroyed: " + this));
        }
    }

    public String toString() {
        return "cacheName=" + this.cacheName;
    }

    public boolean isAlive() {
        return !this.destroyed;
    }

    public void addElementEvent(IElementEventHandler hand, IElementEvent event) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Event Handler to QUEUE, !destroyed = " + !this.destroyed));
        }
        if (!this.destroyed) {
            ElementEventRunner runner = new ElementEventRunner(hand, event);
            if (log.isDebugEnabled()) {
                log.debug((Object)("runner = " + runner));
            }
            this.put(runner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(AbstractElementEventRunner event) {
        Node newNode = new Node();
        newNode.event = event;
        Object object = this.queueLock;
        synchronized (object) {
            this.tail.next = newNode;
            this.tail = newNode;
            this.queueLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractElementEventRunner take() throws InterruptedException {
        Object object = this.queueLock;
        synchronized (object) {
            while (this.head == this.tail) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Waiting for something to come into the Q");
                }
                this.queueLock.wait();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Something came into the Q");
            }
            Node node = this.head.next;
            AbstractElementEventRunner value = node.event;
            if (log.isDebugEnabled()) {
                log.debug((Object)("head.event = " + this.head.event));
                log.debug((Object)("node.event = " + node.event));
            }
            node.event = null;
            this.head = node;
            return value;
        }
    }

    private class ElementEventRunner
    extends AbstractElementEventRunner {
        private IElementEventHandler hand;
        private IElementEvent event;

        ElementEventRunner(IElementEventHandler hand, IElementEvent event) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Constructing " + this));
            }
            this.hand = hand;
            this.event = event;
        }

        protected void doRun() throws IOException {
            this.hand.handleElementEvent(this.event);
        }
    }

    private abstract class AbstractElementEventRunner
    implements Runnable {
        private AbstractElementEventRunner() {
        }

        public void run() {
            IOException ex = null;
            try {
                ex = null;
                this.doRun();
                return;
            }
            catch (IOException e) {
                ex = e;
                if (ex != null) {
                    log.warn((Object)("Giving up element event handling " + ElementEventQueue.this), (Throwable)ex);
                }
                return;
            }
        }

        protected abstract void doRun() throws IOException;
    }

    private class QProcessor
    extends Thread {
        QProcessor() {
            super("ElementEventQueue.QProcessor-" + ++processorInstanceCount);
            this.setDaemon(true);
        }

        public void run() {
            AbstractElementEventRunner r = null;
            while (!ElementEventQueue.this.destroyed) {
                try {
                    r = ElementEventQueue.this.take();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("r from take() = " + r));
                    }
                }
                catch (InterruptedException e) {
                    this.destroy();
                }
                if (ElementEventQueue.this.destroyed || r == null) continue;
                r.run();
            }
            log.info((Object)("QProcessor exiting for " + ElementEventQueue.this));
        }
    }

    private static class Node {
        Node next = null;
        AbstractElementEventRunner event = null;

        private Node() {
        }
    }
}

