/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.LateralCacheRestore;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheManager;

public class LateralCacheMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)LateralCacheMonitor.class);
    private static long idlePeriod = 20000L;
    private boolean alright = true;
    private static final int ERROR = 1;
    private static int mode = 1;
    private ILateralCacheManager manager;

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > LateralCacheMonitor.idlePeriod) {
            LateralCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    protected static void forceShortIdlePeriod(long idlePeriod) {
        LateralCacheMonitor.idlePeriod = idlePeriod;
    }

    public LateralCacheMonitor(ILateralCacheManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError() {
        this.bad();
        LateralCacheMonitor lateralCacheMonitor = this;
        synchronized (lateralCacheMonitor) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            LateralCacheMonitor lateralCacheMonitor;
            if (mode == 1) {
                if (log.isDebugEnabled()) {
                    if (this.alright) {
                        log.debug((Object)("ERROR DRIVEN MODE: alright = " + this.alright + ", connection monitor will wait for an error."));
                    } else {
                        log.debug((Object)("ERROR DRIVEN MODE: alright = " + this.alright + " connection monitor running."));
                    }
                }
                if (this.alright) {
                    lateralCacheMonitor = this;
                    synchronized (lateralCacheMonitor) {
                        if (this.alright) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                        }
                    }
                }
            } else {
                log.debug((Object)("TIME DRIVEN MODE: connection monitor will sleep for " + idlePeriod + " after this run."));
            }
            lateralCacheMonitor = this;
            synchronized (lateralCacheMonitor) {
                this.alright = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache monitor running.");
            }
            log.info((Object)("LateralCacheManager.instances.size() = " + this.manager.getInstances().size()));
            int cnt = 0;
            Iterator itr = this.manager.getInstances().values().iterator();
            while (itr.hasNext()) {
                ++cnt;
                ILateralCacheManager mgr = (ILateralCacheManager)itr.next();
                try {
                    log.info((Object)("\n " + cnt + "- mgr.getCaches().size() = " + mgr.getCaches().size()));
                    if (mgr.getCaches().size() == 0 && mode == 1) {
                        this.bad();
                    }
                    Iterator itr2 = mgr.getCaches().values().iterator();
                    while (itr2.hasNext()) {
                        LateralCacheNoWait c = (LateralCacheNoWait)itr2.next();
                        if (c.getStatus() == 3) {
                            log.info((Object)("found LateralCacheNoWait in error, " + c.toString()));
                            LateralCacheRestore repairer = new LateralCacheRestore(mgr);
                            if (repairer.canFix()) {
                                repairer.fix();
                                continue;
                            }
                            this.bad();
                            continue;
                        }
                        log.info((Object)"Lateral Cache No Wait not in error");
                    }
                }
                catch (Exception ex) {
                    this.bad();
                    log.error((Object)"Problem encountered in fixing the caches", (Throwable)ex);
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Lateral cache monitor sleeping for " + idlePeriod + " between runs."));
                }
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bad() {
        if (this.alright) {
            LateralCacheMonitor lateralCacheMonitor = this;
            synchronized (lateralCacheMonitor) {
                this.alright = false;
            }
        }
    }
}

