/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.lateral.LateralCache;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.engine.CacheAdaptor;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class LateralCacheNoWait
extends AbstractAuxiliaryCache {
    private static final long serialVersionUID = -7251187566116178475L;
    private static final Log log = LogFactory.getLog((Class)LateralCacheNoWait.class);
    private final LateralCache cache;
    private ICacheEventQueue eventQueue;
    private int getCount = 0;
    private int removeCount = 0;
    private int putCount = 0;

    public LateralCacheNoWait(LateralCache cache) {
        this.cache = cache;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructing LateralCacheNoWait, LateralCache = [" + cache + "]"));
        }
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.eventQueue = fact.createCacheEventQueue(new CacheAdaptor(cache), LateralCacheInfo.listenerId, cache.getCacheName(), cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), cache.getAuxiliaryCacheAttributes().getEventQueueType());
        if (cache.getStatus() == 3) {
            this.eventQueue.destroy();
        }
    }

    public void update(ICacheElement ce) throws IOException {
        ++this.putCount;
        try {
            this.eventQueue.addPutEvent(ce);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.eventQueue.destroy();
        }
    }

    public ICacheElement get(Serializable key) {
        ++this.getCount;
        if (this.getStatus() != 3) {
            try {
                return this.cache.get(key);
            }
            catch (UnmarshalException ue) {
                log.debug((Object)"Retrying the get owing to UnmarshalException...");
                try {
                    return this.cache.get(key);
                }
                catch (IOException ex) {
                    log.error((Object)"Failed in retrying the get for the second time.");
                    this.eventQueue.destroy();
                }
            }
            catch (IOException ex) {
                this.eventQueue.destroy();
            }
        }
        return null;
    }

    public Map getMultiple(Set keys) {
        HashMap<Serializable, ICacheElement> elements = new HashMap<Serializable, ICacheElement>();
        if (keys != null && !keys.isEmpty()) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Serializable key = (Serializable)iterator.next();
                ICacheElement element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    public Map getMatching(String pattern) {
        ++this.getCount;
        if (this.getStatus() != 3) {
            try {
                return this.cache.getMatching(pattern);
            }
            catch (UnmarshalException ue) {
                log.debug((Object)"Retrying the get owing to UnmarshalException.");
                try {
                    return this.cache.getMatching(pattern);
                }
                catch (IOException ex) {
                    log.error((Object)"Failed in retrying the get for the second time.");
                    this.eventQueue.destroy();
                }
            }
            catch (IOException ex) {
                this.eventQueue.destroy();
            }
        }
        return Collections.EMPTY_MAP;
    }

    public Set getGroupKeys(String groupName) {
        return this.cache.getGroupKeys(groupName);
    }

    public boolean remove(Serializable key) {
        ++this.removeCount;
        try {
            this.eventQueue.addRemoveEvent(key);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.eventQueue.destroy();
        }
        return false;
    }

    public void removeAll() {
        try {
            this.eventQueue.addRemoveAllEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.eventQueue.destroy();
        }
    }

    public void dispose() {
        try {
            this.eventQueue.addDisposeEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.eventQueue.destroy();
        }
    }

    public int getSize() {
        return this.cache.getSize();
    }

    public int getCacheType() {
        return this.cache.getCacheType();
    }

    public int getStatus() {
        return this.eventQueue.isWorking() ? this.cache.getStatus() : 3;
    }

    public String getCacheName() {
        return this.cache.getCacheName();
    }

    public void fixCache(ILateralCacheService lateral) {
        this.cache.fixCache(lateral);
        this.resetEventQ();
    }

    public void resetEventQ() {
        if (this.eventQueue.isWorking()) {
            this.eventQueue.destroy();
        }
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.eventQueue = fact.createCacheEventQueue(new CacheAdaptor(this.cache), LateralCacheInfo.listenerId, this.cache.getCacheName(), this.cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.cache.getAuxiliaryCacheAttributes().getEventQueueType());
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cache.getAuxiliaryCacheAttributes();
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public String getEventLoggingExtraInfo() {
        return "Lateral Cache No Wait";
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        IStats eqStats = this.eventQueue.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        StatElement se = null;
        se = new StatElement();
        se.setName("Get Count");
        se.setData("" + this.getCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Remove Count");
        se.setData("" + this.removeCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Put Count");
        se.setData("" + this.putCount);
        elems.add(se);
        IStatElement[] ses = elems.toArray(new StatElement[elems.size()]);
        stats.setStatElements(ses);
        return stats;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" LateralCacheNoWait ");
        buf.append(" Status = " + this.getStatus());
        buf.append(" cache = [" + this.cache.toString() + "]");
        return buf.toString();
    }
}

