/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheElementSerialized;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.utils.net.HostNameUtil;
import org.apache.jcs.utils.serialization.SerializationConversionUtil;
import org.apache.jcs.utils.serialization.StandardSerializer;

public abstract class AbsractRemoteCacheListener
implements IRemoteCacheListener {
    private static final long serialVersionUID = 32442324243243L;
    private static final Log log = LogFactory.getLog((Class)AbsractRemoteCacheListener.class);
    private static String localHostName = null;
    boolean disposed = false;
    protected transient ICompositeCacheManager cacheMgr;
    protected IRemoteCacheAttributes irca;
    protected int puts = 0;
    protected int removes = 0;
    protected long listenerId = 0L;
    private transient IElementSerializer elementSerializer = new StandardSerializer();

    public AbsractRemoteCacheListener(IRemoteCacheAttributes irca, ICompositeCacheManager cacheMgr) {
        this.irca = irca;
        this.cacheMgr = cacheMgr;
    }

    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
        if (log.isInfoEnabled()) {
            log.info((Object)("set listenerId = [" + id + "]"));
        }
    }

    public long getListenerId() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get listenerId = [" + this.listenerId + "]"));
        }
        return this.listenerId;
    }

    public int getRemoteType() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRemoteType = [" + this.irca.getRemoteType() + "]"));
        }
        return this.irca.getRemoteType();
    }

    public void handlePut(ICacheElement cb) throws IOException {
        if (this.irca.getRemoveUponRemotePut()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"PUTTING ELEMENT FROM REMOTE, (  invalidating ) ");
            }
            this.handleRemove(cb.getCacheName(), cb.getKey());
        } else {
            ++this.puts;
            if (log.isDebugEnabled()) {
                log.debug((Object)"PUTTING ELEMENT FROM REMOTE, ( updating ) ");
                log.debug((Object)("cb = " + cb));
                if (this.puts % 100 == 0) {
                    log.debug((Object)("puts = " + this.puts));
                }
            }
            this.ensureCacheManager();
            CompositeCache cache = this.cacheMgr.getCache(cb.getCacheName());
            if (cb != null && cb instanceof ICacheElementSerialized) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Object needs to be deserialized.");
                }
                try {
                    cb = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)cb, this.elementSerializer);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deserialized result = " + cb));
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Received a serialized version of a class that we don't know about.", (Throwable)e);
                }
            }
            cache.localUpdate(cb);
        }
    }

    public void handleRemove(String cacheName, Serializable key) throws IOException {
        ++this.removes;
        if (log.isDebugEnabled()) {
            if (this.removes % 100 == 0) {
                log.debug((Object)("removes = " + this.removes));
            }
            log.debug((Object)("handleRemove> cacheName=" + cacheName + ", key=" + key));
        }
        this.ensureCacheManager();
        CompositeCache cache = this.cacheMgr.getCache(cacheName);
        cache.localRemove(key);
    }

    public void handleRemoveAll(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemoveAll> cacheName=" + cacheName));
        }
        this.ensureCacheManager();
        CompositeCache cache = this.cacheMgr.getCache(cacheName);
        cache.localRemoveAll();
    }

    public void handleDispose(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleDispose> cacheName=" + cacheName));
        }
    }

    protected void ensureCacheManager() {
        if (this.cacheMgr == null) {
            this.cacheMgr = CompositeCacheManager.getInstance();
            log.debug((Object)"had to get cacheMgr");
            if (log.isDebugEnabled()) {
                log.debug((Object)("cacheMgr = " + this.cacheMgr));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("already got cacheMgr = " + this.cacheMgr));
        }
    }

    public synchronized String getLocalHostAddress() throws IOException {
        if (localHostName == null) {
            try {
                localHostName = HostNameUtil.getLocalHostAddress();
            }
            catch (UnknownHostException uhe) {
                localHostName = "unknown";
            }
        }
        return localHostName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n AbstractRemoteCacheListener: ");
        buf.append("\n RemoteHost = " + this.irca.getRemoteHost());
        buf.append("\n RemotePort = " + this.irca.getRemotePort());
        buf.append("\n ListenerId = " + this.listenerId);
        return buf.toString();
    }
}

