/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.client;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheDispatcher;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheDispatcher;
import org.apache.jcs.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;
import org.apache.jcs.auxiliary.remote.http.server.RemoteCacheServiceAdaptor;
import org.apache.jcs.auxiliary.remote.util.RemoteCacheRequestFactory;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.jcs.engine.behavior.ICacheElement;

public class RemoteHttpCacheClient
implements IRemoteHttpCacheClient {
    private static final Log log = LogFactory.getLog((Class)RemoteCacheServiceAdaptor.class);
    private IRemoteCacheDispatcher remoteDispatcher;
    private RemoteHttpCacheAttributes remoteHttpCacheAttributes;
    private boolean initialized = false;

    public RemoteHttpCacheClient() {
    }

    public RemoteHttpCacheClient(RemoteHttpCacheAttributes attributes) {
        this.setRemoteHttpCacheAttributes(attributes);
        this.initialize(attributes);
    }

    public void initialize(RemoteHttpCacheAttributes attributes) {
        this.setRemoteDispatcher(new RemoteHttpCacheDispatcher(attributes));
        if (log.isInfoEnabled()) {
            log.info((Object)("Created remote Dispatcher." + this.getRemoteDispatcher()));
        }
        this.setInitialized(true);
    }

    public ICacheElement get(String cacheName, Serializable key) throws IOException {
        return this.get(cacheName, key, 0L);
    }

    public ICacheElement get(String cacheName, Serializable key, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createGetRequest(cacheName, key, requesterId);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get [" + key + "] = " + remoteHttpCacheResponse));
        }
        ICacheElement retval = null;
        if (remoteHttpCacheResponse != null && remoteHttpCacheResponse.getPayload() != null) {
            retval = (ICacheElement)remoteHttpCacheResponse.getPayload().get(key);
        }
        return retval;
    }

    public Map getMatching(String cacheName, String pattern) throws IOException {
        return this.getMatching(cacheName, pattern, 0L);
    }

    public Map getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createGetMatchingRequest(cacheName, pattern, requesterId);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        if (log.isDebugEnabled()) {
            log.debug((Object)("GetMatching [" + pattern + "] = " + remoteHttpCacheResponse));
        }
        return remoteHttpCacheResponse.getPayload();
    }

    public Map getMultiple(String cacheName, Set keys) throws IOException {
        return this.getMultiple(cacheName, keys, 0L);
    }

    public Map getMultiple(String cacheName, Set keys, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createGetMultipleRequest(cacheName, keys, requesterId);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        if (log.isDebugEnabled()) {
            log.debug((Object)("GetMultiple [" + keys + "] = " + remoteHttpCacheResponse));
        }
        return remoteHttpCacheResponse.getPayload();
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    public void remove(String cacheName, Serializable key, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createRemoveRequest(cacheName, key, requesterId);
        this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
    }

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    public void removeAll(String cacheName, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createRemoveAllRequest(cacheName, requesterId);
        this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
    }

    public void update(ICacheElement item) throws IOException {
        this.update(item, 0L);
    }

    public void update(ICacheElement cacheElement, long requesterId) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createUpdateRequest(cacheElement, requesterId);
        this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
    }

    public void dispose(String cacheName) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createDisposeRequest(cacheName, 0L);
        this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
    }

    public void release() throws IOException {
    }

    public Set getGroupKeys(String cacheName, String groupName) throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createGetGroupKeysRequest(cacheName, groupName, 0L);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        if (remoteHttpCacheResponse != null && remoteHttpCacheResponse.getPayload() != null) {
            return (Set)remoteHttpCacheResponse.getPayload().get(groupName);
        }
        return Collections.EMPTY_SET;
    }

    public boolean isAlive() throws IOException {
        if (!this.isInitialized()) {
            String message = "The Remote Http Client is not initialized.  Cannot process request.";
            log.warn((Object)message);
            throw new IOException(message);
        }
        RemoteCacheRequest remoteHttpCacheRequest = RemoteCacheRequestFactory.createAliveCheckRequest(0L);
        RemoteCacheResponse remoteHttpCacheResponse = this.getRemoteDispatcher().dispatchRequest(remoteHttpCacheRequest);
        if (remoteHttpCacheResponse != null) {
            return remoteHttpCacheResponse.isSuccess();
        }
        return false;
    }

    public void setRemoteDispatcher(IRemoteCacheDispatcher remoteDispatcher) {
        this.remoteDispatcher = remoteDispatcher;
    }

    public IRemoteCacheDispatcher getRemoteDispatcher() {
        return this.remoteDispatcher;
    }

    public void setRemoteHttpCacheAttributes(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        this.remoteHttpCacheAttributes = remoteHttpCacheAttributes;
    }

    public RemoteHttpCacheAttributes getRemoteHttpCacheAttributes() {
        return this.remoteHttpCacheAttributes;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }
}

