/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCache;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheClient;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpCacheMonitor;
import org.apache.jcs.auxiliary.remote.http.client.RemoteHttpClientListener;
import org.apache.jcs.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;
import org.apache.jcs.engine.behavior.ICache;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.behavior.IShutdownObserver;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.jcs.utils.config.OptionConverter;

public class RemoteHttpCacheManager
implements AuxiliaryCacheManager,
IShutdownObserver {
    private static final long serialVersionUID = 798077557166389498L;
    private static final Log log = LogFactory.getLog((Class)RemoteHttpCacheManager.class);
    private static RemoteHttpCacheManager instance;
    static final Map caches;
    private IRemoteCacheAttributes remoteCacheAttributes;
    private ICacheEventLogger cacheEventLogger;
    private IElementSerializer elementSerializer;
    private ICompositeCacheManager cacheMgr;
    private static RemoteHttpCacheMonitor monitor;

    private RemoteHttpCacheManager(ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.cacheMgr = cacheMgr;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
        if (this.cacheMgr instanceof CompositeCacheManager) {
            ((CompositeCacheManager)this.cacheMgr).registerShutdownObserver(this);
        }
    }

    public IRemoteCacheAttributes getDefaultCattr() {
        return this.remoteCacheAttributes;
    }

    public static synchronized RemoteHttpCacheManager getInstance() {
        return instance;
    }

    public static synchronized RemoteHttpCacheManager getInstance(ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        if (instance == null) {
            instance = new RemoteHttpCacheManager(cacheMgr, cacheEventLogger, elementSerializer);
        }
        if (monitor == null && (monitor = RemoteHttpCacheMonitor.getInstance()) != null) {
            Thread t = new Thread(monitor);
            t.setDaemon(true);
            t.start();
        }
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        RemoteHttpCacheAttributes ca = new RemoteHttpCacheAttributes();
        ca.setCacheName(cacheName);
        return this.getCache(ca);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuxiliaryCache getCache(RemoteHttpCacheAttributes cattr) {
        RemoteCacheNoWait remoteCacheNoWait = null;
        Map map = caches;
        synchronized (map) {
            remoteCacheNoWait = (RemoteCacheNoWait)caches.get(cattr.getCacheName() + cattr.getUrl());
            if (remoteCacheNoWait == null) {
                RemoteHttpClientListener listener = new RemoteHttpClientListener(cattr, this.cacheMgr);
                IRemoteHttpCacheClient remoteService = this.createRemoteHttpCacheClientForAttributes(cattr);
                RemoteHttpCache remoteCacheClient = new RemoteHttpCache(cattr, (IRemoteCacheService)remoteService, (IRemoteCacheListener)listener);
                remoteCacheClient.setCacheEventLogger(this.cacheEventLogger);
                remoteCacheClient.setElementSerializer(this.elementSerializer);
                remoteCacheNoWait = new RemoteCacheNoWait(remoteCacheClient);
                remoteCacheNoWait.setCacheEventLogger(this.cacheEventLogger);
                remoteCacheNoWait.setElementSerializer(this.elementSerializer);
                caches.put(cattr.getCacheName() + cattr.getUrl(), remoteCacheNoWait);
            }
        }
        return remoteCacheNoWait;
    }

    protected IRemoteHttpCacheClient createRemoteHttpCacheClientForAttributes(RemoteHttpCacheAttributes cattr) {
        IRemoteHttpCacheClient client = (IRemoteHttpCacheClient)OptionConverter.instantiateByClassName(cattr.getRemoteHttpClientClassName(), IRemoteHttpCacheClient.class, null);
        if (client == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Creating the default client.");
            }
            client = new RemoteHttpCacheClient();
        }
        client.initialize(cattr);
        return client;
    }

    public String getStats() {
        StringBuffer stats = new StringBuffer();
        Iterator allCaches = caches.values().iterator();
        while (allCaches.hasNext()) {
            ICache c = (ICache)allCaches.next();
            if (c == null) continue;
            stats.append(c.getCacheName());
        }
        return stats.toString();
    }

    public int getCacheType() {
        return 4;
    }

    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Observed shutdown request.");
        }
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    static {
        caches = new HashMap();
    }
}

