/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.CacheEventQueue;
import org.apache.jcs.engine.PooledCacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.utils.config.OptionConverter;

public class CacheEventQueueFactory {
    private static final Log log = LogFactory.getLog((Class)CacheEventQueueFactory.class);

    public ICacheEventQueue createCacheEventQueue(ICacheListener listener, long listenerId, String cacheName, String threadPoolName, String poolType) {
        return this.createCacheEventQueue(listener, listenerId, cacheName, 10, 500, threadPoolName, poolType);
    }

    public ICacheEventQueue createCacheEventQueue(ICacheListener listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName, String poolType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("threadPoolName = [" + threadPoolName + "] poolType = " + poolType + " "));
        }
        ICacheEventQueue eventQueue = null;
        if ("SINGLE".equalsIgnoreCase(poolType)) {
            eventQueue = new CacheEventQueue(listener, listenerId, cacheName, maxFailure, waitBeforeRetry);
        } else if ("POOLED".equalsIgnoreCase(poolType)) {
            eventQueue = new PooledCacheEventQueue(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, threadPoolName);
        } else {
            eventQueue = (ICacheEventQueue)OptionConverter.instantiateByClassName(poolType, ICacheEventQueue.class, null);
            if (eventQueue != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created custom event queue. " + eventQueue));
                }
                eventQueue.initialize(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, threadPoolName);
            } else {
                log.warn((Object)("Could not instantiate custom event queue [" + poolType + "].  Will use standard single threaded queue."));
                eventQueue = new CacheEventQueue(listener, listenerId, cacheName, maxFailure, waitBeforeRetry);
            }
        }
        return eventQueue;
    }
}

