/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;

public class CompositeCacheAttributes
implements ICompositeCacheAttributes,
Cloneable {
    private static final long serialVersionUID = 6754049978134196787L;
    private static final boolean DEFAULT_USE_LATERAL = true;
    private static final boolean DEFAULT_USE_REMOTE = true;
    private static final boolean DEFAULT_USE_DISK = true;
    private static final boolean DEFAULT_USE_SHRINKER = false;
    private static final int DEFAULT_MAX_OBJECTS = 100;
    private static final int DEFAULT_MAX_MEMORY_IDLE_TIME_SECONDS = 7200;
    private static final int DEFAULT_SHRINKER_INTERVAL_SECONDS = 30;
    private static final int DEFAULT_MAX_SPOOL_PER_RUN = -1;
    private static final String DEFAULT_MEMORY_CACHE_NAME = "org.apache.jcs.engine.memory.lru.LRUMemoryCache";
    private static final int DEFAULT_CHUNK_SIZE = 2;
    private boolean useLateral = true;
    private boolean useRemote = true;
    private boolean useDisk = true;
    private boolean useMemoryShrinker = false;
    private int maxObjs = 100;
    private long maxMemoryIdleTimeSeconds = 7200L;
    private long shrinkerIntervalSeconds = 30L;
    private int maxSpoolPerRun = -1;
    private String cacheName;
    private String memoryCacheName = "org.apache.jcs.engine.memory.lru.LRUMemoryCache";
    private short diskUsagePattern = 0;
    private int spoolChunkSize = 2;

    public void setMaxObjects(int maxObjs) {
        this.maxObjs = maxObjs;
    }

    public int getMaxObjects() {
        return this.maxObjs;
    }

    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    public boolean getUseDisk() {
        return this.useDisk;
    }

    public void setUseLateral(boolean b) {
        this.useLateral = b;
    }

    public boolean getUseLateral() {
        return this.useLateral;
    }

    public void setUseRemote(boolean useRemote) {
        this.useRemote = useRemote;
    }

    public boolean getUseRemote() {
        return this.useRemote;
    }

    public void setCacheName(String s) {
        this.cacheName = s;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setMemoryCacheName(String s) {
        this.memoryCacheName = s;
    }

    public String getMemoryCacheName() {
        return this.memoryCacheName;
    }

    public void setUseMemoryShrinker(boolean useShrinker) {
        this.useMemoryShrinker = useShrinker;
    }

    public boolean getUseMemoryShrinker() {
        return this.useMemoryShrinker;
    }

    public void setMaxMemoryIdleTimeSeconds(long seconds) {
        this.maxMemoryIdleTimeSeconds = seconds;
    }

    public long getMaxMemoryIdleTimeSeconds() {
        return this.maxMemoryIdleTimeSeconds;
    }

    public void setShrinkerIntervalSeconds(long seconds) {
        this.shrinkerIntervalSeconds = seconds;
    }

    public long getShrinkerIntervalSeconds() {
        return this.shrinkerIntervalSeconds;
    }

    public void setMaxSpoolPerRun(int maxSpoolPerRun) {
        this.maxSpoolPerRun = maxSpoolPerRun;
    }

    public int getMaxSpoolPerRun() {
        return this.maxSpoolPerRun;
    }

    public void setDiskUsagePattern(short diskUsagePattern) {
        this.diskUsagePattern = diskUsagePattern;
    }

    public void setDiskUsagePatternName(String diskUsagePatternName) {
        if (diskUsagePatternName != null) {
            if ((diskUsagePatternName = diskUsagePatternName.toUpperCase().trim()).startsWith("SWAP")) {
                this.setDiskUsagePattern((short)0);
            } else if (diskUsagePatternName.startsWith("UPDATE")) {
                this.setDiskUsagePattern((short)1);
            }
        }
    }

    public int getSpoolChunkSize() {
        return this.spoolChunkSize;
    }

    public void setSpoolChunkSize(int spoolChunkSize) {
        this.spoolChunkSize = spoolChunkSize;
    }

    public short getDiskUsagePattern() {
        return this.diskUsagePattern;
    }

    public ICompositeCacheAttributes copy() {
        try {
            CompositeCacheAttributes cattr = (CompositeCacheAttributes)this.clone();
            return cattr;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return new CompositeCacheAttributes();
        }
    }

    public String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ ");
        dump.append("useLateral = ").append(this.useLateral);
        dump.append(", useRemote = ").append(this.useRemote);
        dump.append(", useDisk = ").append(this.useDisk);
        dump.append(", maxObjs = ").append(this.maxObjs);
        dump.append(", maxSpoolPerRun = ").append(this.maxSpoolPerRun);
        dump.append(", diskUsagePattern = ").append(this.diskUsagePattern);
        dump.append(", spoolChunkSize = ").append(this.spoolChunkSize);
        dump.append(" ]");
        return dump.toString();
    }
}

