/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.indexed;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.disk.AbstractDiskCacheManager;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class IndexedDiskCacheManager
extends AbstractDiskCacheManager {
    private static final long serialVersionUID = -4153287154512274626L;
    private static final Log log = LogFactory.getLog((Class)IndexedDiskCacheManager.class);
    private static IndexedDiskCacheManager instance;
    private Hashtable caches = new Hashtable();
    private IndexedDiskCacheAttributes defaultCacheAttributes;

    private IndexedDiskCacheManager(IndexedDiskCacheAttributes defaultCacheAttributes, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.defaultCacheAttributes = defaultCacheAttributes;
        this.setElementSerializer(elementSerializer);
        this.setCacheEventLogger(cacheEventLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexedDiskCacheManager getInstance(IndexedDiskCacheAttributes defaultCacheAttributes, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        Class clazz = IndexedDiskCacheManager.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new IndexedDiskCacheManager(defaultCacheAttributes, cacheEventLogger, elementSerializer);
            }
        }
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        IndexedDiskCacheAttributes cacheAttributes = (IndexedDiskCacheAttributes)this.defaultCacheAttributes.copy();
        cacheAttributes.setCacheName(cacheName);
        return this.getCache(cacheAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuxiliaryCache getCache(IndexedDiskCacheAttributes cacheAttributes) {
        AuxiliaryCache cache = null;
        String cacheName = cacheAttributes.getCacheName();
        log.debug((Object)("Getting cache named: " + cacheName));
        Hashtable hashtable = this.caches;
        synchronized (hashtable) {
            cache = (AuxiliaryCache)this.caches.get(cacheName);
            if (cache == null) {
                cache = new IndexedDiskCache(cacheAttributes, this.getElementSerializer());
                cache.setCacheEventLogger(this.getCacheEventLogger());
                this.caches.put(cacheName, cache);
            }
        }
        return cache;
    }

    public int getCacheType() {
        return 2;
    }
}

