/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class RemoteCacheFailoverRunner
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)RemoteCacheFailoverRunner.class);
    private RemoteCacheNoWaitFacade facade;
    private static long idlePeriod = 20000L;
    private boolean alright = true;
    private ICompositeCacheManager cacheMgr;
    private ICacheEventLogger cacheEventLogger;
    private IElementSerializer elementSerializer;

    public RemoteCacheFailoverRunner(RemoteCacheNoWaitFacade facade, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.facade = facade;
        this.cacheMgr = cacheMgr;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError() {
        this.bad();
        RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
        synchronized (remoteCacheFailoverRunner) {
            this.notify();
        }
    }

    public void run() {
        this.connectAndRestore();
        if (log.isInfoEnabled()) {
            log.info((Object)("Exiting failover runner. Failover index = " + this.facade.remoteCacheAttributes.getFailoverIndex()));
            if (this.facade.remoteCacheAttributes.getFailoverIndex() <= 0) {
                log.info((Object)"Failover index is <= 0, meaning we are not connected to a failover server.");
            } else if (this.facade.remoteCacheAttributes.getFailoverIndex() > 0) {
                log.info((Object)"Failover index is > 0, meaning we are connected to a failover server.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndRestore() {
        do {
            log.info((Object)"Remote cache FAILOVER RUNNING.");
            if (!this.alright) {
                String[] failovers = this.facade.remoteCacheAttributes.getFailovers();
                if (failovers == null) {
                    log.warn((Object)"Remote is misconfigured, failovers was null.");
                    return;
                }
                if (failovers.length == 1 && log.isInfoEnabled()) {
                    log.info((Object)"No failovers defined, exiting failover runner.");
                    return;
                }
                int fidx = this.facade.remoteCacheAttributes.getFailoverIndex();
                log.debug((Object)("fidx = " + fidx + " failovers.length = " + failovers.length));
                int i = fidx;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("stating at failover i = " + i));
                }
                while (i < failovers.length && !this.alright) {
                    block27: {
                        String server = failovers[i];
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying server [" + server + "] at failover index i = " + i));
                        }
                        RemoteCacheAttributes rca = null;
                        try {
                            AuxiliaryCache ic;
                            rca = (RemoteCacheAttributes)this.facade.remoteCacheAttributes.copy();
                            rca.setRemoteHost(server.substring(0, server.indexOf(":")));
                            rca.setRemotePort(Integer.parseInt(server.substring(server.indexOf(":") + 1)));
                            RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, this.cacheMgr, this.cacheEventLogger, this.elementSerializer);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("RemoteCacheAttributes for failover = " + rca.toString()));
                            }
                            if ((ic = rcm.getCache(rca.getCacheName())) != null) {
                                if (ic.getStatus() != 1) break block27;
                                log.debug((Object)"reseting no wait");
                                this.facade.noWaits = new RemoteCacheNoWait[1];
                                this.facade.noWaits[0] = (RemoteCacheNoWait)ic;
                                this.facade.remoteCacheAttributes.setFailoverIndex(i);
                                RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
                                synchronized (remoteCacheFailoverRunner) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"setting ALRIGHT to true");
                                        if (i > 0) {
                                            log.debug((Object)("Moving to Primary Recovery Mode, failover index = " + i));
                                        } else if (log.isInfoEnabled()) {
                                            String message = "No need to connect to failover, the primary server is back up.";
                                            log.info((Object)message);
                                        }
                                    }
                                    this.alright = true;
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)("CONNECTED to host = [" + rca.getRemoteHost() + "] port = [" + rca.getRemotePort() + "]"));
                                    }
                                    break block27;
                                }
                            }
                            log.info((Object)"noWait is null");
                        }
                        catch (Exception ex) {
                            this.bad();
                            if (i == 0) {
                                log.warn((Object)("FAILED to connect, as expected, to primary" + rca.getRemoteHost() + ":" + rca.getRemotePort()), (Throwable)ex);
                            }
                            log.error((Object)("FAILED to connect to failover [" + rca.getRemoteHost() + ":" + rca.getRemotePort() + "]"), (Throwable)ex);
                        }
                    }
                    ++i;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ALRIGHT is true ");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Failover runner is in primary recovery mode. Failover index = " + this.facade.remoteCacheAttributes.getFailoverIndex() + "\n" + "Will now try to reconnect to primary server."));
                }
            }
            boolean primaryRestoredSuccessfully = false;
            if (this.facade.remoteCacheAttributes.getFailoverIndex() > 0) {
                primaryRestoredSuccessfully = this.restorePrimary();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Primary recovery success state = " + primaryRestoredSuccessfully));
                }
            }
            if (primaryRestoredSuccessfully) continue;
            try {
                log.warn((Object)("Failed to reconnect to primary server. Cache failover runner is going to sleep for " + idlePeriod + " milliseconds."));
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.facade.remoteCacheAttributes.getFailoverIndex() > 0 || !this.alright);
    }

    private boolean restorePrimary() {
        block22: {
            String[] failovers = this.facade.remoteCacheAttributes.getFailovers();
            String server = failovers[0];
            if (log.isInfoEnabled()) {
                log.info((Object)("Trying to restore connection to primary remote server [" + server + "]"));
            }
            try {
                RemoteCacheAttributes rca = (RemoteCacheAttributes)this.facade.remoteCacheAttributes.copy();
                rca.setRemoteHost(server.substring(0, server.indexOf(":")));
                rca.setRemotePort(Integer.parseInt(server.substring(server.indexOf(":") + 1)));
                RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, this.cacheMgr, this.cacheEventLogger, this.elementSerializer);
                AuxiliaryCache ic = rcm.getCache(rca.getCacheName());
                if (ic != null) {
                    if (ic.getStatus() == 1) {
                        try {
                            if (this.facade.noWaits[0] != null && this.facade.noWaits[0].getStatus() == 1) {
                                int fidx = this.facade.remoteCacheAttributes.getFailoverIndex();
                                if (fidx > 0) {
                                    String serverOld = failovers[fidx];
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Failover Index = " + fidx + " the server at that index is [" + serverOld + "]"));
                                    }
                                    if (serverOld != null) {
                                        RemoteCacheAttributes rcaOld = (RemoteCacheAttributes)this.facade.remoteCacheAttributes.copy();
                                        rcaOld.setRemoteHost(serverOld.substring(0, serverOld.indexOf(":")));
                                        rcaOld.setRemotePort(Integer.parseInt(serverOld.substring(serverOld.indexOf(":") + 1)));
                                        RemoteCacheManager rcmOld = RemoteCacheManager.getInstance(rcaOld, this.cacheMgr, this.cacheEventLogger, this.elementSerializer);
                                        if (rcmOld != null) {
                                            rcmOld.removeRemoteCacheListener(rcaOld);
                                        }
                                        if (log.isInfoEnabled()) {
                                            log.info((Object)("Successfully deregistered from FAILOVER remote server = " + serverOld));
                                        }
                                    }
                                } else if (fidx == 0) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"No need to restore primary, it is already restored.");
                                        return true;
                                    }
                                } else if (fidx < 0) {
                                    log.warn((Object)"Failover index is less than 0, this shouldn't happen");
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)("Trouble trying to deregister old failover listener prior to restoring the primary = " + server), (Throwable)e);
                        }
                        RemoteCacheNoWait failoverNoWait = this.facade.noWaits[0];
                        this.facade.noWaits = new RemoteCacheNoWait[1];
                        this.facade.noWaits[0] = (RemoteCacheNoWait)ic;
                        this.facade.remoteCacheAttributes.setFailoverIndex(0);
                        if (log.isInfoEnabled()) {
                            String message = "Successfully reconnected to PRIMARY remote server.  Substituted primary for failoverNoWait [" + failoverNoWait + "]";
                            log.info((Object)message);
                            if (this.facade.getCacheEventLogger() != null) {
                                this.facade.getCacheEventLogger().logApplicationEvent("RemoteCacheFailoverRunner", "RestoredPrimary", message);
                            }
                        }
                        return true;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Primary server status in error, not connected.");
                    }
                    break block22;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Primary server is null, not connected.");
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bad() {
        if (this.alright) {
            RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
            synchronized (remoteCacheFailoverRunner) {
                this.alright = false;
            }
        }
    }
}

