/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ClientErrorMgmt {
    private static String nextLineChar = "\r\n";

    public static void reportError(Exception exception, String string) {
        string = string == null ? "" : string;
        String string2 = Config.getString("log_error_folder");
        Date date = new Date();
        String string3 = string2 + "errorlogs";
        if (!new File(string3).isDirectory()) {
            new File(string3).mkdirs();
        }
        String string4 = string2 + "errorlogs" + File.separator + "error" + new SimpleDateFormat("dd_MM_yyyy").format(date) + ".log";
        File file = new File(string4);
        try {
            boolean bl = true;
            FileWriter fileWriter = new FileWriter(file, bl);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyy h:mm:ss a");
            String string5 = "-------- " + simpleDateFormat.format(new Date()) + " ------" + nextLineChar + ClientErrorMgmt.collectErrorStack(exception, string) + "***********************" + nextLineChar;
            if (!file.exists()) {
                file.createNewFile();
            }
            fileWriter.append(string5 + nextLineChar + " " + nextLineChar);
            fileWriter.flush();
            fileWriter.close();
            String string6 = Config.getString("log_error_to_console");
            if (string6 != null && string6.equalsIgnoreCase("yes")) {
                System.out.println(string5);
            }
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    private static String collectErrorStack(Exception exception, String string) throws Exception {
        int n;
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string2 = "";
        if (string != null) {
            string2 = string2 + string.trim() + nextLineChar;
        }
        string2 = string2 + "ERROR MSG:" + exception.getMessage() + nextLineChar;
        int n2 = 0;
        for (n = 0; n < stackTraceElementArray.length; ++n) {
            if (!stackTraceElementArray[n].getClassName().startsWith("com.fe.")) continue;
            n2 = n;
        }
        n = 4;
        n2 = n2 > n ? n2 - n : 0;
        int n3 = 1;
        String string3 = Config.getString("log_error_to_console_full");
        if (string3 != null && string3.equalsIgnoreCase("yes")) {
            for (int i = n2; i < stackTraceElementArray.length; ++i) {
                String string4 = "  ";
                string2 = stackTraceElementArray[i].getClassName().startsWith("com.fe.") ? string2 + "->" + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + "()" + nextLineChar : string2 + string4 + "" + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + "()" + nextLineChar;
            }
        } else {
            for (int i = n2; i < stackTraceElementArray.length; ++i) {
                if (i > n2 + n && !stackTraceElementArray[i].getClassName().startsWith("com.fe.")) continue;
                String string5 = "";
                for (int j = 0; j < n3; ++j) {
                    string5 = string5 + " ";
                }
                ++n3;
                if (stackTraceElementArray[i].getClassName().startsWith("com.fe.")) {
                    string5 = string5 + "->";
                }
                string2 = string2 + string5 + "" + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + "()" + nextLineChar;
            }
        }
        return string2;
    }
}

