/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.client.Authenticated;
import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.RFunctionMgmt;
import com.fe.db.InfrastructureDB;
import com.fe.db.RFunctionDB;
import com.fe.db.SchedulerDB;
import com.fe.json.JSONArray;
import com.fe.json.JSONObject;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class JspXHRRequest
extends Authenticated {
    public JspXHRRequest(HttpServletRequest httpServletRequest) throws Exception {
        super(httpServletRequest);
    }

    public String getXHRDataScheduler() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            String string;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            JSONArray jSONArray = new JSONArray();
            if (this.getRequest().getParameter("term") != null && this.getRequest().getParameter("term") != null) {
                string = this.getRequest().getParameter("term");
                List list = schedulerDB.getAutoCompleteXHR(string);
                for (Map map : list) {
                    jSONArray.put(map);
                }
            }
            string = jSONArray.toString();
            return string;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String getXHRDataR() throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            String string;
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            JSONArray jSONArray = new JSONArray();
            if (this.getRequest().getParameter("term") != null && this.getRequest().getParameter("term") != null) {
                string = this.getRequest().getParameter("term");
                List list = rFunctionDB.autoCompleteFunctions(string);
                for (Map map : list) {
                    jSONArray.put(map);
                }
            }
            string = jSONArray.toString();
            return string;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public String getNotificationData() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        InfrastructureDB infrastructureDB = InfrastructureDB.getInfrastructureDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            infrastructureDB.connectDB(Config.getString("db_infrastructure_name"));
            List<String> list = infrastructureDB.getThemeByUsernameAccess(this.getAuthenticatedUser());
            List list2 = schedulerDB.getFailedLast2Days(list);
            for (Map map : list2) {
                jSONArray.put(map);
            }
            jSONObject.put("failed_scripts", jSONArray);
            String string = jSONObject.toString();
            return string;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            infrastructureDB.closeDB();
        }
    }

    public String getJSON() throws Exception {
        String string = this.getRequest().getParameter("callback");
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            String string2;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            JSONArray jSONArray = new JSONArray();
            if (this.getRequest().getParameter("search_name") != null || this.getRequest().getParameter("search_id") != null) {
                Object object;
                string2 = "";
                if (this.getRequest().getParameter("search_name") != null) {
                    object = this.getRequest().getParameter("search_name");
                    string2 = schedulerDB.getTop20IdNameByNameQuery((String)object);
                }
                if (this.getRequest().getParameter("search_id") != null) {
                    object = this.getRequest().getParameter("search_id");
                    string2 = schedulerDB.getTop20IdNameByIdQuery((String)object);
                }
                object = schedulerDB.getSingleColData(string2);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    jSONArray.put(string3);
                }
            }
            string2 = string + "(" + jSONArray.toString() + ");";
            return string2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String getExecutionLogs(int n, long l) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            JSONArray jSONArray = new JSONArray();
            Vector vector = schedulerDB.getSchedulerExeLogs(n, l);
            jSONArray.put(vector);
            String string = jSONArray.toString();
            return string;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String listLast2DaysFailedDetails(long l, String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string2 = schedulerDB.getHistoryQueueLogsDateQuery(l, string);
            Date date = new Date();
            List list = schedulerDB.listOfHistoryQueueLogs(date.getTime(), string2);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("list", list);
            String string3 = jSONObject.toString();
            return string3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }
}

