/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.ValueObject;
import com.fe.auth.AuthUser;
import com.fe.client.AbstractTeamOrgMgmt;
import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.SchedulerMgmt;
import com.fe.db.RFunctionDB;
import com.fe.db.SchedulerDB;
import com.fe.svn.SVNSync4RFunction;
import com.fe.util.FindStringInFiles;
import com.fe.util.WikiRFunctionManual;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNLogEntry;

public class RFunctionMgmt
extends AbstractTeamOrgMgmt {
    private HttpServletRequest request = null;
    private Logger log = Logger.getLogger(RFunctionMgmt.class);
    private static String dbname = Config.getString("db_rfunction");
    private static JCS lockcache = null;
    private String cache_packaged_key = "packaged_functions";
    public static String RFUNCTION_FILE_EXTENSION = ".r";
    private static String FUNCTION_ID = "function_id";
    private static String LOCK_DURATION = "duration";
    private static String USER = "user";
    private static String PACKAGE_ACTION_OVERWRITEOWNER = "overwrite_owner";
    private static String PACKAGE_ACTION_ADDTAG = "add_tag";
    private static String PACKAGE_ACTION_REMOVETAG = "remove_tag";
    private static String PACKAGE_ACTION_ADDNOTIFICATION = "add_noti";
    private static String PACKAGE_ACTION_REMOVENOTIFICATION = "remove_noti";

    public RFunctionMgmt() throws Exception {
    }

    public RFunctionMgmt(HttpServletRequest httpServletRequest) throws Exception {
        super(httpServletRequest);
    }

    private static JCS getLockCache() throws Exception {
        if (lockcache == null) {
            lockcache = JCS.getInstance((String)"lock-cache");
        }
        return lockcache;
    }

    public boolean lockFunction(int n, long l) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            if (l > 0L) {
                this.refreshCache(n, l, string);
            } else {
                rFunctionDB.updateLock(n, string);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            rFunctionDB.closeDB();
        }
    }

    private String getLockedBy(int n, SchedulerDB schedulerDB, RFunctionDB rFunctionDB) throws Exception {
        Object object;
        String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
        Map map = rFunctionDB.getRFunction(n);
        String string2 = null;
        if (map.get("lockedby") != null) {
            string2 = (String)map.get("lockedby");
        } else {
            object = RFunctionMgmt.getLockCache().getMatching("^[A-Za-z0-9]+$");
            if (object != null) {
                for (String string3 : object.keySet()) {
                    Map map2 = (Map)object.get(string3);
                    try {
                        int n2 = (Integer)map2.get(FUNCTION_ID);
                        long l = (Long)map2.get(LOCK_DURATION);
                        String string4 = (String)map2.get(USER);
                        if (n2 != n) continue;
                        string2 = string4;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        object = string2;
        return object;
    }

    public boolean deleteFunction(int n) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            Map map = this.createFolderIfNotExist("Trash", "trash");
            int n2 = (Integer)map.get("folder_id");
            this.moveFile2Folder(n, n2);
            rFunctionDB.updateFunctionDeleted(n);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean unLockFunctionFromCache(int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            this.removeLockFromCache(n, string);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public boolean unLockFunction(int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            this.removeLockFromCache(n, string);
            rFunctionDB.updateLock(n, null);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            rFunctionDB.closeDB();
        }
    }

    public boolean editorActiveDetected() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            HashMap hashMap = RFunctionMgmt.getLockCache().getMatching("^[A-Za-z0-9]+$");
            if (hashMap != null) {
                for (String string2 : hashMap.keySet()) {
                    if (!string2.startsWith(string)) continue;
                    Map map = (Map)hashMap.get(string2);
                    int n = (Integer)map.get(FUNCTION_ID);
                    long l = (Long)map.get(LOCK_DURATION);
                    String string3 = (String)map.get(USER);
                    if (!string3.equals(string)) continue;
                    this.refreshCache(n, l, string3);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    private void removeLockFromCache(int n, String string) throws Exception {
        String string2 = string + n;
        if (RFunctionMgmt.getLockCache().get((Object)string2) != null) {
            RFunctionMgmt.getLockCache().remove((Object)string2);
        }
    }

    private void refreshCache(int n, long l, String string) throws Exception {
        String string2 = string + n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FUNCTION_ID, n);
        hashMap.put(LOCK_DURATION, l);
        hashMap.put(USER, string);
        IElementAttributes iElementAttributes = RFunctionMgmt.getLockCache().getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds(l);
        if (RFunctionMgmt.getLockCache().get((Object)string2) != null) {
            RFunctionMgmt.getLockCache().remove((Object)string2);
        }
        RFunctionMgmt.getLockCache().put((Object)string2, hashMap, iElementAttributes);
    }

    public Map getFolderPanelData(String string, boolean bl, boolean bl2) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            if (!bl2) {
                Object object22;
                object = rFunctionDB.listRFunctions();
                List list = rFunctionDB.listFunctionGroups();
                List list2 = rFunctionDB.listOfFolders();
                HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
                for (Object object22 : list2) {
                    if (object22.get("folder_name") == null) continue;
                    hashMap2.put((String)object22.get("folder_name"), new Integer(0));
                }
                List list3 = this.getUnPackagedSources(hashMap2);
                object22 = new Vector();
                HashMap hashMap3 = new HashMap();
                for (Map map : list) {
                    ValueObject valueObject = new ValueObject();
                    valueObject.setKey((String)map.get("group_uid"));
                    valueObject.setValue((String)map.get("group_name"));
                    ((Vector)object22).add(valueObject);
                    hashMap3.put(map.get("group_uid"), map.get("color_code"));
                }
                hashMap.put("func_2build", list3);
                hashMap.put("folder_2build", hashMap2);
                hashMap.put("rfunctions", object);
                hashMap.put("folders", list2);
                hashMap.put("groups", object22);
                hashMap.put("tags", rFunctionDB.getTags());
                hashMap.put("group_colors", hashMap3);
                hashMap.putAll(this.getThemeAccessData(rFunctionDB));
            }
            if (string != null) {
                hashMap.put("open_functions", this.getRFunctions(string, bl));
            }
            hashMap.put("sourced_functions", this.getSourcedFunctions());
            hashMap.put("lite", bl2);
            object = hashMap;
            return object;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public Map getItemPrivilegeNotifications(ArrayList arrayList, ArrayList arrayList2) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            Map map = this.getItemPrivilegeNotifications(arrayList, arrayList2, rFunctionDB);
            return map;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean updateFunctionOrder(int n, int[] nArray) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            rFunctionDB.updateFunctionOrder(nArray);
            String string = rFunctionDB.getFolderName(n);
            List list = rFunctionDB.listAllRScriptNames(n);
            this.addLineInSource(string, null, list, new Integer(0));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean updateFolderOrder(int[] nArray) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            rFunctionDB.updateFolderOrder(nArray);
            this.syncFoldersWith4ESource(rFunctionDB);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public Map getFolderTree() throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            HashMap<String, List> hashMap = new HashMap<String, List>();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            List list = rFunctionDB.listFunctionGroups();
            List list2 = rFunctionDB.listOfFolders();
            Vector<ValueObject> vector = new Vector<ValueObject>();
            for (Map map : list) {
                ValueObject valueObject = new ValueObject();
                valueObject.setKey((String)map.get("group_uid"));
                valueObject.setValue((String)map.get("group_name"));
                vector.add(valueObject);
            }
            hashMap.put("folders", list2);
            hashMap.put("groups", vector);
            HashMap<String, List> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public void setGroupOrder(Vector vector) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            rFunctionDB.setGroupOrder(vector);
            this.syncFoldersWith4ESource(rFunctionDB);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public Map getRFunction(int n, boolean bl) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = rFunctionDB.getRFunction(n);
            String string = (String)map.get("function_name");
            String string2 = this.getFunctionWiki(string);
            if (string2.contains("\"noarticletext\"")) {
                rFunctionDB.updateWikiDone(n, 0);
            } else {
                rFunctionDB.updateWikiDone(n, 1);
            }
            Map map2 = this.getDataBundle4Function(map, rFunctionDB, schedulerDB);
            String string3 = (String)((Map)map2.get("data")).get("lockedby");
            String string4 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            String string5 = this.getAccessPrivilege(n, rFunctionDB);
            if (string5 == null || string5 != null && string5.equals("")) {
                map2.put("access", ACCESS_PRIVILEGE_R);
                string5 = ACCESS_PRIVILEGE_R;
            } else {
                map2.put("access", string5);
            }
            map2.put("isAuthorized", this.isAuthorizedUser(schedulerDB));
            map2.put("authorizedUser", this.getAuthorizedUser(schedulerDB));
            map2.put("tag_follow", this.getItemTags2(n, rFunctionDB));
            if (!bl) {
                if ((string3 == null || string3.equals("") || string3.equalsIgnoreCase(string4)) && string5.equalsIgnoreCase(ACCESS_PRIVILEGE_RWX)) {
                    this.refreshCache(n, 300L, string4);
                }
            } else {
                map2.put("readonly", true);
            }
            Map map3 = map2;
            return map3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
            schedulerDB.closeDB();
        }
    }

    public boolean updateAllWikiIcon(int n, int n2) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            Map map = rFunctionDB.getAllFunctionNamesID(" (is_wiki_done<>1 or is_wiki_done is null) AND id BETWEEN " + n + " AND " + n2);
            for (Integer n3 : map.keySet()) {
                String string = (String)map.get(n3);
                String string2 = this.getFunctionWiki(string);
                this.log.info((Object)("updating rfunction:" + string));
                if (string2.contains("\"noarticletext\"")) {
                    rFunctionDB.updateWikiDone(n3, 0);
                    continue;
                }
                rFunctionDB.updateWikiDone(n3, 1);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public Vector getRFunctions(String string, boolean bl) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            Vector<Map> vector2 = new Vector<Map>();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector3 = rFunctionDB.getRFunctions(vector);
            String string2 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            for (Map map : vector3) {
                Map map2 = this.getDataBundle4Function(map, rFunctionDB, schedulerDB);
                int n = (Integer)map.get("id");
                String string3 = (String)((Map)map2.get("data")).get("lockedby");
                String string4 = this.getAccessPrivilege(n, rFunctionDB);
                if (string4 == null || string4 != null && string4.equals("")) {
                    map2.put("access", ACCESS_PRIVILEGE_R);
                    string4 = ACCESS_PRIVILEGE_R;
                } else {
                    map2.put("access", string4);
                }
                if (!bl) {
                    if ((string3 == null || string3.equals("") || string3.equalsIgnoreCase(string2)) && string4.equalsIgnoreCase(ACCESS_PRIVILEGE_RWX)) {
                        this.refreshCache(n, 300L, string2);
                    }
                } else {
                    map2.put("readonly", true);
                }
                map2.put("isAuthorized", this.isAuthorizedUser(schedulerDB));
                map2.put("authorizedUser", this.getAuthorizedUser(schedulerDB));
                map2.put("tag_follow", this.getItemTags2(n, rFunctionDB));
                vector2.add(map2);
            }
            Vector<Map> vector4 = vector2;
            return vector4;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
            schedulerDB.closeDB();
        }
    }

    private Map getDataBundle4Function(Map map, RFunctionDB rFunctionDB, SchedulerDB schedulerDB) throws Exception {
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string2 = Config.getString("r_function_source_folder");
        String string3 = Config.getString("r_function_path_url_prefix");
        String string4 = rFunctionDB.getFolderName((Integer)map.get("folder_id"));
        int n = (Integer)map.get("id");
        String string5 = string = (String)map.get("script_file");
        string = string2 + (string4 != null ? string4 + File.separator : "") + string;
        String string6 = this.getContent(string);
        String string7 = (String)map.get("lockedby");
        if (string7 == null || string7 != null && string7.equals("")) {
            try {
                map.put("lockedby", this.getLockedBy(n, schedulerDB, rFunctionDB));
            }
            catch (Exception exception) {
                this.log.error((Object)("getDataBundle4Function() error:" + exception.getMessage()));
            }
        }
        hashMap.put("content", string6);
        hashMap.put("data", map);
        hashMap.put("isAuthorized", new SchedulerMgmt(this.getRequest()).isAuthorizedUser(schedulerDB));
        hashMap.put("authorizedUser", new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB));
        hashMap.put("path", string3 + "\\" + string4 + "\\" + string5);
        return hashMap;
    }

    public boolean moveFolder(int n, String string) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            rFunctionDB.moveFolder(n, string);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + n + " new_group_id:" + string);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public Map createRFunction(String string, String string2, String string3, int n) throws Exception {
        String string4 = Config.getString("r_function_source_folder");
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Pattern pattern = Pattern.compile("^[a-z][a-zA-Z0-9.]{2,50}+$");
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) {
                throw new Exception("Illegal function name, It should start with lower case, It should be Alpha-numeric, Min 2 characters, Max 50 chars, No space and No special characters except dot (.)");
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = rFunctionDB.getRFunction(string2);
            if (map != null && map.size() > 0) {
                throw new Exception("ERROR: Function name: " + string2 + " alerady existing, please try different name");
            }
            if (string3 == null || string3 != null && string3.equals("")) {
                string3 = "#" + string2 + ".r\n";
                string3 = string3 + "#created on " + new SimpleDateFormat("dd-MMM-yyyy HH:mm").format(new Date());
            }
            String string5 = rFunctionDB.getFolderName(Integer.parseInt(string));
            String string6 = string2 + RFUNCTION_FILE_EXTENSION;
            String string7 = string4 + (string5 != null ? string5 + File.separator : "") + string6;
            List list = rFunctionDB.listAllRScriptNames(Integer.parseInt(string));
            if (!new File(string7).isFile()) {
                this.createContent(string7, string3, string5, string6, list, n);
            }
            int n2 = rFunctionDB.createFunction(Integer.parseInt(string), string2, string6, n);
            this.synchrnizeSVN(string2, string3, null, rFunctionDB, schedulerDB, n2);
            Map map2 = rFunctionDB.getRFunction(n2);
            String string8 = (String)map2.get("script_file");
            string8 = string4 + (string5 != null ? string5 + File.separator : "") + string8;
            String string9 = this.getContent(string8);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("content", string9);
            hashMap2.put("data", map2);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map2);
            hashMap.put("rfunctions", vector);
            boolean bl = true;
            hashMap.put("func_data", this.getRFunction(n2, !bl));
            HashMap<String, Object> hashMap3 = hashMap;
            return hashMap3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + string + " fname:" + string2 + "  script:" + string3);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
            schedulerDB.closeDB();
        }
    }

    public Map modifyRFunction(int n, String string, String string2, List list, List list2) throws Exception {
        String string3 = Config.getString("r_function_source_folder");
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string4 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            String string5 = this.getLockedBy(n, schedulerDB, rFunctionDB);
            if (string5 != null && !string4.equalsIgnoreCase(this.getLockedBy(n, schedulerDB, rFunctionDB))) {
                throw new Exception("This function is currently locked by user " + string5);
            }
            Map map = rFunctionDB.getRFunction(n);
            String string6 = (String)map.get("script_file");
            String string7 = (String)map.get("function_name");
            Number number = (Number)map.get("is_class");
            String string8 = "";
            try {
                string8 = rFunctionDB.getFolderName((Integer)map.get("folder_id"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string9 = string3 + (string8 != null ? string8 + File.separator : "") + string6;
            List list3 = rFunctionDB.listAllRScriptNames((Integer)map.get("folder_id"));
            this.createContent(string9, string, string8, string6, list3, number);
            SVNSync4RFunction sVNSync4RFunction = this.synchrnizeSVN(string7, string, string2, rFunctionDB, schedulerDB, n);
            String string10 = sVNSync4RFunction.getLastChanged(string7);
            Map map2 = rFunctionDB.getRFunction(n);
            int n2 = 0;
            if (list != null && list.size() > 0) {
                try {
                    n2 = Integer.parseInt(list.get(0) + "");
                }
                catch (Exception exception) {
                    this.log.error((Object)("error while converting owner id, e:" + exception.getMessage()));
                }
            }
            rFunctionDB.updatedOwnerIDNow(n2, n);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map2);
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            hashMap2.put(string8, (Integer)map.get("folder_id"));
            List list4 = this.getUnPackagedSources(hashMap2);
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            hashMap3.put("function_name", string7);
            hashMap3.put("current_user", this.getAuthorizedUser(schedulerDB));
            hashMap3.put("diff", string10);
            hashMap3.put("comments", string2);
            String string11 = "function_modified_alert.txt";
            long l = sVNSync4RFunction.lastRevision(string7);
            this.updateAllItemTags(n, list, list2, rFunctionDB, schedulerDB, string7, string2, l, string10, hashMap3, string11);
            hashMap.put("rfunctions", vector);
            hashMap.put("function_id", n);
            hashMap.put("func_2build", list4);
            hashMap.put("revisions", this.getSVNLogs(string7));
            hashMap.put("function_name", string7);
            hashMap.putAll(this.getThemeAccessData(rFunctionDB));
            HashMap<String, Object> hashMap4 = hashMap;
            return hashMap4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            rFunctionDB.closeDB();
        }
    }

    private void createRFunction11(String string, String string2, String string3, String string4) throws Exception {
        String string5 = Config.getString("r_function_source_folder");
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            HashMap hashMap = new HashMap();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            Map map = rFunctionDB.getRFunction(string2);
            if (map != null && map.size() > 0) {
                throw new Exception("ERROR: Function name: " + string2 + " alerady existing, please try different name");
            }
            if (string3 == null || string3 != null && string3.equals("")) {
                string3 = "#" + string2 + ".r\n";
                string3 = string3 + "#created on " + new SimpleDateFormat("dd-MMM-yyyy HH:mm").format(new Date());
            }
            String string6 = rFunctionDB.getFolderName(Integer.parseInt(string));
            String string7 = string2 + (string4 == null ? RFUNCTION_FILE_EXTENSION : string4);
            String string8 = string5 + (string6 != null ? string6 + File.separator : "") + string7;
            if (!new File(string8).isFile()) {
                this.createContent(string8, string3, string6, string7, new Vector(), new Integer(0));
            }
            int n = rFunctionDB.createFunction(Integer.parseInt(string), string2, string7, 0);
            this.synchrnizeSVN11(string2, string3, null, rFunctionDB, n);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    private boolean renameSVN(String string, String string2, String string3, String string4, RFunctionDB rFunctionDB, int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Map map;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string5 = Config.getString("svn_user_r");
            String string6 = Config.getString("svn_pwd_r");
            SchedulerMgmt schedulerMgmt = new SchedulerMgmt(this.getRequest());
            String string7 = schedulerMgmt.getPeerIPAddress();
            String string8 = this.getAuthenticatedUser();
            if (string4 == null) {
                string4 = "created on IP:" + string7 + " By:" + string8;
            }
            if ((map = schedulerDB.getSVNUser4WikiUser(string8)) != null && map.get("svn_username") != null && map.get("svn_password") != null) {
                string5 = (String)map.get("svn_username");
                string6 = (String)map.get("svn_password");
            }
            SVNSync4RFunction sVNSync4RFunction = new SVNSync4RFunction(string5, string6);
            sVNSync4RFunction.renameFile(string, string2, string3, string4);
            String string9 = "usr-" + string5.trim().toLowerCase();
            int n2 = rFunctionDB.addIfTagNotExist(string9);
            rFunctionDB.updateLast2UsersTag(n, n2);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.log.error((Object)"Error while committing function into SVN ");
            throw exception;
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {
                this.log.error((Object)("error while cloing db:" + exception.getMessage()));
            }
        }
    }

    private SVNSync4RFunction synchrnizeSVN(String string, String string2, String string3, RFunctionDB rFunctionDB, SchedulerDB schedulerDB, int n) throws Exception {
        try {
            Map map;
            String string4 = Config.getString("svn_user_r");
            String string5 = Config.getString("svn_pwd_r");
            SchedulerMgmt schedulerMgmt = new SchedulerMgmt(this.getRequest());
            String string6 = schedulerMgmt.getPeerIPAddress();
            String string7 = this.getAuthenticatedUser();
            if (string3 == null) {
                string3 = "created on IP:" + string6 + " By:" + string7;
            }
            if ((map = schedulerDB.getSVNUser4WikiUser(string7)) != null && map.get("svn_username") != null && map.get("svn_password") != null) {
                string4 = (String)map.get("svn_username");
                string5 = (String)map.get("svn_password");
            }
            SVNSync4RFunction sVNSync4RFunction = new SVNSync4RFunction(string4, string5);
            sVNSync4RFunction.syncFile(string, string2, string3);
            return sVNSync4RFunction;
        }
        catch (Exception exception) {
            this.log.error((Object)"Error while committing function into SVN ");
            throw exception;
        }
    }

    private boolean synchrnizeSVN11(String string, String string2, String string3, RFunctionDB rFunctionDB, int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Map map;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string4 = Config.getString("svn_user_r");
            String string5 = Config.getString("svn_pwd_r");
            SchedulerMgmt schedulerMgmt = new SchedulerMgmt(this.getRequest());
            String string6 = schedulerMgmt.getPeerIPAddress();
            String string7 = this.getAuthenticatedUser();
            if (string3 == null) {
                string3 = "created on IP:" + string6 + " By:" + string7;
            }
            if ((map = schedulerDB.getSVNUser4WikiUser(string7)) != null && map.get("svn_username") != null && map.get("svn_password") != null) {
                string4 = (String)map.get("svn_username");
                string5 = (String)map.get("svn_password");
            }
            SVNSync4RFunction sVNSync4RFunction = new SVNSync4RFunction(string4, string5);
            sVNSync4RFunction.syncFile(string, string2, string3);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.log.error((Object)"Error while committing function into SVN ");
            throw exception;
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {
                this.log.error((Object)("error while cloing db:" + exception.getMessage()));
            }
        }
    }

    public boolean moveFile2Folder(int n, int n2) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            String string = Config.getString("r_function_source_folder");
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            Map map = rFunctionDB.getRFunction(n);
            Number number = (Number)map.get("is_class");
            String string2 = null;
            try {
                string2 = rFunctionDB.getFolderName((Integer)map.get("folder_id"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = rFunctionDB.getFolderName(n2);
            String string4 = (String)map.get("script_file");
            if (string2.equals(string3)) {
                throw new Exception("Moving failed! source and destination are the same..");
            }
            String string5 = string + (string2 != null ? string2 + File.separator : "") + string4;
            String string6 = string + (string3 != null ? string3 + File.separator : "") + string4;
            this.log.debug((Object)("old file:" + string5 + " new :" + string6));
            if (!new File(string5).renameTo(new File(string6))) {
                throw new Exception("Moving failed failed....");
            }
            this.log.debug((Object)("new folder_id:" + n + " function_id:" + n2));
            rFunctionDB.updateFunctionFolder(n, n2);
            List list = rFunctionDB.listAllRScriptNames(n2);
            this.updateSource4Moved(string2, string3, string4, list, number);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "function_id:" + n + " new_folder_id:" + n2);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean putbackFunction(int n, int n2) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            String string = Config.getString("r_function_source_folder");
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            Map map = rFunctionDB.getRFunction(n);
            String string2 = null;
            try {
                string2 = rFunctionDB.getFolderName((Integer)map.get("folder_id"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = rFunctionDB.getFolderName(n2);
            String string4 = (String)map.get("script_file");
            String string5 = string + (string2 != null ? string2 + File.separator : "") + string4;
            String string6 = string + (string3 != null ? string3 + File.separator : "") + string4;
            if (new File(string5).renameTo(new File(string6))) {
                this.log.debug((Object)("new folder_id:" + n + " function_id:" + n2));
                rFunctionDB.updateFunctionFolder(n, n2);
                List list = rFunctionDB.listAllRScriptNames(n2);
                Number number = (Number)map.get("is_class");
                try {
                    this.addLineInSource(string3, string4, list, number);
                }
                catch (Exception exception) {
                    this.log.error((Object)("ERROR:" + exception.getMessage()));
                    ClientErrorMgmt.reportError(exception, null);
                }
            } else {
                throw new Exception("Putting back the file from trash failed....");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "function_id:" + n + " new_folder_id:" + n2);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean renameFolder(int n, String string) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            String string2 = Config.getString("r_function_source_folder");
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            String string3 = rFunctionDB.getFolderName(n);
            String string4 = string2 + string3;
            String string5 = string2 + string;
            this.log.debug((Object)("renaming folder from " + string4 + " to " + string5));
            if (new File(string4).renameTo(new File(string5))) {
                rFunctionDB.renameFolder(n, string);
                String string6 = Config.getString("r_auto_source_inc_folder");
                if (string6 != null) {
                    File file = new File(string6 + string3 + RFUNCTION_FILE_EXTENSION);
                    File file2 = new File(string6 + string + RFUNCTION_FILE_EXTENSION);
                    if (file.exists()) {
                        file.renameTo(file2);
                    }
                    if (!file2.exists()) {
                        file2.createNewFile();
                    }
                }
            } else {
                throw new Exception("Renaming folder failed....");
            }
            this.syncFoldersWith4ESource(rFunctionDB);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + n + " foldername:" + string);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public Map createFolder(String string, String string2) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            Serializable serializable;
            String string3;
            File file;
            String string4 = Config.getString("r_function_source_folder");
            String string5 = string4 + string;
            if (new File(string5).isDirectory() || new File(string5).isFile()) {
                throw new Exception("Folder already existing folder failed....Path:" + string5);
            }
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            int n = rFunctionDB.getFolderID(string);
            if (n <= 0) {
                n = rFunctionDB.createFolder(string, string2);
            }
            if (!(file = new File(string5)).isDirectory() && !file.isFile()) {
                file.mkdirs();
            }
            if ((string3 = Config.getString("r_auto_source_inc_folder")) != null && !((File)(serializable = new File(string3 + string + RFUNCTION_FILE_EXTENSION))).exists()) {
                ((File)serializable).createNewFile();
            }
            this.syncFoldersWith4ESource(rFunctionDB);
            serializable = new HashMap<String, List>();
            List list = rFunctionDB.listOfFolders(string2);
            ((HashMap)serializable).put("folders", list);
            ((HashMap)serializable).put("folder_id", n);
            Serializable serializable2 = serializable;
            return serializable2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + string + " group_id:" + string2);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean deleteFolder(String string, int n) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            String string2 = Config.getString("r_function_source_folder");
            String string3 = string2 + string;
            if (new File(string3).exists() && new File(string3).delete()) {
                String string4 = Config.getString("r_auto_source_inc_folder");
                this.log.debug((Object)("folder_name:" + string + " folder_id:" + n));
                rFunctionDB.connectDB(RFunctionMgmt.getDBName());
                rFunctionDB.removeFolder(n);
                if (string4 != null) {
                    File file = new File(string4 + string + RFUNCTION_FILE_EXTENSION);
                    file.delete();
                    this.log.debug((Object)("Folder:" + file.getPath()));
                    this.syncFoldersWith4ESource(rFunctionDB);
                }
            } else {
                throw new Exception("No physical folder " + string3 + " found! or not able to delete");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + string + " folder_id:" + n);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    private Map createFolderIfNotExist(String string, String string2) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            File file;
            String string3 = Config.getString("r_function_source_folder");
            String string4 = string3 + string;
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            int n = rFunctionDB.getFolderID(string);
            if (n <= 0) {
                n = rFunctionDB.createFolder(string, string2);
            }
            if (!(file = new File(string4)).isDirectory() && !file.isFile()) {
                file.mkdirs();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List list = rFunctionDB.listOfFolders(string2);
            hashMap.put("folders", list);
            hashMap.put("folder_id", n);
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "folder_id:" + string + " group_id:" + string2);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    private String getContent(String string) throws Exception {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2 + "\r\n";
        }
        bufferedReader.close();
        return string3;
    }

    public boolean renameFunction(String string, int n) throws Exception {
        String string2 = Config.getString("r_function_source_folder");
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Pattern pattern = Pattern.compile("^[a-z][a-zA-Z0-9.]{1,50}+$");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                throw new Exception("Illegal function name, It should start with lower case, It should be Alpha-numeric, Min 2 characters, Max 50 chars, No space and No special characters except dot (.)");
            }
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            Map map = rFunctionDB.getRFunction(string);
            if (map != null && map.size() > 0) {
                throw new Exception("ERROR: Function name: " + string + " alerady existing, please try different name");
            }
            HashMap hashMap = new HashMap();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string3 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            String string4 = this.getLockedBy(n, schedulerDB, rFunctionDB);
            if (string4 != null && !string3.equalsIgnoreCase(this.getLockedBy(n, schedulerDB, rFunctionDB))) {
                throw new Exception("This function is currently locked by user " + string4);
            }
            Map map2 = rFunctionDB.getRFunction(n);
            String string5 = string + RFUNCTION_FILE_EXTENSION;
            String string6 = (String)map2.get("script_file");
            String string7 = (String)map2.get("function_name");
            Number number = (Number)map2.get("is_class");
            String string8 = "";
            try {
                string8 = rFunctionDB.getFolderName((Integer)map2.get("folder_id"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string9 = string2 + (string8 != null ? string8 + File.separator : "") + string6;
            String string10 = string2 + (string8 != null ? string8 + File.separator : "") + string5;
            Map map3 = this.getDataBundle4Function(map2, rFunctionDB, schedulerDB);
            String string11 = (String)map3.get("content");
            String string12 = "";
            string12 = "Renamed  " + string7 + "  --> " + string;
            this.log.debug((Object)("old file:" + string9 + " new :" + string10));
            if (!new File(string9).renameTo(new File(string10))) {
                throw new Exception("Renaming failed");
            }
            rFunctionDB.renameFunction(n, string, string5);
            Map map4 = rFunctionDB.getRFunction(n);
            int n2 = (Integer)map4.get("folder_id");
            List list = rFunctionDB.listAllRScriptNames(n2);
            this.renameSVN(string7, string, string11, string12, rFunctionDB, n);
            Map map5 = rFunctionDB.getRFunction(n);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map5);
            hashMap.put("rfunctions", vector);
            this.removeLineInSource(string8, string6);
            this.addLineInSource(string8, string5, list, number);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            rFunctionDB.closeDB();
        }
    }

    public boolean purgeFunction(int n) throws Exception {
        String string = Config.getString("r_function_source_folder");
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = rFunctionDB.getRFunction(n);
            String string2 = (String)map.get("script_file");
            String string3 = (String)map.get("function_name");
            String string4 = "";
            try {
                string4 = rFunctionDB.getFolderName((Integer)map.get("folder_id"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string5 = string + (string4 != null ? string4 + File.separator : "") + string2;
            File file = new File(string5);
            if (file.exists()) {
                file.delete();
            }
            String string6 = Config.getString("svn_user_r");
            String string7 = Config.getString("svn_pwd_r");
            Map map2 = rFunctionDB.getRFunction(n);
            int n2 = (Integer)map2.get("folder_id");
            List list = rFunctionDB.listAllRScriptNames(n2);
            String string8 = this.getAuthenticatedUser();
            Map map3 = schedulerDB.getSVNUser4WikiUser(string8);
            if (map3 != null && map3.get("svn_username") != null && map3.get("svn_password") != null) {
                string6 = (String)map3.get("svn_username");
                string7 = (String)map3.get("svn_password");
            }
            SVNSync4RFunction sVNSync4RFunction = new SVNSync4RFunction(string6, string7);
            sVNSync4RFunction.deleteFile(string3);
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            rFunctionDB.deleteFunction(n);
            this.removeLineInSource(string4, string2);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            rFunctionDB.closeDB();
        }
    }

    private void updateSource4Moved(String string, String string2, String string3, List list, Number number) throws Exception {
        String string4 = Config.getString("r_auto_source_inc_folder");
        String string5 = Config.getString("r_auto_source_inc_prefix");
        if (string4 != null && string5 != null) {
            try {
                this.removeLineInSource(string, string3);
                this.addLineInSource(string2, string3, list, number);
            }
            catch (Exception exception) {
                this.log.error((Object)("ERROR:" + exception.getMessage()));
                ClientErrorMgmt.reportError(exception, null);
            }
        }
    }

    private void removeLineInSource(String string, String string2) throws Exception {
        String string3 = Config.getString("r_auto_source_inc_folder");
        String string4 = Config.getString("r_auto_source_inc_prefix");
        File file = new File(string3 + string + RFUNCTION_FILE_EXTENSION);
        if (file.exists() && file.isFile()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = FileUtils.readLines((File)file);
            String string5 = string4 + string + "/" + string2;
            for (String string6 : list) {
                String string7 = "source(universalPath(\"" + string5 + "\")";
                if (string6.toUpperCase().indexOf(string7.toUpperCase()) >= 0 || string6.trim().equals("")) continue;
                arrayList.add(string6);
            }
            FileUtils.writeLines((File)file, arrayList);
        }
    }

    public List getUnPackagedSources(HashMap<String, Integer> hashMap) throws Exception {
        String string = Config.getString("r_auto_source_inc_folder");
        String string2 = Config.getString("r_auto_source_inc_prefix");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : hashMap.keySet()) {
            File file = new File(string + string3 + RFUNCTION_FILE_EXTENSION);
            int n = 0;
            if (file.exists() && file.isFile()) {
                ArrayList arrayList2 = new ArrayList();
                List list = FileUtils.readLines((File)file);
                for (String string4 : list) {
                    String string5;
                    if (!string4.contains(string5 = string2 + string3 + "/") || string4.indexOf(RFUNCTION_FILE_EXTENSION) <= 0) continue;
                    String string6 = string4.substring(string4.indexOf(string5) + string5.length(), string4.indexOf(RFUNCTION_FILE_EXTENSION));
                    arrayList.add(string6);
                    ++n;
                }
            }
            hashMap.put(string3, new Integer(n));
        }
        return arrayList;
    }

    private void addLineInSource(String string, String string2, List list, Number number) throws Exception {
        String string3 = Config.getString("r_auto_source_inc_folder");
        String string4 = Config.getString("r_auto_source_inc_prefix");
        int n = 0;
        if (string3 != null && string4 != null) {
            File file = new File(string3 + string + RFUNCTION_FILE_EXTENSION);
            boolean bl = false;
            try {
                Object object;
                Object object2;
                List list2 = null;
                if (file.exists() && file.isFile()) {
                    list2 = FileUtils.readLines((File)file);
                }
                n = 1;
                if (list2 != null && string2 != null) {
                    object2 = string4 + string + "/" + string2;
                    object = "source(universalPath(\"" + (String)object2 + "\")";
                    if (this.checkExist(list2, (String)object) != null) {
                        bl = true;
                    }
                    n = 2;
                }
                n = 3;
                if (string.equalsIgnoreCase("Trash")) {
                    bl = true;
                }
                if (!bl) {
                    object2 = string4 + string + "/" + string2;
                    object = (number != null && number.intValue() >= 1 ? "#" : "") + "source(universalPath(\"" + (String)object2 + "\")";
                    list2.add(object);
                }
                n = 6;
                if (!string.equalsIgnoreCase("Trash")) {
                    object2 = new BufferedWriter(new FileWriter(file, false));
                    ((Writer)object2).write("#updated this file on " + new Date().toString() + "\n");
                    for (String string5 : list) {
                        String string6 = string4 + string + "/" + string5;
                        String string7 = "tryCatch({source(universalPath(\"" + string6 + "\"))}, error = function(e) Say(\"Check source file " + string5 + "\"))";
                        String string8 = "source(universalPath(\"" + string6 + "\")";
                        String string9 = this.checkExist(list2, string8);
                        if (string9 != null) {
                            if (string9.trim().startsWith("#")) {
                                ((Writer)object2).append("#" + string7 + "\n");
                            } else {
                                ((Writer)object2).append(string7 + "\n");
                            }
                        }
                        n = 7;
                    }
                    ((BufferedWriter)object2).flush();
                    ((BufferedWriter)object2).close();
                    file.setWritable(true);
                    n = 8;
                }
                if (RFunctionMgmt.getLockCache().get((Object)this.cache_packaged_key) != null) {
                    RFunctionMgmt.getLockCache().remove((Object)this.cache_packaged_key);
                }
            }
            catch (Exception exception) {
                this.log.error((Object)("ERROR:" + exception.getMessage()));
                ClientErrorMgmt.reportError(exception, "subfolder:" + string + " fname:" + string2 + " pass:" + n + " is_class:" + number);
            }
        }
    }

    private String checkExist(List list, String string) throws Exception {
        String string2 = null;
        for (String string3 : list) {
            if (!string3.contains(string)) continue;
            string2 = string3;
        }
        return string2;
    }

    private void syncFoldersWith4ESource(RFunctionDB rFunctionDB) throws Exception {
        String string = Config.getString("r_auto_source_inc_folder");
        String string2 = Config.getString("r_auto_source_inc_prefix");
        String string3 = Config.getString("r_source_4e_function_file");
        String string4 = Config.getString("r_source_4e_function_file_path_perfix");
        File file = null;
        if (string3 != null && new File(string3).isFile()) {
            Object object;
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = rFunctionDB.listOfFolders();
            for (Object object3 : list) {
                String string5 = (String)object3.get("folder_name");
                object2 = new File(string + string5 + RFUNCTION_FILE_EXTENSION);
                if (((File)object2).isFile()) {
                    object = string4 + string5 + RFUNCTION_FILE_EXTENSION;
                    arrayList.add((String)object);
                    this.log.debug((Object)("file_line:" + (String)object));
                    continue;
                }
                this.log.debug((Object)("file note found:" + ((File)object2).getPath()));
            }
            file = new File(string3);
            if (arrayList.size() > 0) {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
                bufferedWriter.write("#updated this file on " + new Date().toString() + "\n");
                for (String string5 : arrayList) {
                    object2 = "";
                    try {
                        object = new StringTokenizer(string5, "\\");
                        if (((StringTokenizer)object).countTokens() > 1) {
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                object2 = ((StringTokenizer)object).nextToken();
                            }
                        }
                        if (!((String)object2).toLowerCase().endsWith(".r")) {
                            object2 = string5;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bufferedWriter.append("tryCatch({source(universalPath(\"" + string5 + "\"))}, error = function(e) Say(\"Check source file for " + (String)object2 + "\"))" + "\n");
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                file.setWritable(true);
            }
        } else {
            this.log.error((Object)("currently main source file configured to:" + string3));
            this.log.error((Object)"main source file that contains folder named source R not found or invlid, check :r_source_4e_function_file key on config file");
        }
    }

    private Map getSourcedFunctions() throws Exception {
        String string = Config.getString("r_auto_source_inc_folder");
        String string2 = Config.getString("r_auto_source_inc_prefix");
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        String string3 = "packaged_functions";
        if (RFunctionMgmt.getLockCache().get((Object)string3) != null) {
            Map map = (Map)RFunctionMgmt.getLockCache().get((Object)string3);
            return map;
        }
        HashMap hashMap = new HashMap();
        try {
            HashMap hashMap22;
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            List list = rFunctionDB.listOfFolders();
            for (HashMap hashMap22 : list) {
                Integer n = (Integer)hashMap22.get("id");
                String string4 = (String)hashMap22.get("folder_name");
                File file = new File(string + string4 + RFUNCTION_FILE_EXTENSION);
                if (!file.exists() || !file.isFile()) continue;
                List list2 = FileUtils.readLines((File)file);
                List<Map> list3 = rFunctionDB.listOfFunctions(n);
                for (Map map : list3) {
                    String string5 = string2 + string4 + "/" + map.get("script_file");
                    String string6 = "source(universalPath(\"" + string5 + "\")";
                    if (!list2.contains(string6)) continue;
                    hashMap.put(map.get("id"), true);
                }
            }
            IElementAttributes iElementAttributes = RFunctionMgmt.getLockCache().getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds(6000L);
            RFunctionMgmt.getLockCache().put((Object)string3, hashMap, iElementAttributes);
            hashMap22 = hashMap;
            return hashMap22;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    private void addLineInSource_old(String string, String string2) throws Exception {
        String string3 = Config.getString("r_auto_source_inc_folder");
        String string4 = Config.getString("r_auto_source_inc_prefix");
        if (string3 != null && string4 != null) {
            File file = new File(string3 + string + RFUNCTION_FILE_EXTENSION);
            boolean bl = true;
            boolean bl2 = false;
            try {
                Object object;
                Object object2;
                String string5 = string4 + string + "/" + string2;
                if (file.exists() && file.isFile()) {
                    object2 = FileUtils.readLines((File)file);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        String string6 = (String)object.next();
                        String string7 = "source(universalPath(\"" + string5 + "\")";
                        if (string6.toUpperCase().indexOf(string7.toUpperCase()) >= 0) {
                            bl2 = true;
                        }
                        bl = string6.equals("");
                    }
                }
                if (string.equalsIgnoreCase("Trash")) {
                    bl2 = true;
                }
                if (!bl2) {
                    object2 = (bl ? "" : System.getProperty("line.separator")) + "source(\"" + string5 + "\")";
                    object = new BufferedWriter(new FileWriter(file, true));
                    ((Writer)object).append((CharSequence)object2);
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                    file.setWritable(true);
                }
            }
            catch (Exception exception) {
                this.log.error((Object)("ERROR:" + exception.getMessage()));
                ClientErrorMgmt.reportError(exception, "subfolder:" + string + " fname:" + string2);
            }
        }
    }

    private void createContent(String string, String string2, String string3, String string4, List list, Number number) throws Exception {
        BufferedWriter bufferedWriter = null;
        File file = new File(string);
        bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string2);
        ((Writer)bufferedWriter).close();
        this.addLineInSource(string3, string4, list, number);
    }

    public static String getDBName() {
        return dbname;
    }

    public Vector getSVNLogs(String string) throws Exception {
        SVNSync4RFunction sVNSync4RFunction = new SVNSync4RFunction();
        TreeMap treeMap = new TreeMap();
        Vector<SVNLogEntry> vector = sVNSync4RFunction.log(string);
        if (vector != null && vector.size() > 0) {
            for (SVNLogEntry sVNLogEntry : vector) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");
                ValueObject valueObject = new ValueObject();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("author", sVNLogEntry.getAuthor());
                hashMap.put("date", simpleDateFormat.format(sVNLogEntry.getDate()));
                hashMap.put("message", sVNLogEntry.getMessage());
                hashMap.put("revision", sVNLogEntry.getRevision());
                hashMap.put("function_name", string);
                String string2 = null;
                if (sVNLogEntry.getChangedPaths() != null) {
                    for (String string3 : sVNLogEntry.getChangedPaths().keySet()) {
                        string3 = string3.substring(string3.lastIndexOf("/") + 1);
                        string2 = string2 == null ? string3 : string2 + "," + string3;
                    }
                    if (string2 != null) {
                        hashMap.put("path", string2);
                    }
                }
                treeMap.put(sVNLogEntry.getRevision(), hashMap);
            }
            return new Vector(treeMap.descendingMap().values());
        }
        return null;
    }

    public String getScriptRev(String string, String string2, boolean bl, String string3) throws Exception {
        try {
            SVNSync4RFunction sVNSync4RFunction = new SVNSync4RFunction();
            String string4 = null;
            string4 = bl ? sVNSync4RFunction.getScript(string, Long.parseLong(string2), string3) : sVNSync4RFunction.getWhatChanged(string, Long.parseLong(string2));
            if (string4 == null) {
                string4 = "No changes were made or first revision of this function";
            }
            return string4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public String getFunctionWiki(String string) throws Exception {
        WikiRFunctionManual wikiRFunctionManual = new WikiRFunctionManual();
        String string2 = wikiRFunctionManual.getWikiHTML(string);
        return string2;
    }

    public Map updateTags4Function(int n, int n2, boolean bl) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            HashMap hashMap = new HashMap();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            if (bl) {
                rFunctionDB.addTagIds4Function(n, n2);
            } else {
                rFunctionDB.removeTagIds4Function(n, n2);
            }
            Map map = rFunctionDB.getRFunction(n);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map);
            hashMap.put("rfunctions", vector);
            HashMap hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean migrateFiles(String string) throws Exception {
        try {
            Object object;
            Vector<String> vector = new Vector<String>();
            if (string != null && !string.equals("")) {
                object = new StringTokenizer(string, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    vector.add(((StringTokenizer)object).nextToken());
                }
            }
            object = Config.getString("r_function_source_folder");
            File[] fileArray = new File((String)object).listFiles();
            boolean bl = false;
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory() || vector.size() != 0 && !vector.contains(fileArray[i].getName())) continue;
                File[] fileArray2 = fileArray[i].listFiles();
                Map map = this.createFolderIfNotExist(fileArray[i].getName(), "imported");
                int n = (Integer)map.get("folder_id");
                for (int j = 0; j < fileArray2.length; ++j) {
                    String string2;
                    if (!fileArray2[j].isFile()) continue;
                    String string3 = this.getContent(fileArray2[j].getPath());
                    String string4 = fileArray2[j].getName().lastIndexOf(".") >= 0 ? fileArray2[j].getName().substring(0, fileArray2[j].getName().lastIndexOf(".")) : fileArray2[j].getName();
                    String string5 = string2 = fileArray2[j].getName().lastIndexOf(".") >= 0 ? fileArray2[j].getName().substring(fileArray2[j].getName().lastIndexOf(".")) : null;
                    if (n > 0) {
                        try {
                            this.createRFunction11(n + "", string4, string3, string2);
                        }
                        catch (Exception exception) {
                            this.log.error((Object)exception);
                        }
                    }
                    string3 = null;
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public Map getSearchR(String string) throws Exception {
        try {
            LinkedHashMap linkedHashMap = new FindStringInFiles(Config.getString("svn_local_path_r")).search(string, RFUNCTION_FILE_EXTENSION);
            String string2 = Config.getString("svn_local_path");
            LinkedHashMap linkedHashMap2 = new FindStringInFiles(string2).search(string, ".R");
            HashMap<String, LinkedHashMap> hashMap = new HashMap<String, LinkedHashMap>();
            hashMap.put("r", linkedHashMap);
            hashMap.put("scd", linkedHashMap2);
            return hashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Map getSearchScript(String var1_1) throws Exception {
        try {
            var2_2 = new HashMap<String, Object>();
            var3_4 = null;
            if (var1_1.contains("script_")) {
                var3_4 = Config.getString("svn_local_path");
                var4_5 = Pattern.compile("^(script_)([0-9]+)(.*)$", 32);
                var5_6 = var4_5.matcher(var1_1);
                if (var5_6.find() && var5_6.groupCount() > 2) {
                    var6_8 = SchedulerDB.getSchedulerDB();
                    var6_8.connectDB(BBSyncMgmt.getDBName());
                    try {
                        var7_9 = Integer.parseInt(var5_6.group(2));
                        var8_11 = var6_8.getScheduler(var7_9);
                        var2_2.put("item_id", var7_9);
                        var2_2.put("item_type", "scheduler");
                        if (var8_11.get("deleted") == null || ((Number)var8_11.get("deleted")).intValue() != 1) ** GOTO lbl49
                        var2_2.put("deleted", true);
                    }
                    catch (Exception var7_10) {
                        this.log.error((Object)("Error while getSearchScript() scd, e:" + var7_10.getMessage()));
                    }
                    finally {
                        var6_8.closeDB();
                    }
                }
            } else {
                var3_4 = Config.getString("svn_local_path_r");
                var4_5 = RFunctionDB.getRFunctionDB();
                try {
                    var4_5.connectDB(RFunctionMgmt.getDBName());
                    var5_6 = var4_5.getRFunctionForScriptFile(var1_1);
                    var2_2.put("item_type", "function");
                    if (var5_6 != null && var5_6.keySet().size() > 0) {
                        var2_2.put("item_id", var5_6.get("function_name"));
                        if (var5_6.get("folder_name") != null && var5_6.get("folder_name").toString().equalsIgnoreCase("trash")) {
                            var2_2.put("deleted", true);
                        }
                    }
                }
                catch (Exception var5_7) {
                    this.log.error((Object)("Error while getSearchScript() scd, e:" + var5_7.getMessage()));
                }
                finally {
                    var4_5.closeDB();
                }
            }
            var4_5 = var3_4.endsWith(File.separator) != false ? var3_4 : var3_4 + File.separator;
            var4_5 = (String)var4_5 + var1_1;
            var5_6 = new StringWriter();
            IOUtils.copy((InputStream)new FileInputStream(new File((String)var4_5)), (Writer)var5_6);
            var2_2.put("script", var5_6.toString());
            return var2_2;
        }
        catch (Exception var2_3) {
            var2_3.printStackTrace();
            throw var2_3;
        }
    }

    public Map getPackageInfo(String string) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Object object;
            String string2 = Config.getString("package.repository.unix");
            String string3 = Config.getString("package.repository.win");
            Map map = new HashMap();
            Map map2 = new HashMap();
            try {
                map = this.getPackageDescInfo(string2, string);
            }
            catch (Exception exception) {
                this.log.error((Object)("Error collecint unix package info e:" + exception.getMessage()));
            }
            try {
                map2 = this.getPackageDescInfo(string3, string);
            }
            catch (Exception exception) {
                this.log.error((Object)("Error collecint windows package info e:" + exception.getMessage()));
            }
            String string4 = "";
            try {
                object = Config.getString("r_auto_source_inc_folder");
                File file = new File((String)object + string + RFUNCTION_FILE_EXTENSION);
                string4 = file.exists() ? FileUtils.readFileToString((File)file) : "";
            }
            catch (Exception exception) {
                this.log.error((Object)("error while loading source file e:" + exception.getMessage()));
            }
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            object = rFunctionDB.getPackageInfo(string);
            int n = rFunctionDB.getFolderID(string);
            hashMap.put("package_id", n);
            hashMap.put("folders", rFunctionDB.listOfFolders());
            hashMap.put("required_packages", rFunctionDB.listRelatedFolderIds(n));
            hashMap.put("pinfo", object);
            hashMap.put("unix", map);
            hashMap.put("win", map2);
            hashMap.put("sourceloader", string4);
            hashMap.put("access", this.getPackageAccessPrivilege(n, rFunctionDB));
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
            schedulerDB.closeDB();
        }
    }

    public List resetPackageHirDep(String string) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            List list = rFunctionDB.getDefaultHierarchyDependsIds(string);
            int n = rFunctionDB.getFolderID(string);
            rFunctionDB.updateRelatedFolderIds(n, list);
            List list2 = list;
            return list2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean syncPackageHirDep(int n, List<Integer> list) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            rFunctionDB.updateRelatedFolderIds(n, list);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public Map getPackageMembersInfo(int n) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            Vector vector = rFunctionDB.getTags();
            hashMap.put("tags", vector);
            hashMap.put("theme_tags", rFunctionDB.getTagIds4Folder(n, "folder_tags"));
            hashMap.put("notification_tags", rFunctionDB.getTagIds4Folder(n, "folder_followtags"));
            hashMap.put("access", this.getPackageAccessPrivilege(n, rFunctionDB));
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean updatePackageThemes(int n, List list, String string) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            rFunctionDB.updateTagIds4Folder(n, list, SchedulerDB.REMOVE_BEFORE_UPDATE, string);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public boolean packageMemberAction(int n, int n2, int[] nArray, String string) throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            this.log.debug((Object)("packageMemberAction() folder_id:" + n + " tag_id:" + n2 + " action:" + string));
            if (string.equals(PACKAGE_ACTION_OVERWRITEOWNER)) {
                rFunctionDB.addTag4Package(n2, nArray, bl2);
                bl = true;
            }
            if (string.equals(PACKAGE_ACTION_ADDTAG)) {
                rFunctionDB.addTag4Package(n2, nArray, !bl2);
                bl = true;
            }
            if (string.equals(PACKAGE_ACTION_REMOVETAG)) {
                rFunctionDB.removeTag4Package(n2, nArray);
                bl = true;
            }
            if (string.equals(PACKAGE_ACTION_ADDNOTIFICATION)) {
                rFunctionDB.addNotificationTag4Package(n2, nArray, bl3);
                bl = true;
            }
            if (string.equals(PACKAGE_ACTION_REMOVENOTIFICATION)) {
                rFunctionDB.addNotificationTag4Package(n2, nArray, !bl3);
                bl = true;
            }
            boolean bl4 = bl;
            return bl4;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    private Map getPackageDescInfo(String string, final String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        File[] fileArray = new File(string).listFiles();
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return Long.valueOf(file2.lastModified()).compareTo(file.lastModified());
            }
        });
        String string3 = null;
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(string2);
            }
        };
        File[] fileArray2 = fileArray[0].listFiles(filenameFilter);
        String string4 = "";
        if (fileArray2.length > 0) {
            object4 = new FileInputStream(fileArray2[0]);
            if (fileArray2[0].getPath().endsWith(".tar.gz")) {
                string4 = "_nix";
                object3 = new TarArchiveInputStream((InputStream)new GZIPInputStream((InputStream)object4));
                object2 = null;
                while ((object2 = object3.getNextTarEntry()) != null) {
                    if (!object2.getName().equals(string2 + "/DESCRIPTION")) continue;
                    object = new byte[(int)object2.getSize()];
                    object3.read((byte[])object, 0, ((Object)object).length);
                    string3 = new String((byte[])object);
                }
                object3.close();
                ((FileInputStream)object4).close();
            } else {
                string4 = "_win";
                object3 = new ZipInputStream((InputStream)object4);
                object2 = null;
                while ((object2 = ((ZipInputStream)object3).getNextEntry()) != null) {
                    if (!((ZipEntry)object2).getName().equals(string2 + "/DESCRIPTION")) continue;
                    object = new byte[(int)((ZipEntry)object2).getSize()];
                    ((ZipInputStream)object3).read((byte[])object, 0, ((Object)object).length);
                    string3 = new String((byte[])object);
                }
                ((FileInputStream)object4).close();
                ((ZipInputStream)object3).close();
            }
        }
        object4 = null;
        object3 = new File("c:\\rnd\\temp\\rtn" + string4 + ".txt");
        FileUtils.writeStringToFile((File)object3, string3);
        if (string3 != null) {
            object4 = new LinkedHashMap();
            object2 = Pattern.compile("([A-Za-z]+)(:)((\\W)*(\\S)*(.)*)");
            object = ((Pattern)object2).matcher(string3);
            while (((Matcher)object).find()) {
                if (((Matcher)object).groupCount() < 3) continue;
                String string5 = ((Matcher)object).group(1);
                String string6 = ((Matcher)object).group(3);
                ((HashMap)object4).put(string5, string6);
            }
        }
        return object4;
    }

    private String getPackageAccessPrivilege(int n, RFunctionDB rFunctionDB) throws Exception {
        Object object;
        String string = "";
        AuthUser authUser = this.getAuthenticatedUserObj(rFunctionDB);
        if (authUser != null) {
            object = rFunctionDB.getThemeTags4Folder(n);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!authUser.getRwx().contains(string2)) continue;
                string = ACCESS_PRIVILEGE_RWX;
            }
            if (object.size() == 0) {
                string = ACCESS_PRIVILEGE_RWX;
            }
        }
        this.log.debug((Object)("user:" + authUser));
        object = (String)this.getRequest().getSession().getAttribute("session^logged^superuser");
        if (object != null && !((String)object).equals("")) {
            string = ACCESS_PRIVILEGE_RWX;
        }
        if (string.equals("")) {
            string = null;
        }
        return string;
    }
}

