/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import com.fe.Config;
import com.fe.ValueObject;
import com.fe.auth.AuthUser;
import com.fe.client.AbstractTeamOrgMgmt;
import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.RFunctionMgmt;
import com.fe.data.SchedulerTrigger;
import com.fe.db.BBSyncDB;
import com.fe.db.ConstructQueryDB;
import com.fe.db.InfrastructureDB;
import com.fe.db.RFunctionDB;
import com.fe.db.SchedulerDB;
import com.fe.db.SuperDB;
import com.fe.email.SendMail;
import com.fe.email.TemplateParser;
import com.fe.json.JSONArray;
import com.fe.json.JSONObject;
import com.fe.p2p.P2PService;
import com.fe.p2p.listener.IncomingMessage;
import com.fe.p2p.listener.P2PTransportMessage;
import com.fe.p2p.msg.PostMessage;
import com.fe.p2p.msg.impl.helper.SendCommand2Helper;
import com.fe.p2p.msg.scheduler.InstantPeerStatus;
import com.fe.p2p.msg.scheduler.rserve.PeerPropertiesGet;
import com.fe.p2p.msg.scheduler.rserve.PeerPropertiesSet;
import com.fe.p2p.msg.scheduler.rserve.RServeSessionQuery;
import com.fe.p2p.msg.scheduler.rserve.RServeSessionStat;
import com.fe.p2p.peer.PeerMachine;
import com.fe.p2p.peer.PeerManagerHSQL;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.ScheduledTaskField;
import com.fe.scheduler.ScheduledTaskQueue;
import com.fe.scheduler.SchedulerAlert;
import com.fe.scheduler.SchedulerEngine;
import com.fe.scheduler.SchedulerEngineUtils;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.balance.LoadBalancingQueueTimeout;
import com.fe.scheduler.group.DirectRServeExecuteRUnix;
import com.fe.scheduler.group.REngineScriptTask;
import com.fe.scheduler.pluggin.PlugginInterface;
import com.fe.scheduler.pluggin.SchedulerPlugginRegister;
import com.fe.svn.SVNSchedulerCommitInfo;
import com.fe.svn.SVNSync;
import com.fe.util.RestartTomcat;
import com.fe.util.WikiRFunctionManual;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Arrays;
import org.tmatesoft.svn.core.SVNLogEntry;

public class SchedulerMgmt
extends AbstractTeamOrgMgmt {
    private Logger log = Logger.getLogger(SchedulerMgmt.class);
    private HttpServletRequest request = null;
    private String ACTIVE_TAB_ATTRIBUTE = "$$$ActiveSchedulerTab";
    private String TAG_SHOWHIDE_ATTRIBUTE = "$$$ShowHideTags";
    private String COOKIE_SCHEDULER_ALLITEMS = "scheduler_showAll";
    private static String LOG_STATUS_RESTARTED = "re-executed";
    private static JCS lockcache = null;
    private static Semaphore logListLock = new Semaphore(1L);
    private static String CALLING_ANOTHER_SCRIPT_PATTERN = "executeSchedulerScript(";
    private static JCS cache = null;
    private static boolean TIMER_RUNNING = false;
    private static HashMap datamap = new HashMap();
    private static Pattern splitter = Pattern.compile("(\\d+|\\D+)");
    private static String SCHEDULER_ID = "scheduler_id";
    private static String LOCK_DURATION = "duration";
    private static String USER = "user";
    private static int LOCK_AUTO_RELEASE = 300;

    public SchedulerMgmt() throws Exception {
    }

    public SchedulerMgmt(HttpServletRequest httpServletRequest) throws Exception {
        super(httpServletRequest);
    }

    public void validateEditPrivilege(int n, SchedulerDB schedulerDB) throws Exception {
        String string = this.getAccessPrivilege(n, schedulerDB);
        if (string == null || string != null && string.equals("") || string != null && string.equals(ACCESS_PRIVILEGE_R) || string != null && string.equals(ACCESS_PRIVILEGE_RX)) {
            throw new Exception("Access denied to  scheduler ID (" + n + ") Contact Administrator.");
        }
    }

    public Map listScheduledItems() throws Exception {
        return this.listScheduledItems2(null);
    }

    private Vector getGroupOrder() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Vector vector;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector2 = vector = schedulerDB.getGroupOrder();
            return vector2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public boolean killServerTaskQueue() throws Exception {
        ScheduledTaskQueue.killQueueThread();
        return true;
    }

    private Map getGroupIconsAndColors() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector = schedulerDB.getActiveGroups();
            for (Map map : vector) {
                hashMap2.put(map.get("taskuid"), map.get("icon"));
                hashMap3.put(map.get("taskuid"), map.get("bar_colorcode"));
            }
            hashMap.put("group_icons", hashMap2);
            hashMap.put("group_colorcodes", hashMap3);
            HashMap hashMap4 = hashMap;
            return hashMap4;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map searchScheduledItems1(String string) throws Exception {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            List list = schedulerDB.searchScheduler(string);
            hashMap.put("scheduleditems", list);
            this.log.debug((Object)("rtn:" + hashMap));
            HashMap<String, List> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map searchScheduledItems(String string, String string2) throws Exception {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            List list = schedulerDB.searchScheduler(string, n);
            hashMap.put("scheduleditems", list);
            HashMap<String, List> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    private boolean isSchedulerShowAll() throws Exception {
        boolean bl = false;
        Cookie[] cookieArray = this.getRequest().getCookies();
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(this.COOKIE_SCHEDULER_ALLITEMS) || cookieArray[i].getValue() == null || !cookieArray[i].getValue().equalsIgnoreCase("yes")) continue;
            bl = true;
        }
        return bl;
    }

    private Map listScheduledItems2(String string) throws Exception {
        Object object;
        List<Object> list;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        List list2 = new ArrayList();
        boolean bl = true;
        List list3 = null;
        if (string == null) {
            if (bl) {
                list2 = schedulerDB.listSchedulerTaskUIDJoin();
                list3 = schedulerDB.listOfFolders(null);
            } else {
                list = new ArrayList();
                object = null;
                try {
                    object = this.getAuthenticatedUserObj(schedulerDB);
                    if (object != null) {
                        this.log.debug((Object)("user:" + object));
                        ((ArrayList)list).addAll(((AuthUser)object).getRwx());
                        ((ArrayList)list).addAll(((AuthUser)object).getRx());
                        ((ArrayList)list).addAll(((AuthUser)object).getR());
                        list2 = schedulerDB.listScheduler(list);
                        list3 = schedulerDB.listofMyFolders(list);
                    }
                }
                catch (Exception exception) {
                    this.log.error((Object)"Error while getAuthenticatedUserObj, could be wiki database issue");
                }
            }
        } else {
            list2 = schedulerDB.searchScheduler(string);
            list3 = schedulerDB.listOfFolders(null);
        }
        list = new ScheduledTaskFactory().getTasks();
        object = new LinkedHashMap();
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getGroupOrder();
        for (int i = 0; i <= vector2.size(); ++i) {
            Iterator iterator = i < vector2.size() ? (Iterator)vector2.get(i) : null;
            for (Object object2 : list) {
                if (iterator != null && (iterator == null || !iterator.equals(((ScheduledTask)object2).getUniqueid())) || vector.contains(((ScheduledTask)object2).getUniqueid()) || object2.getClass().getName().equals(REngineScriptTask.class.getName()) || object2.getClass().getName().equals(DirectRServeExecuteRUnix.class.getName())) continue;
                ((HashMap)object).put(((ScheduledTask)object2).getUniqueid(), ((ScheduledTask)object2).getName());
                vector.add(((ScheduledTask)object2).getUniqueid());
            }
        }
        TreeMap<Object, HashMap> treeMap = new TreeMap<Object, HashMap>();
        for (Object object3 : ((LinkedHashMap)object).keySet()) {
            for (String string2 : vector) {
                HashMap hashMap2;
                if (!((String)object3).substring(0, 4).equals(string2.substring(0, 4)) || ((String)object3).equals(string2)) continue;
                if (treeMap.get(object3) == null) {
                    hashMap2 = new HashMap();
                    treeMap.put(object3, hashMap2);
                } else {
                    hashMap2 = (HashMap)treeMap.get(object3);
                }
                hashMap2.put(string2, ((LinkedHashMap)object).get(string2));
            }
        }
        hashMap.putAll(this.getThemeAccessData(schedulerDB));
        schedulerDB.closeDB();
        hashMap.put("scheduleditems", list2);
        hashMap.put("folders", list3);
        hashMap.put("tasktypes", object);
        hashMap.put("taskrelation", treeMap);
        hashMap.put("isShowAll", bl);
        return hashMap;
    }

    public Map getScriptTypes() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Map map = this.listScheduledItems2(null);
            Map map2 = (Map)map.get("tasktypes");
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            LoadBalancingQueueTimeout loadBalancingQueueTimeout = new LoadBalancingQueueTimeout(schedulerDB, map2.keySet());
            Map map3 = BeanUtils.describe((Object)loadBalancingQueueTimeout);
            map3.putAll(loadBalancingQueueTimeout.getMaxWaitingAlert());
            Map map4 = this.getTags4New();
            Map map5 = (Map)map4.get("tag_follow");
            map5.put("types", map2);
            map5.put("data", map3);
            Map map6 = map5;
            return map6;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public boolean updateTimeoutSettings(Map map) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.updateTimeoutSettings(map);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public List trashedItems() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            List list;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            List list2 = list = schedulerDB.listTrashedScheduler();
            return list2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    private void updateWikiThread(final int n) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
                try {
                    schedulerDB.connectDB(BBSyncMgmt.getDBName());
                    String string = SchedulerMgmt.this.getWikiHelp(n + "");
                    SchedulerMgmt.this.log.debug((Object)("wiki taskname:" + n + " found: " + string.contains("\"noarticletext\"") + " scheduler_id:" + n));
                    if (string.contains("\"noarticletext\"")) {
                        schedulerDB.updateWikiDone(n, 0);
                    } else {
                        schedulerDB.updateWikiDone(n, 1);
                    }
                }
                catch (Exception exception) {
                    SchedulerMgmt.this.log.error((Object)"Error while updating");
                }
                finally {
                    try {
                        schedulerDB.closeDB();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - void declaration
     */
    public Map getScheduledItem(int n) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Object object;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = schedulerDB.getScheduler(n);
            this.log.debug((Object)("rscript:" + map.get("rscript")));
            String string = this.getAccessPrivilege(n, schedulerDB);
            if (string == null || string != null && string.equals("")) {
                hashMap.put("access", ACCESS_PRIVILEGE_R);
            } else {
                hashMap.put("access", string);
            }
            this.log.debug((Object)("access:" + hashMap.get("access")));
            if (string == null) {
                throw new Exception("No access to view this task");
            }
            this.updateWikiThread(n);
            Vector vector = schedulerDB.getTriggerData(n);
            hashMap.put("triggerdata", this.convertTriggerData(vector));
            try {
                hashMap.put("revisions", this.getSVNLogs(schedulerDB, n));
            }
            catch (Exception exception) {
                this.log.error((Object)("error while reading revisions, ERR:" + exception.getMessage()));
            }
            if (map != null) {
                void var10_14;
                Object object2;
                Object object3;
                object = (String)map.get("taskuid");
                ScheduledTask scheduledTask = new ScheduledTaskFactory().getTask((String)object);
                if (scheduledTask == null) {
                    throw new Exception("No engine active engine found for type " + (String)object);
                }
                this.log.debug((Object)("task:" + scheduledTask));
                for (ScheduledTaskField object42 : scheduledTask.listFormFields()) {
                    if (object42.getPluggindata() == null) continue;
                    object3 = SchedulerPlugginRegister.getPluggin(object42.getFieldtype());
                    object2 = (String)map.get(object3.getPlugginData().getFieldreference());
                    this.log.debug((Object)("field:" + object42.getFieldlabel() + " recordid:" + (String)object2 + " ref:" + object3.getPlugginData().getFieldreference() + " data:" + map));
                    if (object2 == null) continue;
                    Map map2 = object3.fetchData(Integer.parseInt((String)object2), this.getRequest());
                    map.put("pluggindata_field", object42);
                    map.put("pluggindata", object3.getPlugginData());
                    map.put("pluggindata_data", map2);
                }
                this.log.debug((Object)"pluggin processed");
                List list = this.getTaskFields((String)object);
                Object var10_13 = null;
                object3 = list.iterator();
                while (object3.hasNext()) {
                    object2 = (ScheduledTaskField)object3.next();
                    if (!((ScheduledTaskField)object2).getShortname().equalsIgnoreCase("folder_id")) continue;
                    Object object4 = object2;
                }
                this.log.debug((Object)("folder:" + var10_14));
                if (var10_14 != null) {
                    list.remove(var10_14);
                }
                hashMap.put("fields", list);
                hashMap.put("taskdata", map);
                hashMap.put("lockedby", this.getLockedBy(n, schedulerDB));
                try {
                    hashMap.put("isAuthorized", this.isAuthorizedUser(schedulerDB));
                    hashMap.put("authorizedUser", this.getAuthorizedUser(schedulerDB));
                    object3 = (String)hashMap.get("access");
                    object2 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
                    if (this.getLockedBy(n, schedulerDB) == null && object3 != null && ((String)object3).equals(ACCESS_PRIVILEGE_RWX)) {
                        this.refreshCache(n, LOCK_AUTO_RELEASE, (String)object2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.log.debug((Object)"near end");
                hashMap.put("tag_follow", this.getItemTags2(n, schedulerDB));
                this.log.debug((Object)"end");
            }
            object = hashMap;
            return object;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map getTags4New() throws Exception {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            hashMap.put("tag_follow", this.getItemTags2(0, schedulerDB));
            HashMap<String, Map> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String getScriptRev(String string, String string2, boolean bl) throws Exception {
        SVNSync sVNSync = new SVNSync();
        String string3 = null;
        string3 = bl ? sVNSync.getScript(Integer.parseInt(string), Long.parseLong(string2)) : sVNSync.diffWC(Integer.parseInt(string), Long.parseLong(string2));
        return string3;
    }

    private Vector getSVNLogs(SchedulerDB schedulerDB, int n) throws Exception {
        SVNSync sVNSync = new SVNSync();
        TreeMap<Long, Serializable> treeMap = new TreeMap<Long, Serializable>();
        Vector<SVNLogEntry> vector = sVNSync.log(n);
        List list = schedulerDB.getEditLogs(n);
        if (vector != null && vector.size() > 0 || list != null && list.size() > 0) {
            Serializable serializable;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");
            for (Map map : list) {
                serializable = new HashMap();
                ((HashMap)serializable).put("author", map.get("username"));
                ((HashMap)serializable).put("date", simpleDateFormat.format((Date)map.get("edited_datetime")));
                ((HashMap)serializable).put("message", map.get("message"));
                ((HashMap)serializable).put("scheduler_id", n);
                treeMap.put(((Date)map.get("edited_datetime")).getTime(), serializable);
            }
            if (vector != null) {
                for (SVNLogEntry sVNLogEntry : vector) {
                    serializable = new ValueObject();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("author", sVNLogEntry.getAuthor());
                    hashMap.put("date", simpleDateFormat.format(sVNLogEntry.getDate()));
                    hashMap.put("message", sVNLogEntry.getMessage());
                    hashMap.put("revision", sVNLogEntry.getRevision());
                    hashMap.put("scheduler_id", n);
                    if (sVNLogEntry.getRevision() <= 0L) continue;
                    treeMap.put(sVNLogEntry.getDate().getTime(), hashMap);
                }
            }
            Vector vector2 = new Vector(treeMap.descendingMap().values());
            return vector2;
        }
        return null;
    }

    private Vector convertTriggerData(Vector vector) {
        Vector vector2 = new Vector();
        for (Map map : vector) {
            Vector vector3 = new Vector();
            vector3.add(map.get("exp_second"));
            vector3.add(map.get("exp_minute"));
            vector3.add(map.get("exp_hour"));
            vector3.add(map.get("exp_week"));
            vector3.add(map.get("exp_day"));
            vector3.add(map.get("exp_month"));
            vector3.add(map.get("inject_code"));
            vector2.add(vector3);
        }
        return vector2;
    }

    public List getTaskFields(String string) throws Exception {
        try {
            List<ScheduledTask> list = new ScheduledTaskFactory().getTasks();
            List<ScheduledTaskField> list2 = null;
            for (ScheduledTask scheduledTask : list) {
                if (!scheduledTask.getUniqueid().equals(string)) continue;
                list2 = scheduledTask.listFormFields();
            }
            return list2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    private ScheduledTask getTask(String string) throws Exception {
        try {
            return new ScheduledTaskFactory().getTask(string);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public String move2RootGroup(int n, String string) throws Exception {
        boolean bl = false;
        try {
            String string2 = "";
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = schedulerDB.listSchedulerItem(n);
            String string3 = (String)map.get("taskuid");
            if (string3 != null && string != null && string3.equals(string)) {
                schedulerDB.updateTaskFolder(n, 0);
                string2 = "Task has been moved";
            } else if (string3 != null && string != null && !string3.equals(string) && string3.substring(0, 3).equals(string.substring(0, 3))) {
                schedulerDB.moveItemToRootOrGroup(n, string, 0);
                new ScheduledTaskFactory().refreshTaskLoaded();
                string2 = "Please note, the task has been moved to different group";
            } else {
                bl = true;
                throw new Exception("Moving allowed only within similar groups");
            }
            schedulerDB.closeDB();
            return string2;
        }
        catch (Exception exception) {
            if (!bl) {
                ClientErrorMgmt.reportError(exception, null);
            }
            throw exception;
        }
    }

    public String updateTaskFolder(int n, int n2) throws Exception {
        boolean bl = false;
        try {
            String string = "";
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string2 = schedulerDB.getFolderTaskUID(n2);
            Map map = schedulerDB.listSchedulerItem(n);
            String string3 = (String)map.get("taskuid");
            if (string3 != null && string2 != null && string3.equals(string2)) {
                int n3 = (Integer)map.get("folder_id");
                if (n3 == n2) {
                    string = "Task not moved! Source and destination folder are the same";
                } else {
                    schedulerDB.updateTaskFolder(n, n2);
                    string = "Task has been moved";
                }
            } else if (string3 != null && string2 != null && !string3.equals(string2) && string3.substring(0, 3).equals(string2.substring(0, 3))) {
                schedulerDB.moveItemToRootOrGroup(n, string2, n2);
                new ScheduledTaskFactory().refreshTaskLoaded();
                string = "Please note, the task has been moved to different group";
            } else {
                bl = true;
                throw new Exception("Moving allowed only within similar groups");
            }
            schedulerDB.closeDB();
            return string;
        }
        catch (Exception exception) {
            if (!bl) {
                ClientErrorMgmt.reportError(exception, null);
            }
            throw exception;
        }
    }

    public Map folderTasks(int n, String string) throws Exception {
        try {
            HashMap<String, List> hashMap = new HashMap<String, List>();
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            hashMap.put("tasks", schedulerDB.folderTasks(n));
            hashMap.put("folders", schedulerDB.listOfFolders(string));
            schedulerDB.closeDB();
            return hashMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map updateScheduleTask(int n, Map map, String string, boolean bl, Map map2, SchedulerTrigger[] schedulerTriggerArray, String string2, Vector vector, Vector vector2) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.log.debug((Object)" updateScheduleTask : 1");
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            if (n > 0) {
                this.validateEditPrivilege(n, schedulerDB);
            }
            this.log.debug((Object)" updateScheduleTask : 2");
            if (bl) {
                Object exception;
                boolean bl2;
                Object object3;
                Object object4;
                boolean bl3 = false;
                String string3 = (String)map.get("name");
                if (map == null || string3 != null && string3.trim().equalsIgnoreCase("")) {
                    throw new Exception("Name field is empty!!");
                }
                if (schedulerDB.isNameExisting(string3, n)) {
                    throw new Exception("Name:" + string3 + " already existing, please try different name");
                }
                if (n > 0) {
                    object4 = schedulerDB.getScheduler(n);
                    string = (String)object4.get("taskuid");
                    object3 = object4.get("folder_id") + "";
                    map.put("folder_id", object3);
                } else {
                    bl3 = true;
                }
                this.log.debug((Object)" updateScheduleTask : 3");
                if (map.get("rscript") != null && (bl2 = this.isCallingAnotherScript((String)(object4 = (String)map.get("rscript"))))) {
                    map.put("calling_another_script", "1");
                }
                object4 = new ScheduledTaskFactory().getTask(string);
                for (ScheduledTaskField object22 : ((ScheduledTask)object4).listFormFields()) {
                    int sVNSync;
                    if (object22.getPluggindata() == null) continue;
                    PlugginInterface n3 = SchedulerPlugginRegister.getPluggin(object22.getFieldtype());
                    if (n == 0) {
                        sVNSync = n3.addAction(map2, this.getRequest());
                        map.put(n3.getPlugginData().getFieldreference(), sVNSync + "");
                    } else {
                        sVNSync = n3.updateAction(n, map2, this.getRequest());
                        map.put(n3.getPlugginData().getFieldreference(), sVNSync + "");
                    }
                    map.put("plugin_txt", n3.getText(map2));
                }
                this.log.debug((Object)" updateScheduleTask : 4");
                object3 = this.getAuthenticatedUser();
                SVNSchedulerCommitInfo sVNSchedulerCommitInfo = schedulerDB.addOrUpdateScheduler(n, map, string, (String)object3, string2);
                int n2 = sVNSchedulerCommitInfo.getScheduler_id();
                this.log.debug((Object)" updateScheduleTask : 5");
                SVNSync sVNSync = new SVNSync();
                String string4 = null;
                string4 = sVNSchedulerCommitInfo.getRevision() >= 0L ? sVNSync.getLastChanged(n2) : "@@@No modification on script@@ there may be change on other than script for example trigger times, name and etc..  ";
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("task_name", string3);
                hashMap2.put("scheduler_id", n2);
                hashMap2.put("current_user", this.getAuthorizedUser(schedulerDB));
                hashMap2.put("diff", string4);
                hashMap2.put("comments", string2);
                String string5 = "scheduler_modified_alert.txt";
                this.updateAllItemTags(n2, vector, vector2, schedulerDB, schedulerDB, string3, string2, sVNSchedulerCommitInfo.getRevision(), string4, hashMap2, string5);
                this.log.debug((Object)" updateScheduleTask : 5");
                schedulerDB.setTriggerData(n2, schedulerTriggerArray);
                Map map3 = schedulerDB.getScheduler(n2);
                try {
                    exception = new SchedulerEngine();
                    ((SchedulerEngine)exception).updateJob(map3, string, schedulerDB);
                }
                catch (Exception exception2) {
                    this.log.error((Object)"Couldn't update scheduler engine as this server isn't set as load balance manager");
                }
                exception = schedulerDB.getScheduler(n2);
                Vector<Object> vector3 = new Vector<Object>();
                vector3.add(exception);
                this.log.debug((Object)" updateScheduleTask : 6");
                hashMap.put("scheduleditems", vector3);
                hashMap.put("scheduler_id", n2);
                this.log.debug((Object)" updateScheduleTask : 7");
                hashMap.putAll(this.getThemeAccessData(schedulerDB));
                HashMap<String, Object> hashMap3 = hashMap;
                return hashMap3;
            }
            ScheduledTask scheduledTask = new ScheduledTaskFactory().getTask(string);
            for (ScheduledTaskField scheduledTaskField : scheduledTask.listFormFields()) {
                if (scheduledTaskField.getPluggindata() == null) continue;
                hashMap.put("plugginfield", scheduledTaskField);
            }
            HashMap<String, Object> hashMap4 = hashMap;
            return hashMap4;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            exception.printStackTrace();
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    private boolean isCallingAnotherScript(String string) throws Exception {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n;{}");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.contains("#")) {
                string2 = string2.substring(0, string2.indexOf("#"));
            }
            if (string2.toLowerCase().contains(CALLING_ANOTHER_SCRIPT_PATTERN.toLowerCase())) {
                this.log.debug((Object)"~~~~calling executeSchedulerScript()");
                bl = true;
            }
            this.log.debug((Object)("line:" + string2 + " contains:" + string2.toLowerCase().contains(CALLING_ANOTHER_SCRIPT_PATTERN.toLowerCase())));
        }
        return bl;
    }

    public void updateCallingAnotherScript(int n, int n2) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            for (int i = n; i < n2; ++i) {
                Map map = schedulerDB.getScheduler(i);
                if (map == null || map.get("rscript") == null) continue;
                String string = (String)map.get("rscript");
                boolean bl = this.isCallingAnotherScript(string);
                schedulerDB.updateCallingAnotherScript(i, bl ? 1 : 0);
            }
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public void indexAllScheduledTasks() throws Exception {
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.indexAllSchedulerTasks();
            schedulerDB.closeDB();
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean renameFolder(String string, String string2, String string3) throws Exception {
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.renameFolder(string, string2, string3);
            new ScheduledTaskFactory().refreshTaskLoaded();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map moveTasks(String string, int n, String string2, int n2) throws Exception {
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.moveTasks(string, n, string2, n2);
            new ScheduledTaskFactory().refreshTaskLoaded();
            return this.listScheduledItems();
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean moveFolderContents(String string, String string2, String string3, String string4, String string5) throws Exception {
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            ArrayList<Integer> arrayList = schedulerDB.moveItems(string, string2, string3, string4, string5);
            SchedulerEngine schedulerEngine = new SchedulerEngine();
            for (Integer n : arrayList) {
                Map map = schedulerDB.getScheduler(n);
                try {
                    schedulerEngine.removeJob(n.intValue(), map, string2);
                    schedulerEngine.updateJob(map, string4, schedulerDB);
                }
                catch (Exception exception) {
                    this.log.error((Object)("Couldn't update scheduler task id:" + n + " when folder " + string + " moved"));
                }
            }
            new ScheduledTaskFactory().refreshTaskLoaded();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map deleteFolder(int n) throws Exception {
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.deleteFolder(n);
            new ScheduledTaskFactory().refreshTaskLoaded();
            return this.listScheduledItems();
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean addFolder(String string, String string2) throws Exception {
        try {
            HashMap hashMap = new HashMap();
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            long l = schedulerDB.addFolder(string, string2);
            new ScheduledTaskFactory().refreshTaskLoaded();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public int toggleActive(int n) throws Exception {
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            int n2 = schedulerDB.toggleActive(n);
            String string = "Task " + (n2 == 0 ? " Unpaused " : " Paused ");
            String string2 = this.getAuthenticatedUser();
            Map map = schedulerDB.getScheduler(n);
            schedulerDB.addEditLogs(n, string2, string);
            String string3 = (String)map.get("name");
            this.notifyLastModification(schedulerDB, string3, n, string, 0L);
            this.log.debug((Object)"just before update...");
            String string4 = (String)map.get("taskuid");
            new SchedulerEngine().updateJob(map, string4, schedulerDB);
            schedulerDB.closeDB();
            return n2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public String getLogMessages(int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        String string = schedulerDB.getLogMessages(n);
        schedulerDB.closeDB();
        return string;
    }

    public String getNext5Times(int n) throws Exception {
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = schedulerDB.getScheduler(n);
            Number number = (Number)map.get("active");
            if (number != null && number.intValue() == -1) {
                throw new Exception("Task is inactive and no queue for this task");
            }
            String string = (String)map.get("taskuid");
            String string2 = (String)map.get("name");
            String string3 = (String)map.get("timezone");
            TimeZone timeZone = null;
            timeZone = string3 != null && !string3.equals("") ? TimeZone.getTimeZone(string3) : TimeZone.getDefault();
            String string4 = "The followings are task execution time (" + timeZone.getID() + ") pattern:\n";
            string4 = string4 + "--------------------------------------\n";
            string4 = string4 + new SchedulerEngine().getNext5Times(string2, string, timeZone, n);
            schedulerDB.closeDB();
            return string4;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map removeTask(int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            List list = schedulerDB.getDependsThis(n);
            if (list.size() > 0) {
                throw new Exception("Deleting faild. Task Ids " + list + " depends this task");
            }
            Map map = schedulerDB.getScheduler(n);
            String string = (String)map.get("taskuid");
            new SchedulerEngine().removeJob(n, map, string);
            schedulerDB.deleteScheduler(n);
            schedulerDB.removeQueueLog(new Date().getTime(), n);
            schedulerDB.closeDB();
            Map map2 = this.listScheduledItems();
            return map2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map putBackTask(int n) throws Exception {
        try {
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.putBackScheduler(n);
            Map map = schedulerDB.getScheduler(n);
            String string = (String)map.get("taskuid");
            new SchedulerEngine().updateJob(map, string, schedulerDB);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map);
            schedulerDB.closeDB();
            hashMap.put("scheduleditems", vector);
            hashMap.put("scheduler_id", Integer.valueOf(n));
            schedulerDB.closeDB();
            return hashMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean purgeTask(int n) throws Exception {
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = schedulerDB.getScheduler(n);
            String string = (String)map.get("taskuid");
            new SchedulerEngine().removeJob(n, map, string);
            ScheduledTask scheduledTask = new ScheduledTaskFactory().getTask(string);
            for (ScheduledTaskField scheduledTaskField : scheduledTask.listFormFields()) {
                if (scheduledTaskField.getPluggindata() == null) continue;
                PlugginInterface plugginInterface = SchedulerPlugginRegister.getPluggin(scheduledTaskField.getFieldtype());
                if (n <= 0) continue;
                try {
                    plugginInterface.deleteAction(n, this.getRequest());
                }
                catch (Exception exception) {
                    this.log.error((Object)("Error:" + exception.getMessage()));
                }
            }
            schedulerDB.purgeScheduler(n);
            schedulerDB.removeQueueLog(new Date().getTime(), n);
            schedulerDB.closeDB();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Collection executeTaskNow(int n, int n2) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            this.log.debug((Object)("log_id:" + n2));
            if (n2 > 0) {
                schedulerDB.updateQueueLogStatus(n2, LOG_STATUS_RESTARTED);
            }
            Map map = schedulerDB.getScheduler(n);
            Number number = (Number)map.get("active");
            String string = (String)map.get("taskuid");
            String string2 = (String)map.get("name");
            String string3 = this.getAuthenticatedUser();
            String string4 = null;
            new SchedulerEngine().executeJobNow(string2, string, map, schedulerDB, string3, string4);
            Collection collection = this.getQueueLogs(null);
            return collection;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Collection executeTask(int n, int n2, int n3) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            this.log.debug((Object)("log_id:" + n2));
            if (n2 > 0) {
                schedulerDB.updateQueueLogStatus(n2, LOG_STATUS_RESTARTED);
            }
            Map map = schedulerDB.getScheduler(n);
            Number number = (Number)map.get("active");
            String string = (String)map.get("taskuid");
            String string2 = (String)map.get("name");
            String string3 = this.getAuthenticatedUser();
            String string4 = null;
            if (n3 > 0) {
                new SchedulerEngine().runJobDelayed(map, string, schedulerDB, n3, string3);
            } else {
                new SchedulerEngine().executeJobNow(string2, string, map, schedulerDB, string3, string4);
            }
            Collection collection = this.getQueueLogs(null);
            return collection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    private Number convertNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            Integer n = new Integer(Integer.parseInt((String)object));
            return n;
        }
        return null;
    }

    private synchronized void setTimerRunning(boolean bl) {
        TIMER_RUNNING = bl;
    }

    private static synchronized Object accessData(int n, String string) {
        Object var2_2 = null;
        if (n == 1 && string != null && datamap != null && datamap.containsKey(string)) {
            var2_2 = datamap.get(string);
        } else if (n == 2) {
            datamap.clear();
        }
        return var2_2;
    }

    private String getEnbledTaskTypes() {
        Vector vector = SchedulerEngine.getEnabledTaskTypes();
        String string = "";
        for (Object e : SchedulerEngine.getEnabledTaskTypes()) {
            string = string + (string.equals("") ? "'" + e + "'" : ",'" + e + "'");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getQueueLogs(Map map) throws Exception {
        Object object;
        String string = ConstructQueryDB.getConstructQueryDB().constructQueueHistoryQuery(map);
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        if (cache == null) {
            cache = JCS.getInstance((String)"logQueues");
        }
        IElementAttributes iElementAttributes = cache.getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds(2L);
        try {
            Object object2;
            Object object3;
            Vector vector;
            schedulerDB.setReadOnly(true);
            Date date = new Date();
            object = null;
            Map map2 = this.getExecutingTasks();
            this.log.debug((Object)("log data" + map2));
            Vector vector2 = (Vector)map2.get("queued");
            if (string == null) {
                if (cache.get((Object)"c1") == null) {
                    Object object4;
                    Object object52;
                    vector = LoadBalancingQueue.getDefault().getAllTasks();
                    object3 = null;
                    object2 = new Vector<String>();
                    for (Object object52 : vector) {
                        object4 = ((LoadBalancingQueueItem)object52).getSchedulerid() + "_" + ((LoadBalancingQueueItem)object52).getSf().getTrigger_time();
                        object3 = object3 == null ? "'" + (String)object4 + "'" : (String)object3 + ",'" + (String)object4 + "'";
                        ((Vector)object2).add(object4);
                    }
                    IElementAttributes iElementAttributes2 = cache.getDefaultElementAttributes();
                    iElementAttributes2.setMaxLifeSeconds(3L);
                    object52 = (List)cache.get((Object)"qLogsDb");
                    if (object52 == null) {
                        object = schedulerDB.listOfQueueLogs((String)object3, date.getTime());
                        if (object != null) {
                            cache.put((Object)"qLogsDb", object, iElementAttributes2);
                        }
                    } else {
                        object52.size();
                        object = object52;
                    }
                    this.log.debug((Object)("c1:" + object.size() + " all_ids:" + (vector2 != null ? vector2.size() : 0) + " qidst:" + vector.size()));
                    if (IncomingMessage.getExecutingPeersTime() != null) {
                        object4 = IncomingMessage.getExecutingPeersTime().values();
                        this.log.debug((Object)("sid_times" + object4));
                        try {
                            Object object6 = object4;
                            synchronized (object6) {
                                Iterator iterator = object4.iterator();
                                while (iterator.hasNext()) {
                                    Map map3 = (Map)iterator.next();
                                    if (map3 == null) continue;
                                    try {
                                        int n = (Integer)map3.keySet().iterator().next();
                                        long l = (Long)map3.values().iterator().next();
                                        String string2 = n + "_" + l;
                                        if (((Vector)object2).contains(string2)) continue;
                                        Map map4 = schedulerDB.listOfQueueLog(n, l);
                                        Number number = (Number)map4.get("is_triggered");
                                        if (map4 == null || number == null || number == null || number.intValue() != 1) {
                                            // empty if block
                                        }
                                        if (number == null || number.intValue() != 1) continue;
                                        LoadBalancingQueue.getDefault().removeFaultyProcessingTask(n, l);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.log.error((Object)("Error e:" + exception.getMessage()));
                        }
                    }
                    if (object != null) {
                        cache.put((Object)"c1", object, iElementAttributes);
                    }
                } else {
                    object = (List)cache.get((Object)"c1");
                }
            } else if (cache.get((Object)"c2") == null) {
                object = schedulerDB.listOfHistoryQueueLogs(date.getTime(), string);
                if (object != null) {
                    cache.put((Object)"c2", object, iElementAttributes);
                }
            } else {
                object = (List)cache.get((Object)"c2");
            }
            if (object == null) {
                vector = new ArrayList<LoadBalancingQueueItem>();
                return vector;
            }
            vector = (Vector)map2.get("queued");
            object3 = (Map)map2.get("pfnames");
            this.log.debug((Object)("execting:" + vector));
            this.populateHistoryLogs((List)object, (Map)object3, vector2, vector);
            this.log.debug((Object)("c:" + object.size()));
            object2 = object;
            return object2;
        }
        catch (SQLException sQLException) {
            this.log.error((Object)("Error:" + sQLException.getMessage()));
            object = new ArrayList();
            return object;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String getConsoleMsg(String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            String string2;
            String string3;
            int n = 0;
            long l = 0L;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            if (stringTokenizer.countTokens() >= 2) {
                try {
                    string3 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    n = Integer.parseInt(string3);
                    l = Long.parseLong(string2);
                }
                catch (Exception exception) {
                    this.log.error((Object)("error while parsing: " + string));
                }
            }
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            string2 = string3 = schedulerDB.getConsoleMsg(n, l);
            return string2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Collection getLast15Logs(int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            List list = schedulerDB.listOfLast15Logs(new Date().getTime(), n);
            this.populateHistoryLogs(list, new HashMap(), new Vector(), new Vector());
            List list2 = list;
            return list2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    private void populateHistoryLogs(List list, Map map, List list2, List list3) {
        for (Map map2 : list) {
            Date date;
            if (map2 == null) continue;
            String string = (String)map2.get("host");
            if (map != null && map.get(string) != null) {
                map2.put("host", map.get(string));
            }
            Number number = (Number)map2.get("scheduler_id");
            Number number2 = map2.get("trigger_time") instanceof String ? (Number)((Number)map2.get("trigger_time_or")) : (Number)((Number)map2.get("trigger_time"));
            String string2 = number + "_" + number2;
            if (list2.contains(string2)) {
                map2.put("queued", 1);
            } else {
                map2.put("queued", 0);
            }
            String string3 = "";
            String string4 = (String)map2.get("timezone");
            List list4 = Arrays.asList((Object[])TimeZone.getAvailableIDs());
            Object var14_14 = null;
            if (string4 != null && !string4.trim().equals("") && list4.contains(string4.trim())) {
                string3 = " " + TimeZone.getTimeZone(string4).getDisplayName(false, 0) + "";
            }
            if (list3.contains(string2)) {
                map2.put("executing", 1);
            }
            map2.put("unique_id", number + "_" + number2);
            if (number2 != null) {
                Date date2;
                date = date2 = new Date();
                date2.setTime(number2.longValue());
                map2.put("trigger_time_or", number2);
                map2.put("trigger_time", this.getFriendlyTime(date2, string4) + string3);
            }
            int n = map2.get("is_triggered") == null ? 0 : ((Number)map2.get("is_triggered")).intValue();
            date = (Timestamp)map2.get("start_time");
            Timestamp timestamp = (Timestamp)map2.get("end_time");
            if (map2.get("db_connection_ids") != null) {
                map2.remove("db_connection_ids");
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("hh:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("GMT"));
            if (date != null) {
                Date date3 = new Date();
                date3.setTime(number2.longValue());
                long l = ((Timestamp)date).getTime() - date3.getTime();
                if (l >= 1000L) {
                    map2.put("started_at", simpleDateFormat.format(new Date(l)));
                }
            }
            if (timestamp == null || date == null) continue;
            long l = timestamp.getTime() - ((Timestamp)date).getTime();
            if (l > 3600000L) {
                map2.put("duration", simpleDateFormat2.format(new Date(l)));
                continue;
            }
            map2.put("duration", simpleDateFormat.format(new Date(l)));
        }
    }

    public Vector getDataLogHistory(String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Object object;
            Object object2;
            int n = 0;
            long l = 0L;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            if (stringTokenizer.countTokens() >= 2) {
                try {
                    object2 = stringTokenizer.nextToken();
                    object = stringTokenizer.nextToken();
                    n = Integer.parseInt((String)object2);
                    l = Long.parseLong((String)object);
                }
                catch (Exception exception) {
                    this.log.error((Object)("error while parsing: " + string));
                }
            }
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            object = object2 = schedulerDB.getDataLogHistory(n, l);
            return object;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map getExecutingTasks() throws Exception {
        try {
            String string;
            if (cache == null) {
                cache = JCS.getInstance((String)"logQueues");
            }
            IElementAttributes iElementAttributes = cache.getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds(2L);
            if (cache.get((Object)"getExecutingTasks") != null) {
                Map map = (Map)cache.get((Object)"getExecutingTasks");
                map.put("servertime", new SimpleDateFormat("MMMMM dd, yyyy HH:mm:ss").format(new Date()));
                map.put("onlinepeers", this.getOnlinePeers());
                return map;
            }
            Vector<String> vector = new Vector<String>();
            TreeMap treeMap = new TreeMap();
            TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
            Collection<LoadBalancingQueueItem> collection = LoadBalancingQueue.getDefault().getExecutingTasks();
            Collection<LoadBalancingQueueItem> collection2 = LoadBalancingQueue.getDefault().getQueuedTasks();
            Vector<String> vector2 = new Vector<String>();
            for (LoadBalancingQueueItem object2 : collection) {
                string = object2.getSchedulerid() + "_" + object2.getSf().getTrigger_time();
                vector.add(string);
                vector2.add(string);
                treeMap2.put(string, object2.getMachine());
            }
            for (LoadBalancingQueueItem loadBalancingQueueItem : collection2) {
                string = loadBalancingQueueItem.getSchedulerid() + "_" + loadBalancingQueueItem.getSf().getTrigger_time();
                vector.add(string);
            }
            TreeMap treeMap3 = new TreeMap();
            treeMap3.put("servertime", new SimpleDateFormat("MMMMM dd, yyyy HH:mm:ss").format(new Date()));
            treeMap3.put("lastexecutedtime", LoadBalancingQueue.getDefault().lastExcecutedTime());
            treeMap3.put("queued", vector);
            if (!P2PService.getComputerName().equalsIgnoreCase("4ecappcsg5") || this.getRequest().getContextPath().contains("tomcat_beta")) {
                treeMap3.put("onlinepeers", this.getOnlinePeers());
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n = 10000;
            List<PeerMachine> list = new PeerManagerHSQL().getOnlinePeers(n);
            for (PeerMachine peerMachine : list) {
                if (peerMachine.getRunning().size() <= 0) continue;
                hashMap.put(peerMachine.getPeername(), peerMachine.getRunning().size());
            }
            treeMap3.put("exe_count", hashMap);
            treeMap3.put("executing", vector2);
            treeMap3.put("executingpeers", treeMap2);
            treeMap3.put("pfnames", this.getPeerFriendlyNames());
            try {
                treeMap3.put("x_completed", this.percentageCalc1(collection));
            }
            catch (Exception exception) {
                treeMap3.put("x_completed_error", exception.getMessage());
            }
            treeMap3.put("hostname", P2PService.getComputerName());
            cache.put((Object)"getExecutingTasks", (Object)treeMap3, iElementAttributes);
            return treeMap3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private Map getExecutingTasks_old() throws Exception {
        try {
            Object object;
            if (cache == null) {
                cache = JCS.getInstance((String)"logQueues");
            }
            IElementAttributes iElementAttributes = cache.getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds(2L);
            if (cache.get((Object)"getExecutingTasks") != null) {
                Map map = (Map)cache.get((Object)"getExecutingTasks");
                map.put("servertime", new SimpleDateFormat("MMMMM dd, yyyy HH:mm:ss").format(new Date()));
                map.put("onlinepeers", this.getOnlinePeers());
                return map;
            }
            Vector<String> vector = new Vector<String>();
            TreeMap treeMap = new TreeMap();
            TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
            Collection<LoadBalancingQueueItem> collection = LoadBalancingQueue.getDefault().getExecutingTasks();
            Collection<LoadBalancingQueueItem> collection2 = LoadBalancingQueue.getDefault().getQueuedTasks();
            Map<String, Map> map = IncomingMessage.getExecutingPeersTime();
            Vector<String> vector2 = new Vector<String>();
            for (LoadBalancingQueueItem object2 : collection) {
                object = object2.getSchedulerid() + "_" + object2.getSf().getTrigger_time();
                vector.add((String)object);
                vector2.add((String)object);
                treeMap2.put((String)object, object2.getMachine());
            }
            for (LoadBalancingQueueItem loadBalancingQueueItem : collection2) {
                object = loadBalancingQueueItem.getSchedulerid() + "_" + loadBalancingQueueItem.getSf().getTrigger_time();
                vector.add((String)object);
            }
            this.log.debug((Object)("queued items:" + collection2.size()));
            if (map != null) {
                try {
                    for (String string : map.keySet()) {
                        object = map.get(string);
                        if (object == null) continue;
                        for (Integer n : object.keySet()) {
                            long l = (Long)object.get(n);
                            String string2 = n + "_" + l;
                            if (vector.contains(string2)) continue;
                            vector.add(string2);
                            vector2.add(string2);
                            treeMap2.put(string2, string);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Iterator<String> iterator = new TreeMap();
            ((TreeMap)((Object)iterator)).put("servertime", new SimpleDateFormat("MMMMM dd, yyyy HH:mm:ss").format(new Date()));
            ((TreeMap)((Object)iterator)).put("lastexecutedtime", LoadBalancingQueue.getDefault().lastExcecutedTime());
            ((TreeMap)((Object)iterator)).put("queued", vector);
            if (!P2PService.getComputerName().equalsIgnoreCase("4ecappcsg5") || this.getRequest().getContextPath().contains("tomcat_beta")) {
                ((TreeMap)((Object)iterator)).put("onlinepeers", this.getOnlinePeers());
            }
            ((TreeMap)((Object)iterator)).put("executing", vector2);
            ((TreeMap)((Object)iterator)).put("executingpeers", treeMap2);
            ((TreeMap)((Object)iterator)).put("pfnames", this.getPeerFriendlyNames());
            try {
                ((TreeMap)((Object)iterator)).put("x_completed", this.percentageCalc1(collection));
            }
            catch (Exception exception) {
                ((TreeMap)((Object)iterator)).put("x_completed_error", exception.getMessage());
            }
            ((TreeMap)((Object)iterator)).put("hostname", P2PService.getComputerName());
            cache.put((Object)"getExecutingTasks", iterator, iElementAttributes);
            return iterator;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private Map percentageCalc1(Collection<LoadBalancingQueueItem> collection) throws Exception {
        long l = -1L;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string = null;
        for (LoadBalancingQueueItem loadBalancingQueueItem : collection) {
            if (loadBalancingQueueItem.getStarted() == null) continue;
            l = new Date().getTime() - loadBalancingQueueItem.getStarted().getTime();
            string = loadBalancingQueueItem.getSf().getTrigger_time() + "";
            treeMap.put(loadBalancingQueueItem.getSchedulerid() + "_" + string, l + "|" + loadBalancingQueueItem.getLastExecutedDuration());
        }
        return treeMap;
    }

    private Map percentageCalc(Vector vector, Collection<LoadBalancingQueueItem> collection) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector2 = schedulerDB.getLastSuccessfulQLogs(vector);
            for (Map map : vector2) {
                Number number = (Number)map.get("scheduler_id");
                Timestamp timestamp = (Timestamp)map.get("start_time");
                Timestamp timestamp2 = (Timestamp)map.get("end_time");
                long l = -1L;
                long l2 = timestamp2.getTime() - timestamp.getTime();
                String string = null;
                for (LoadBalancingQueueItem loadBalancingQueueItem : collection) {
                    if (loadBalancingQueueItem.getSchedulerid() != number.intValue() || loadBalancingQueueItem.getStarted() == null) continue;
                    l = new Date().getTime() - loadBalancingQueueItem.getStarted().getTime();
                    string = loadBalancingQueueItem.getSf().getTrigger_time() + "";
                }
                if (l <= 0L || l2 <= 0L) continue;
                treeMap.put(number + "_" + string, l + "|" + l2);
            }
            TreeMap<String, String> treeMap2 = treeMap;
            return treeMap2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public boolean executeScript(String string, String string2, int n, Vector vector) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            int n2 = schedulerDB.addRScript(string, string2, n);
            LoadBalancingQueue.getDefault().executeScript(vector, n2);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map getPeersAndTaskExecuting() {
        return IncomingMessage.getExecutingPeers();
    }

    public Map getPeerData(String string) throws Exception {
        try {
            if (string.equals("statistics")) {
                LoadBalancingQueue.getDefault().updatePeerData(P2PTransportMessage.COMMAND_STATISTICS);
            }
            if (string.equals("rpackages")) {
                LoadBalancingQueue.getDefault().updatePeerData(P2PTransportMessage.COMMAND_R_PACKAGES);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
            TreeMap<String, HashMap> treeMap = new TreeMap<String, HashMap>();
            Vector<String> vector = new Vector<String>();
            Map map = null;
            if (string.equals("statistics")) {
                map = IncomingMessage.getPeerStatistics();
            }
            if (string.equals("rpackages")) {
                map = IncomingMessage.getPeerRPackages();
            }
            vector.add("~~~");
            for (String string2 : map.keySet()) {
                String string3 = (String)map.get(string2);
                if (string2 == null || string3 == null || string3.equals("")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=");
                    if (stringTokenizer2.countTokens() < 2) continue;
                    String string5 = stringTokenizer2.nextToken();
                    String string6 = stringTokenizer2.nextToken();
                    HashMap hashMap2 = null;
                    if (string5.equalsIgnoreCase("PEER")) continue;
                    if (treeMap.get(string5) != null) {
                        hashMap2 = (HashMap)treeMap.get(string5);
                    } else {
                        hashMap2 = new HashMap();
                        hashMap2.put("~~~", string5);
                        treeMap.put(string5, hashMap2);
                    }
                    hashMap2.put(string2, string6);
                }
                if (vector.contains(string2)) continue;
                vector.add(string2);
            }
            hashMap.put("data", treeMap);
            hashMap.put("col", vector);
            return hashMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "what:" + string);
            throw exception;
        }
    }

    public Map getOnlinePeers() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)"onlinePeers");
        }
        IElementAttributes iElementAttributes = cache.getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds(2L);
        IElementAttributes iElementAttributes2 = cache.getDefaultElementAttributes();
        iElementAttributes2.setMaxLifeSeconds(5L);
        Map<String, String> map = new HashMap();
        if (cache.get((Object)"peers") == null) {
            String string = "NOBUSY";
            int n = 5000;
            List<PeerMachine> list = new PeerManagerHSQL().getOnlinePeers(n);
            for (PeerMachine peerMachine : list) {
                map.put(peerMachine.getPeername(), peerMachine.getBusyStatus());
            }
            map.put(P2PService.getComputerName(), string);
            this.log.debug((Object)("peers1:" + map));
            cache.put((Object)"peers", map, iElementAttributes);
            LoadBalancingQueue.getDefault().findAndUpdateOnlinePeers();
        } else {
            map = (Map)cache.get((Object)"peers");
        }
        return map;
    }

    private Map getExecutingTasksOld() throws Exception {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        Map map = ScheduledTaskQueue.getQueuedIds();
        Vector vector = (Vector)map.get("alltasks");
        String string = (String)map.get("executing");
        treeMap.put("servertime", new SimpleDateFormat("MMMMM dd, yyyy HH:mm:ss").format(new Date()));
        treeMap.put("istarted", new SchedulerEngine().isSchedulerStarted());
        treeMap.put("lastexecutedtime", ScheduledTaskQueue.lastExcecutedTime());
        treeMap.put("queued", vector);
        treeMap.put("executing", string);
        treeMap.put("hostname", SchedulerDB.getSchedulerDB().getHostName());
        return treeMap;
    }

    private String getFriendlyTime(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM, HH:mm:ss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date());
        List list = Arrays.asList((Object[])TimeZone.getAvailableIDs());
        if (string != null && !string.trim().equals("") && list.contains(string.trim())) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
            simpleDateFormat2.setTimeZone(TimeZone.getTimeZone(string));
        }
        String string2 = null;
        if (calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1)) {
            string2 = " " + simpleDateFormat2.format(date);
        }
        Calendar calendar3 = Calendar.getInstance();
        calendar3.setTime(new Date());
        calendar3.add(5, 1);
        if (calendar.get(5) == calendar3.get(5) && calendar.get(2) == calendar3.get(2) && calendar.get(1) == calendar3.get(1)) {
            string2 = "Tomorrow at " + simpleDateFormat2.format(date);
        }
        Calendar calendar4 = Calendar.getInstance();
        calendar4.setTime(new Date());
        calendar4.add(5, -1);
        if (calendar.get(5) == calendar4.get(5) && calendar.get(2) == calendar4.get(2) && calendar.get(1) == calendar4.get(1)) {
            string2 = "Yesterday at " + simpleDateFormat2.format(date);
        }
        String string3 = null;
        string3 = string2 == null ? "\n" + simpleDateFormat.format(date) : "\n" + string2;
        return string3;
    }

    public boolean setActiveTab(int n) throws Exception {
        HttpSession httpSession = this.getRequest().getSession();
        httpSession.setAttribute(this.ACTIVE_TAB_ATTRIBUTE, (Object)n);
        return true;
    }

    public int getActiveTab() throws Exception {
        HttpSession httpSession = this.getRequest().getSession();
        int n = 1;
        if (httpSession.getAttribute(this.ACTIVE_TAB_ATTRIBUTE) != null) {
            try {
                n = (Integer)httpSession.getAttribute(this.ACTIVE_TAB_ATTRIBUTE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public boolean setShowTags(int n) throws Exception {
        HttpSession httpSession = this.getRequest().getSession();
        httpSession.setMaxInactiveInterval(86400);
        httpSession.setAttribute(this.TAG_SHOWHIDE_ATTRIBUTE, (Object)n);
        return true;
    }

    private int getShowTags() throws Exception {
        HttpSession httpSession = this.getRequest().getSession();
        int n = 1;
        if (httpSession.getAttribute(this.TAG_SHOWHIDE_ATTRIBUTE) != null) {
            try {
                n = (Integer)httpSession.getAttribute(this.TAG_SHOWHIDE_ATTRIBUTE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public boolean setTaskPeerAssoc(String string, Vector vector) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.setAssociatedPeers(string, vector);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map getTaskPeerAssoc(String string) throws Exception {
        TreeMap<String, Vector> treeMap = new TreeMap<String, Vector>();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector = schedulerDB.getAssociatedPeers(string);
            Vector vector2 = schedulerDB.getPeersList();
            if (vector == null || vector != null && vector.size() < 1) {
                vector = vector2;
            }
            treeMap.put("associated", vector);
            treeMap.put("all", vector2);
            TreeMap<String, Vector> treeMap2 = treeMap;
            return treeMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getData4PeerMatrix() throws Exception {
        ArrayList<String> arrayList2;
        Vector vector;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List<ScheduledTask> list = new ScheduledTaskFactory().getTasks();
        Vector<ArrayList<String>> vector2 = new Vector<ArrayList<String>>();
        Vector vector3 = this.getGroupOrder();
        Vector<String> vector4 = new Vector<String>();
        this.log.debug((Object)("orders:" + vector3));
        for (int i = 0; i <= vector3.size(); ++i) {
            vector = i < vector3.size() ? (Vector)vector3.get(i) : null;
            for (ScheduledTask object : list) {
                this.log.debug((Object)("tsk.getUniqueuid():" + object.getUniqueid() + " item:" + vector));
                if (vector != null && (vector == null || !((Object)vector).equals(object.getUniqueid()))) continue;
                arrayList2 = new ValueObject();
                ((ValueObject)((Object)arrayList2)).setKey(object.getUniqueid());
                ((ValueObject)((Object)arrayList2)).setValue(object.getName());
                if (vector4.contains(object.getUniqueid())) continue;
                vector2.add(arrayList2);
                vector4.add(object.getUniqueid());
            }
        }
        hashMap.put("tasks", vector2);
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            vector = schedulerDB.getAllPeerAssociation();
            hashMap.put("peer_association", vector);
            TreeMap treeMap = new TreeMap();
            for (ArrayList<String> arrayList2 : vector) {
                String string = arrayList2.get("taskuid") + "_" + arrayList2.get("peername");
                treeMap.put(string, "yes");
            }
            Vector vector5 = schedulerDB.getPeersList();
            List list2 = this.sortStringWithNum(vector5);
            hashMap.put("peers", list2);
            arrayList2 = new ArrayList<String>();
            arrayList2.add("rscript4rserveunix");
            arrayList2.add("direct_script_unix");
            hashMap.put("rserve_unix_peers", schedulerDB.getPeersList4Engine(arrayList2));
            hashMap.put("peernotes", schedulerDB.getPeersData());
            int n = 10000;
            List<PeerMachine> list3 = new PeerManagerHSQL().getOnlinePeers(n);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            for (PeerMachine peerMachine : list3) {
                hashMap2.put(peerMachine.getPeername(), peerMachine.getVersion());
            }
            hashMap.put("pversion", hashMap2);
            hashMap.put("p_a", treeMap);
        }
        catch (Exception exception) {
        }
        finally {
            schedulerDB.closeDB();
        }
        return hashMap;
    }

    private List sortStringWithNum(List<String> list) {
        Object[] objectArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = list.get(i);
        }
        Arrays.sort((Object[])objectArray, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2;
                int n3;
                String string = (String)object;
                String string2 = (String)object2;
                ArrayList arrayList = this.split(string);
                ArrayList arrayList2 = this.split(string2);
                if (arrayList.size() == 0 || arrayList.size() != arrayList2.size()) {
                    return string.compareTo(string2);
                }
                String string3 = "";
                String string4 = "";
                for (n3 = 0; n3 < arrayList.size() && (string3 = (String)arrayList.get(n3)).equals(string4 = (String)arrayList2.get(n3)); ++n3) {
                }
                if (n3 == arrayList.size()) {
                    return 0;
                }
                try {
                    n2 = Integer.parseInt(string3);
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareTo(string2);
                }
                ++n3;
                while (n3 < arrayList.size()) {
                    string3 = (String)arrayList.get(n3);
                    if (!string3.equals(string4 = (String)arrayList2.get(n3))) {
                        return string.compareTo(string2);
                    }
                    ++n3;
                }
                return n2 < n ? -1 : 1;
            }

            ArrayList split(String string) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Matcher matcher = splitter.matcher(string);
                while (matcher.find()) {
                    String string2 = matcher.group(1);
                    arrayList.add(string2);
                }
                return arrayList;
            }
        });
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    private Map getPeerFriendlyNames() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)"logQueues");
        }
        Map<String, String> map = new HashMap();
        IElementAttributes iElementAttributes = cache.getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds(15L);
        if (cache.get((Object)"peernotesCache") == null) {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            try {
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                for (Map map2 : schedulerDB.getPeersData()) {
                    String string = (String)map2.get("friendlyname");
                    String string2 = (String)map2.get("peername");
                    string = string != null && !string.equals("") ? string : string2;
                    map.put(string2, string);
                }
                cache.put((Object)"peernotesCache", map, iElementAttributes);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                schedulerDB.closeDB();
            }
        } else {
            map = (Map)cache.get((Object)"peernotesCache");
        }
        return map;
    }

    public Map getPeerNotes(String string) throws Exception {
        Map map = null;
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            for (Map map2 : schedulerDB.getPeersData()) {
                if (!map2.get("peername").toString().equals(string)) continue;
                map = map2;
            }
            Iterator iterator = map;
            return iterator;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map savePeerNotes(String string, String string2, String string3, String string4) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.updatePeersNotes(string, string2, string3, string4);
            hashMap.put("peernotes", schedulerDB.getPeersData());
            HashMap<String, Vector> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map savePeerToggle(String string, int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.updatePeersToggle(string, n, this.getAuthenticatedUser());
            hashMap.put("peernotes", schedulerDB.getPeersData());
            HashMap<String, Vector> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Vector execScriptLogs() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector = schedulerDB.rScriptLast5Logs();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss");
            for (Map map : vector) {
                try {
                    Timestamp timestamp = (Timestamp)map.get("start_time");
                    Timestamp timestamp2 = (Timestamp)map.get("end_time");
                    Date date = new Date();
                    date.setTime(timestamp.getTime());
                    map.put("started", this.getFriendlyTime(date, null));
                    long l = timestamp2.getTime() - timestamp.getTime();
                    map.put("duration", simpleDateFormat.format(new Date(l)));
                }
                catch (Exception exception) {
                    this.log.error((Object)("error:" + exception.getMessage()));
                }
            }
            Vector vector2 = vector;
            return vector2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String killQueuedTask(String string) throws Exception {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            int n = 0;
            long l = 0L;
            if (stringTokenizer.countTokens() == 2) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                l = Long.parseLong(stringTokenizer.nextToken());
            }
            boolean bl = false;
            if (n > 0 && l > 0L) {
                bl = LoadBalancingQueue.getDefault().killQueuedTask(n, l);
            }
            if (bl) {
                return string;
            }
            return null;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public String removeFaultyExecutingTask(int n, long l) throws Exception {
        try {
            boolean bl = false;
            if (n > 0 && l > 0L) {
                bl = LoadBalancingQueue.getDefault().removeFaultyProcessingTask(n, l);
                Map<String, Map> map = IncomingMessage.getExecutingPeersTime();
                for (Map map2 : map.values()) {
                    if (!map2.keySet().contains(n)) continue;
                    map2.remove(n);
                }
            }
            if (bl) {
                return "Task has been removed";
            }
            return "Removing failed";
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map temp_ListEx() throws Exception {
        try {
            TreeMap<String, Collection<LoadBalancingQueueItem>> treeMap = new TreeMap<String, Collection<LoadBalancingQueueItem>>();
            Collection<LoadBalancingQueueItem> collection = LoadBalancingQueue.getDefault().getExecutingTasks();
            Collection<LoadBalancingQueueItem> collection2 = LoadBalancingQueue.getDefault().getQueuedTasks();
            treeMap.put("executing", collection);
            treeMap.put("queued", collection2);
            return treeMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public Vector temp_LoadBalanceQueue() throws Exception {
        try {
            Vector<String> vector = new Vector<String>();
            Iterator<LoadBalancingQueueItem> iterator = LoadBalancingQueue.getDefault().getQueuedTasks().iterator();
            while (iterator.hasNext()) {
                vector.add(((Object)iterator.next()).toString());
            }
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public Vector temp_LoadBalanceQueueProcessing() throws Exception {
        try {
            Vector<String> vector = new Vector<String>();
            Iterator<LoadBalancingQueueItem> iterator = LoadBalancingQueue.getDefault().getExecutingTasks().iterator();
            while (iterator.hasNext()) {
                vector.add(((Object)iterator.next()).toString());
            }
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public Map temp_QueuedTaskTimes() throws Exception {
        try {
            return IncomingMessage.getExecutingPeersTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public boolean addRemovePeerTaskuid(String string, String string2, boolean bl) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            if (bl) {
                schedulerDB.addPeerTaskuid(string, string2, this.getAuthenticatedUser());
            } else {
                schedulerDB.deletePeerTaskuid(string, string2, this.getAuthenticatedUser());
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public void setGroupOrder(Vector vector) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.setGroupOrder(vector);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Vector getExecutionLogs(int n, long l) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector = schedulerDB.getSchedulerExeLogs(n, l);
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getExecutionLogs2(int n, long l) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Serializable serializable;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector = schedulerDB.getSchedulerExeLogs(n, l);
            hashMap.put("logs", vector);
            String string = Config.getString("r_script_console_logs");
            String string2 = string + n + "_" + l;
            if (string != null && new File(string).isDirectory() && new File(string2).isFile()) {
                serializable = new StringBuilder();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                    try {
                        String string3 = null;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            ((StringBuilder)serializable).append(string3);
                            ((StringBuilder)serializable).append(System.getProperty("line.separator"));
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    this.log.error((Object)("Error in ready file. file:" + string2));
                }
                hashMap.put("console", ((StringBuilder)serializable).toString());
            }
            serializable = hashMap;
            return serializable;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String getInjectCode4Log(String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            int n = 0;
            long l = 0L;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            if (stringTokenizer.countTokens() == 2) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                l = Long.parseLong(stringTokenizer.nextToken());
            }
            Map map = schedulerDB.getQueueLog(n, l);
            String string2 = (String)map.get("executed_code");
            return string2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Vector getNext10TriggerTimings(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        SchedulerEngineUtils schedulerEngineUtils = new SchedulerEngineUtils();
        return schedulerEngineUtils.getTriggerTimes(string, string2, string3, string4, string5, string6, 20, string7);
    }

    public void restartServer() throws Exception {
        try {
            RestartTomcat.restartMainServer();
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public void restartPeer(String string) throws Exception {
    }

    public Map getItemPrivilegeNotifications(ArrayList arrayList, ArrayList arrayList2) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = this.getItemPrivilegeNotifications(arrayList, arrayList2, schedulerDB);
            return map;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map followFunction(boolean bl, int n, String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            hashMap.put("authorizedUser", new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB));
            HashMap<String, String> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map getTaskTags(int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector = schedulerDB.getTagIds4Item(n);
            Vector vector2 = schedulerDB.getTags();
            hashMap.put("tagids", vector);
            hashMap.put("tags", vector2);
            HashMap<String, Vector> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map saveTags4Task(int n, Vector vector) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap hashMap = new HashMap();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.updateTagIds4Item(n, vector, SchedulerDB.REMOVE_BEFORE_UPDATE);
            Map map = schedulerDB.getScheduler(n);
            Vector<Map> vector2 = new Vector<Map>();
            vector2.add(map);
            schedulerDB.closeDB();
            hashMap.put("scheduleditems", vector2);
            HashMap hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map updateTags4Task(int n, int n2, boolean bl) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            HashMap hashMap = new HashMap();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            if (bl) {
                schedulerDB.addTagIds4Task(n, n2);
            } else {
                schedulerDB.removeTagIds4Item(n, n2);
            }
            Map map = schedulerDB.getScheduler(n);
            Vector<Map> vector = new Vector<Map>();
            vector.add(map);
            schedulerDB.closeDB();
            hashMap.put("scheduleditems", vector);
            HashMap hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    private Vector getSVNUsers(int n) throws Exception {
        SVNSync sVNSync = new SVNSync();
        Vector<String> vector = new Vector<String>();
        Vector<SVNLogEntry> vector2 = sVNSync.log(n);
        if (vector2 != null && vector2.size() > 0) {
            for (SVNLogEntry sVNLogEntry : vector2) {
                if (vector.contains(sVNLogEntry.getAuthor())) continue;
                vector.add(sVNLogEntry.getAuthor());
            }
        }
        return vector;
    }

    public ArrayList getQueryDrDown(String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            String string2;
            AbstractList abstractList;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string != null && string.equals("tag")) {
                abstractList = schedulerDB.getTags();
                for (Map map : abstractList) {
                    string2 = (String)map.get("tagname");
                    string2 = string2.indexOf("-") >= 0 ? string2.substring(string2.indexOf("-") + 1) : string2;
                    arrayList.add(map.get("id") + "|" + string2);
                }
            }
            if (string != null && string.equals("host")) {
                abstractList = schedulerDB.getPeersData();
                for (Map map : abstractList) {
                    string2 = (String)map.get("peername");
                    String string3 = (String)map.get("friendlyname");
                    string3 = string3 == null || string3 != null && string3.trim().equals("") ? string2 : string3 + " (" + string2 + ")";
                    arrayList.add(string2 + "|" + string3);
                }
            }
            abstractList = arrayList;
            return abstractList;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String getTagMarkup() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector = schedulerDB.getTags();
            schedulerDB.closeDB();
            String string = "";
            for (Map map : vector) {
                String string2 = (String)map.get("tagname");
                string2 = string2.indexOf("-") >= 0 ? string2.substring(string2.indexOf("-") + 1) : string2;
                string = string + "<option value='" + map.get("id") + "'>" + string2 + "</option>";
            }
            String string3 = string;
            return string3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String getXHRDataScheduler() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            String string;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            JSONArray jSONArray = new JSONArray();
            if (this.getRequest().getParameter("term") != null && this.getRequest().getParameter("term") != null) {
                string = this.getRequest().getParameter("term");
                List list = schedulerDB.getAutoCompleteXHR(string);
                for (Map map : list) {
                    jSONArray.put(map);
                }
            }
            string = jSONArray.toString();
            return string;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public String getXHRDataR() throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        try {
            String string;
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            JSONArray jSONArray = new JSONArray();
            if (this.getRequest().getParameter("term") != null && this.getRequest().getParameter("term") != null) {
                string = this.getRequest().getParameter("term");
                List list = rFunctionDB.autoCompleteFunctions(string);
                for (Map map : list) {
                    jSONArray.put(map);
                }
            }
            string = jSONArray.toString();
            return string;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public String getNotificationData() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        InfrastructureDB infrastructureDB = InfrastructureDB.getInfrastructureDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            infrastructureDB.connectDB(Config.getString("db_infrastructure_name"));
            List<String> list = infrastructureDB.getThemeByUsernameAccess(this.getAuthenticatedUser());
            List list2 = schedulerDB.getFailedLast2Days(list);
            for (Map map : list2) {
                jSONArray.put(map);
            }
            jSONObject.put("failed_scripts", jSONArray);
            String string = jSONObject.toString();
            return string;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
            infrastructureDB.closeDB();
        }
    }

    private String getParent(String string) throws Exception {
        String string2 = null;
        if (string.indexOf("/") >= 0) {
            string2 = string.substring(0, string.lastIndexOf("/"));
        }
        return string2;
    }

    public boolean repairFolders() throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            String string;
            String string2;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            List list = schedulerDB.listOfFolders(null);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Map object2 : list) {
                arrayList.add(object2.get("taskuid") + ":" + object2.get("folder_name"));
            }
            for (String string3 : arrayList) {
                if (string3.indexOf("/") < 0 || arrayList.contains(string2 = this.getParent(string3)) || arrayList2.contains(string2)) continue;
                arrayList2.add(string2);
            }
            ArrayList arrayList3 = new ArrayList();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                string = string2 = (String)iterator.next();
                while (this.getParent(string) != null) {
                    if (arrayList.contains(string = this.getParent(string)) || arrayList2.contains(string)) continue;
                    arrayList3.add(string);
                }
            }
            arrayList3.addAll(arrayList2);
            this.log.debug((Object)("all missing folders:" + arrayList3));
            Iterator iterator2 = arrayList3.iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                string = string2.substring(0, string2.indexOf(":"));
                String string4 = string2.substring(string2.indexOf(":") + 1);
                try {
                    schedulerDB.addFolder(string, string4);
                    this.log.debug((Object)("adding folder:" + string4 + " on " + string));
                }
                catch (Exception exception) {
                    this.log.error((Object)("error:" + exception.getMessage() + " taskuid:" + string + " folder:" + string4));
                }
            }
            schedulerDB.fixSchBrokenFolders();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public void temp_killScriptQueue() throws Exception {
    }

    public Map temp_QueueDDDDDDDetail(String string) throws Exception {
        InstantPeerStatus instantPeerStatus = new InstantPeerStatus();
        return instantPeerStatus.getStatus(string);
    }

    private static JCS getLockCache() throws Exception {
        if (lockcache == null) {
            lockcache = JCS.getInstance((String)"lock-cache");
        }
        return lockcache;
    }

    private void refreshCache(int n, long l, String string) throws Exception {
        String string2 = string + n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(SCHEDULER_ID, n);
        hashMap.put(LOCK_DURATION, l);
        hashMap.put(USER, string);
        IElementAttributes iElementAttributes = SchedulerMgmt.getLockCache().getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds(l);
        if (SchedulerMgmt.getLockCache().get((Object)string2) != null) {
            SchedulerMgmt.getLockCache().remove((Object)string2);
        }
        SchedulerMgmt.getLockCache().put((Object)string2, hashMap, iElementAttributes);
    }

    private void removeLockFromCache(int n, String string) throws Exception {
        String string2 = string + n;
        if (SchedulerMgmt.getLockCache().get((Object)string2) != null) {
            SchedulerMgmt.getLockCache().remove((Object)string2);
        }
    }

    public boolean unLockTask(int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            this.removeLockFromCache(n, string);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public boolean editorActiveDetected(int[] nArray) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            int n;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
            for (n = 0; n < nArray.length; ++n) {
                Map map;
                int n2;
                String string2 = string + nArray[n];
                if (!string2.startsWith(string) || (n2 = ((Integer)(map = (Map)SchedulerMgmt.getLockCache().get((Object)string2)).get(SCHEDULER_ID)).intValue()) != nArray[n]) continue;
                this.refreshCache(n2, LOCK_AUTO_RELEASE, string);
            }
            n = 1;
            return n != 0;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public boolean updateAlertType(String string, int n) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            this.validateEditPrivilege(n, schedulerDB);
            Map map = schedulerDB.getScheduler(n);
            String string2 = (String)map.get("alert_type");
            if (!string.equals(string2)) {
                String string3 = "Task alert type changed from  " + (string2 == null || string2 != null && string2.equals("") ? " none " : string2) + " to " + (string == null || string != null && string.equals("") ? " none " : string);
                String string4 = this.getAuthenticatedUser();
                schedulerDB.addEditLogs(n, string4, string3);
                String string5 = (String)map.get("name");
                this.notifyLastModification(schedulerDB, string5, n, string3, 0L);
            }
            boolean bl = schedulerDB.updateAlertType(string, n);
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public Map temp_getLockedBys() throws Exception {
        HashMap hashMap = SchedulerMgmt.getLockCache().getMatching("^[A-Za-z0-9]+$");
        return hashMap;
    }

    private String getLockedBy(int n, SchedulerDB schedulerDB) throws Exception {
        Object object = null;
        HashMap hashMap = SchedulerMgmt.getLockCache().getMatching("^[A-Za-z0-9]+$");
        if (hashMap != null) {
            for (String string : hashMap.keySet()) {
                Map map = (Map)hashMap.get(string);
                try {
                    if (map == null) continue;
                    int n2 = (Integer)map.get(SCHEDULER_ID);
                    long l = (Long)map.get(LOCK_DURATION);
                    String string2 = (String)map.get(USER);
                    if (n2 != n) continue;
                    object = string2;
                }
                catch (Exception exception) {}
            }
        }
        Iterator iterator = object;
        return iterator;
    }

    private void notifyLastModification(SchedulerDB schedulerDB, String string, int n, String string2, long l) throws Exception {
        String string3;
        SVNSync sVNSync = new SVNSync();
        String string4 = null;
        string4 = l >= 0L ? sVNSync.getLastChanged(n) : "@@@No modification on script@@ there may be change on other than script for example trigger times, name and etc..  ";
        String string5 = new SchedulerMgmt(this.getRequest()).getAuthorizedUser(schedulerDB);
        ArrayList arrayList = schedulerDB.getFollowTags4Item(n);
        String string6 = string5 + "@4ecap.com";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("task_name", string);
        hashMap.put("scheduler_id", n);
        hashMap.put("current_user", string5);
        hashMap.put("diff", string4);
        hashMap.put("comments", string2);
        String string7 = "";
        InputStream inputStream = SendMail.class.getResourceAsStream("scheduler_modified_alert.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string3 = bufferedReader.readLine()) != null) {
            string7 = string7 + (string7.equals("") ? string3 : "\n" + string3);
        }
        bufferedReader.close();
        inputStream.close();
        TemplateParser templateParser = new TemplateParser(string7, hashMap);
        String string8 = templateParser.parseTemplate();
        String string9 = templateParser.getSubject();
        try {
            SchedulerAlert.alert(arrayList, "email", string9, string8, null, string6);
        }
        catch (Exception exception) {
            this.log.error((Object)("Couldn't send scheduler update notification to themes " + arrayList + " the followings are error:"));
            exception.printStackTrace();
        }
    }

    public String commandStopStartPeer(String string, String string2) throws Exception {
        try {
            String string3 = "cmd.exe /c sc " + string2 + " 4EPeer";
            String string4 = SendCommand2Helper.sendCommand(string, string3);
            return string4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public Map command2Peer(String string, String string2) throws Exception {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string3 = SendCommand2Helper.sendCommand(string, string2);
            hashMap.put("peer", string);
            hashMap.put("response", string3);
            return hashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public Map command2PeerWithWait(String string, String string2, int n) throws Exception {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string3 = SendCommand2Helper.sendCommand(string, string2, n);
            hashMap.put("peer", string);
            hashMap.put("response", string3);
            return hashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public List getRserveSessionDetails(String string) throws Exception {
        ArrayList arrayList = new ArrayList();
        RServeSessionStat rServeSessionStat = new RServeSessionStat();
        new PostMessage(rServeSessionStat, string).send();
        Map map = RServeSessionStat.getPeerCachedStat(string);
        if (map != null) {
            for (String string2 : map.values()) {
                JSONObject jSONObject = new JSONObject(string2);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    hashMap.put(string3, jSONObject.get(string3));
                }
                arrayList.add(hashMap);
            }
        }
        this.log.debug((Object)("data:" + arrayList));
        return arrayList;
    }

    public boolean killRserveProcess(String string, int n) throws Exception {
        RServeSessionQuery rServeSessionQuery = new RServeSessionQuery();
        rServeSessionQuery.setKill_process(n);
        new PostMessage(rServeSessionQuery, string).send();
        return true;
    }

    public boolean getPeerProperties(String string, int n) throws Exception {
        RServeSessionQuery rServeSessionQuery = new RServeSessionQuery();
        rServeSessionQuery.setKill_process(n);
        new PostMessage(rServeSessionQuery, string).send();
        return true;
    }

    public Map getPeerSpecificStat(String string) throws Exception {
        PeerPropertiesGet peerPropertiesGet = new PeerPropertiesGet();
        new PostMessage(peerPropertiesGet, string).send();
        Thread.sleep(1500L);
        boolean bl = true;
        Map map = null;
        for (int i = 0; i < 100 && bl; ++i) {
            map = PeerPropertiesGet.getPeerCachedProp(string);
            if (map != null) {
                bl = false;
            }
            Thread.sleep(50L);
        }
        return map;
    }

    public boolean setPeerSpecificStat(String string, int n, int n2) throws Exception {
        PeerPropertiesSet peerPropertiesSet = new PeerPropertiesSet();
        peerPropertiesSet.setPeerConcurrentThread(n + "");
        peerPropertiesSet.setPeerSessionExecutionMax(n2 + "");
        new PostMessage(peerPropertiesSet, string).send();
        return true;
    }

    public String getWikiHelp(String string) throws Exception {
        String string2 = "SchedulerScript:" + string.replaceAll(" ", "_");
        this.log.debug((Object)("wiki pagename:" + string2));
        WikiRFunctionManual wikiRFunctionManual = new WikiRFunctionManual();
        String string3 = wikiRFunctionManual.getWikiHTML(string2);
        return string3;
    }

    public void updateSyncSVN(int n, int n2) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        String string = this.getAuthenticatedUser();
        if (string == null) {
            throw new Exception("Please login first");
        }
        try {
            String string2 = Config.getString("svn_user");
            String string3 = Config.getString("svn_pwd");
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            for (int i = n; i <= n2; ++i) {
                String string4;
                Map map;
                SVNSync sVNSync;
                int n3 = i;
                Map map2 = schedulerDB.getSVNUser4WikiUser(string);
                if (map2 != null && map2.get("svn_username") != null && map2.get("svn_password") != null) {
                    string2 = (String)map2.get("svn_username");
                    string3 = (String)map2.get("svn_password");
                }
                if ((sVNSync = new SVNSync(string2, string3)).log(n3) != null || (map = schedulerDB.getScheduler(n3)) == null || (string4 = (String)map.get("rscript")) == null || string4.trim().equals("")) continue;
                long l = sVNSync.syncScript(n3, string4, "Sychrnoized by system");
                System.out.println("SchedulerMgmt.updateSyncSVN(): scheduler_id:" + n3 + " ");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public List getPeerAssHist4Peer(String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            List list = schedulerDB.getLast50PeerActHistory(string);
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    public List getPeerAssHist4Task(String string) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            List list = schedulerDB.getLast50TaskActHistory(string);
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    protected String getPeerIPAddress() throws Exception {
        String string = (String)this.getRequest().getSession().getAttribute(REMOTE_IP);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Map loadInit(int n) throws Exception {
        try {
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List<ScheduledTask> list = new ScheduledTaskFactory().getTasks();
            Vector<ValueObject> vector2 = new Vector<ValueObject>();
            Vector vector3 = this.getGroupOrder();
            for (ScheduledTask vector4 : list) {
                object = new ValueObject();
                ((ValueObject)object).setKey(vector4.getUniqueid());
                ((ValueObject)object).setValue(vector4.getName());
                vector2.add((ValueObject)object);
            }
            String string = Config.getString("bloomberg_synchronization");
            Object var7_9 = null;
            if (string != null & string.equalsIgnoreCase("no")) {
                Vector vector = new Vector();
            } else {
                Vector vector = SchedulerEngine.getEnabledTaskTypes();
            }
            if (n == -1) {
                n = this.getActiveTab();
            }
            hashMap.put("activetab", n);
            if (n == 0) {
                void var7_12;
                hashMap.put("tasktypes", vector2);
                hashMap.put("timezones", TimeZone.getAvailableIDs());
                object = this.listScheduledItems();
                object.put("taskrunning", var7_12);
                hashMap.put("listtasks", object);
                BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
                bBSyncDB.connectDB(BBSyncMgmt.getDBName());
                Vector vector = bBSyncDB.getFieldMapping();
                bBSyncDB.closeDB();
                hashMap.put("field_mapping", vector);
                SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                Vector vector4 = schedulerDB.getTags();
                schedulerDB.closeDB();
                hashMap.put("tags", vector4);
                hashMap.put("showtags", this.getShowTags());
            }
            if (n == 1) {
                hashMap.put("qlogs", this.getQueueLogs(null));
                object = SchedulerDB.getSchedulerDB();
                try {
                    ((SuperDB)object).connectDB(BBSyncMgmt.getDBName());
                    hashMap.put("peerslist", ((SchedulerDB)object).getPeersData());
                }
                catch (Exception exception) {
                    this.log.error((Object)("Error:" + exception.getMessage()));
                }
                finally {
                    ((SuperDB)object).closeDB();
                }
            }
            if (n == 2) {
                hashMap.put("peersdata", this.getData4PeerMatrix());
            }
            hashMap.putAll(this.getGroupIconsAndColors());
            return hashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }
}

