/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.client.AdminMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.db.ConstructQueryDB;
import com.fe.db.SuperDB;
import com.fe.db.TradeDB;
import com.fe.util.InputStringTokenParser;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.directwebremoting.WebContextFactory;

public class TradingMgmt {
    private String dbname = Config.getString("db_trading_name");
    private HttpServletRequest request = null;
    private Logger log = Logger.getLogger(TradingMgmt.class);

    public TradingMgmt(HttpServletRequest httpServletRequest) throws Exception {
        this.request = httpServletRequest;
        String string = (String)this.getRequest().getSession().getAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE);
        if (string == null || !string.equalsIgnoreCase("true")) {
            throw new Exception("You're not authorized to use this functionalities");
        }
    }

    public TradingMgmt() throws Exception {
        String string = (String)this.getRequest().getSession().getAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE);
        if (string == null || !string.equalsIgnoreCase("true")) {
            throw new Exception("You're not authorized to use this functionalities");
        }
    }

    public List listAllCommodities() throws Exception {
        try {
            TradeDB tradeDB = TradeDB.getTradeDB();
            tradeDB.connectDB(this.dbname);
            List list = tradeDB.getAllCommodities(tradeDB.connection());
            tradeDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            try {
                TradeDB tradeDB = TradeDB.getTradeDB();
                tradeDB.connectDB(this.dbname);
                tradeDB.createTable(tradeDB.connection());
                tradeDB.closeDB();
                ClientErrorMgmt.reportError(new Exception("tblTrading table doesn't exist"), " Trading table created");
            }
            catch (Exception exception2) {
                ClientErrorMgmt.reportError(exception, null);
                throw exception;
            }
            throw exception;
        }
    }

    public Map loadFirst() throws Exception {
        try {
            List list = this.listAllCommodities();
            TradeDB tradeDB = TradeDB.getTradeDB();
            tradeDB.connectDB(this.dbname);
            List list2 = tradeDB.getAllUniqueAccounts(tradeDB.connection());
            tradeDB.closeDB();
            TreeMap<String, List> treeMap = new TreeMap<String, List>();
            treeMap.put("commodities", list);
            treeMap.put("accounts", list2);
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public String generateSQLXLQuery(String string, String string2, Vector vector, String string3, boolean bl) {
        Vector vector2 = new InputStringTokenParser(string2).parseFreeTextTokensLowerCase();
        TradeDB tradeDB = TradeDB.getTradeDB();
        if (!bl) {
            Vector vector3 = new InputStringTokenParser(string3).parseFreeTextTokensLowerCase();
            vector.addAll(vector3);
        }
        return tradeDB.generateSQLXLQuery(string, vector2, vector, bl);
    }

    public String generateSQLXLQueryByMap(Map map, String string, Vector vector, String string2, boolean bl) throws Exception {
        String string3 = ConstructQueryDB.getConstructQueryDB().constructDateInputQuery(map);
        return this.generateSQLXLQuery(string3, string, vector, string2, bl);
    }

    public String generateOpenPositionQuery(String string, String string2, Vector vector, String string3, boolean bl, String string4, String string5) throws Exception {
        Object object;
        Vector vector2 = new InputStringTokenParser(string2).parseFreeTextTokensLowerCase();
        if (!bl) {
            object = new InputStringTokenParser(string3).parseFreeTextTokensLowerCase();
            vector.addAll(object);
        }
        object = TradeDB.getTradeDB();
        ((SuperDB)object).connectDB(this.dbname);
        String string6 = ((TradeDB)object).getUniqueContractsWhereCondQuery(string, vector2, vector, bl, string4, string5);
        List list = ((TradeDB)object).getUniqueContracts(((SuperDB)object).connection(), string6);
        String string7 = ((TradeDB)object).generateOpenPositionQuery(list, string4, string5, string6);
        ((SuperDB)object).closeDB();
        return string7;
    }

    public String generateOpenPositionQueryByMap(Map map, String string, Vector vector, String string2, boolean bl, String string3, String string4) throws Exception {
        String string5 = ConstructQueryDB.getConstructQueryDB().constructDateInputQuery(map);
        return this.generateOpenPositionQuery(string5, string, vector, string2, bl, string3, string4);
    }

    private HttpServletRequest getRequest() throws Exception {
        return this.request == null && WebContextFactory.get() != null ? WebContextFactory.get().getHttpServletRequest() : this.request;
    }
}

