/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db.mariadb;

import com.fe.db.IExecDB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.dbutils.BasicRowProcessor;

public class IExecDBMariaDB
extends IExecDB {
    @Override
    public List listGroups() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select * from ie_group ORDER BY disp_order");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public void setGroupOrder(Vector vector) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE ie_group SET disp_order=? WHERE group_uid=?");
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            preparedStatement.setInt(1, n++);
            preparedStatement.setString(2, (String)iterator.next());
            preparedStatement.executeUpdate();
        }
    }

    @Override
    public List listFolders() throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("Select * FROM ie_folder ORDER BY folder_name");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public String getFolderName(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select folder_name  FROM  ie_folder  WHERE id=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string = null;
        while (resultSet.next()) {
            string = resultSet.getString(1);
        }
        return string;
    }

    @Override
    public void renameStrategy(int n, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE ie_strategy SET strategy_name=?,file_name=? WHERE id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setInt(3, n);
        preparedStatement.executeUpdate();
    }

    @Override
    public void renameParentStrategy(int n, String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE ie_strategy SET strategy_name=?,file_name=? WHERE id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setInt(3, n);
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("UPDATE ie_strategy SET parent_strategy=? WHERE parent_strategy=?");
        preparedStatement2.setString(1, string);
        preparedStatement2.setString(2, string3);
        preparedStatement2.executeUpdate();
    }

    @Override
    public void moveFolder(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE ie_folder SET group_uid = ? WHERE  id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateStrategyFolder(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE ie_strategy SET folder_id=? WHERE id=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public List listStrategies() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select a.*,b.folder_name  FROM  ie_strategy as a left outer join ie_folder as b on a.folder_id=b.id order by a.parent_strategy, a.strategy_name");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public Map getStrategy(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select a.*,b.folder_name FROM  ie_strategy as a left outer join ie_folder as b on a.folder_id=b.id WHERE  a.id=? ORDER BY a.strategy_name ");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map map = null;
        if (resultSet.next()) {
            map = new BasicRowProcessor().toMap(resultSet);
        }
        return map;
    }

    @Override
    public Vector getUniqueContracts(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select DISTINCT contract FROM ie_parameter WHERE strategy_name=? ");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString("contract"));
        }
        return vector;
    }

    @Override
    public void addParameters(ArrayList<Map> arrayList, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM ie_parameter WHERE strategy_name=?");
        preparedStatement.setString(1, string);
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO ie_parameter(strategy_name,contract,placeholder,value) VALUES(?,?,?,?)");
        for (Map map : arrayList) {
            preparedStatement2.setString(1, (String)map.get("strategy_name"));
            preparedStatement2.setString(2, (String)map.get("contract"));
            preparedStatement2.setString(3, (String)map.get("placeholder"));
            preparedStatement2.setString(4, (String)map.get("value"));
            preparedStatement2.executeUpdate();
        }
    }

    @Override
    public void removeContract(String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM ie_parameter WHERE strategy_name=? AND contract=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
    }

    @Override
    public Map getParameterValues(String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select placeholder,value FROM ie_parameter WHERE strategy_name=? AND contract=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (resultSet.next()) {
            hashMap.put(resultSet.getString("placeholder"), resultSet.getString("value"));
        }
        resultSet.close();
        preparedStatement.close();
        return hashMap;
    }

    @Override
    public Map getStrategy(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select *  FROM  ie_strategy WHERE  strategy_name=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map map = null;
        if (resultSet.next()) {
            map = new BasicRowProcessor().toMap(resultSet);
        }
        return map;
    }

    @Override
    public Vector getStrategies(Vector vector) throws Exception {
        String string = "''";
        Object object = vector.iterator();
        while (object.hasNext()) {
            string = string + ",'" + object.next() + "'";
        }
        object = this.connection().prepareStatement("Select *  FROM  ie_strategy WHERE strategy_name IN (" + string + ") ORDER BY strategy_name ");
        ResultSet resultSet = object.executeQuery();
        Vector<Map> vector2 = new Vector<Map>();
        while (resultSet.next()) {
            vector2.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector2;
    }

    @Override
    public int createStrategy(int n, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO ie_strategy(folder_id,strategy_name,file_name) VALUES(?,?,?)", 1);
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.executeUpdate();
        int n2 = 0;
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        if (resultSet.next()) {
            n2 = resultSet.getInt(1);
        }
        preparedStatement.close();
        return n2;
    }

    @Override
    public int createChildStrategy(String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO ie_strategy(parent_strategy,strategy_name) VALUES(?,?)", 1);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        int n = 0;
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        preparedStatement.close();
        return n;
    }

    @Override
    public int getFolderID(String string) throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("Select * FROM ie_folder WHERE folder_name=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        if (resultSet.next()) {
            n = resultSet.getInt("id");
        }
        return n;
    }

    @Override
    public int createFolder(String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO ie_folder(folder_name,group_uid) VALUES(?,?)", 1);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        int n = 0;
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        preparedStatement.close();
        return n;
    }

    @Override
    public List listOfFolders(String string) throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("Select * FROM ie_folder WHERE group_uid=?  ORDER BY folder_name");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public Vector getContractTree(String string, String string2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT contract,commodity as commodity FROM " + string + ".tblContractAllocation  WHERE commodity in (SELECT commodity from " + string2 + ".commodityRef) ");
        stringBuffer.append("AND date= ");
        stringBuffer.append("CASE DAYOFWEEK(SUBDATE(CURRENT_DATE, 1)) ");
        stringBuffer.append("  WHEN 1 THEN SUBDATE(CURRENT_DATE, 3) ");
        stringBuffer.append("  WHEN 7 THEN SUBDATE(CURRENT_DATE, 2) ");
        stringBuffer.append("  ELSE SUBDATE(CURRENT_DATE, 1) ");
        stringBuffer.append("END ");
        stringBuffer.append("ORDER BY commodity, year ASC, month ASC ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public Vector<String> getCommodityTree(String string) throws Exception {
        String string2 = "SELECT commodity from " + string + ".commodityRef ORDER BY orderNo";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString("commodity"));
        }
        return vector;
    }

    @Override
    public boolean isParent(String string) throws Exception {
        boolean bl = false;
        String string2 = "select * from ie_strategy where parent_strategy=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        return bl;
    }
}

