/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db.mysql;

import com.fe.data.GMapMarkerBean;
import com.fe.db.WeatherNewDB;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.log4j.Logger;

public class WeatherNewDBMySql
extends WeatherNewDB {
    private Logger log = Logger.getLogger(WeatherNewDBMySql.class);

    @Override
    public Vector getNodes(Connection connection, String string, String string2) throws Exception {
        String string3 = "SELECT replace(table_name,'_" + string2 + "','') FROM information_schema.tables WHERE table_schema = database() ";
        string3 = string3 + " and table_name REGEXP '_" + string2 + "$' \tand table_name LIKE '" + string + "%'";
        this.log.debug((Object)("query:" + string3));
        return this.singleColumnValues(connection, string3);
    }

    @Override
    public Vector getColumnNames(Connection connection, String string, String string2) throws Exception {
        String string3 = "select column_name from information_schema.columns WHERE TABLE_NAME='" + string + "_" + string2 + "'";
        string3 = string3 + " and table_schema = database() ";
        this.log.debug((Object)("query:" + string3));
        Vector<String> vector = new Vector<String>();
        vector.add("id");
        vector.add("report_date");
        vector.add("forecast_date");
        Vector vector2 = this.singleColumnValues(connection, string3);
        vector2.removeAll(vector);
        return vector2;
    }

    private Vector singleColumnValues(Connection connection, String string) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public Vector getData(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        String string5 = "Select * from " + string + "_" + string4 + " WHERE report_date BETWEEN ? AND ? order by report_date DESC";
        this.log.debug((Object)("query:" + string5));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date date = simpleDateFormat.parse(string2);
        Date date2 = simpleDateFormat.parse(string3);
        PreparedStatement preparedStatement = connection.prepareStatement(string5);
        preparedStatement.setDate(1, new java.sql.Date(date.getTime()));
        preparedStatement.setDate(2, new java.sql.Date(date2.getTime()));
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            Map map = new BasicRowProcessor().toMap(resultSet);
            Date date3 = (Date)map.get("report_date");
            if (date3 != null) {
                map.put("report_date", simpleDateFormat.format(date3));
            }
            vector.add(map);
        }
        return vector;
    }

    @Override
    public Vector getStData(Connection connection, int n, int n2, String string, Date date) throws Exception {
        String string2 = "SELECT timestep,c" + n + " as da from " + string + " WHERE longitude=" + n2 + " AND report_date=?";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setDate(1, new java.sql.Date(date.getTime()));
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            Map map = new BasicRowProcessor().toMap(resultSet);
            vector.add(map);
        }
        return vector;
    }

    @Override
    public Vector getGMapData(Connection connection, String string, String string2, double d, double d2, Date date, String string3, Vector vector) throws Exception {
        String string4 = "SELECT " + string + " from " + string2 + " WHERE longitude between " + d + " AND " + d2 + " AND report_date=? AND timestep=?";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        PreparedStatement preparedStatement = connection.prepareStatement(string4);
        preparedStatement.setDate(1, new java.sql.Date(date.getTime()));
        preparedStatement.setString(2, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<GMapMarkerBean> vector2 = new Vector<GMapMarkerBean>();
        while (resultSet.next()) {
            int n = resultSet.getInt("longitude");
            Iterator iterator = vector.iterator();
            for (int i = 0; iterator.hasNext() && i < 20000; ++i) {
                Integer n2 = (Integer)iterator.next();
                int n3 = resultSet.getInt("c" + n2);
                GMapMarkerBean gMapMarkerBean = new GMapMarkerBean();
                gMapMarkerBean.setData(n3);
                gMapMarkerBean.setLat(this.getLatitude(n2));
                gMapMarkerBean.setLng(this.getLongitude(n));
                gMapMarkerBean.setLatcol(n2);
                gMapMarkerBean.setLngrow(n);
                if (vector2.contains(gMapMarkerBean)) continue;
                vector2.add(gMapMarkerBean);
            }
        }
        return vector2;
    }

    private double getLatitude(int n) {
        return (n - 181) / 2;
    }

    private double getLongitude(int n) {
        if (n <= 361) {
            return (n - 1) / 2;
        }
        return (n - 721) / 2;
    }

    @Override
    public void saveLastGMap(Connection connection, int n, double d, double d2) throws Exception {
        connection.createStatement().executeUpdate("delete from  gMap");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO gMap(last_latitude,last_longitude,last_zoomlevel) values(?,?,?)");
        preparedStatement.setDouble(1, d);
        preparedStatement.setDouble(2, d2);
        preparedStatement.setInt(3, n);
        preparedStatement.executeUpdate();
    }

    @Override
    public Map getLastGMap(Connection connection) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select * from gMap");
        ResultSet resultSet = preparedStatement.executeQuery();
        Map map = null;
        if (resultSet.next()) {
            map = new BasicRowProcessor().toMap(resultSet);
        }
        return map;
    }
}

