/*
 * Decompiled with CFR 0.152.
 */
package com.fe.io.msg;

import com.fe.client.ClientErrorMgmt;
import com.fe.io.msg.PeerScriptFinished;
import com.fe.io.request.IOPeerRequest;
import com.fe.io.request.IOServerRequest;
import com.fe.json.JSONArray;
import com.fe.p2p.P2PService;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.StackFrameCallBack;
import com.fe.scheduler.exception.SchedulerException;
import com.fe.scheduler.queue.QueueStackManager;
import com.fe.scheduler.rscript.RScript;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RVector;

public class ServerExecuteScript
extends IOServerRequest {
    private Logger log = Logger.getLogger(ServerExecuteScript.class);
    private String script_uid;
    private String script;
    private String taskuid;
    private String queue_uid;

    public String getTaskuid() {
        return this.taskuid;
    }

    public String getQueue_uid() {
        return this.queue_uid;
    }

    public void setTaskuid(String string) {
        this.taskuid = string;
    }

    public void setQueue_uid(String string) {
        this.queue_uid = string;
    }

    public String getScript() {
        return this.script;
    }

    public String getScript_uid() {
        return this.script_uid;
    }

    public void setScript_uid(String string) {
        this.script_uid = string;
    }

    public void setScript(String string) {
        this.script = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAtPeer() {
        String string = P2PService.getComputerName();
        try {
            QueueStackManager.setStackBusy(string, this.queue_uid);
            ScheduledTask scheduledTask = new ScheduledTaskFactory().getTaskFromAll(this.getTaskuid());
            StackFrame stackFrame = new StackFrame(scheduledTask, null);
            RScript rScript = new RScript();
            rScript.setUid(this.getScript_uid());
            rScript.setScript(this.getScript());
            stackFrame.setRscript(rScript);
            stackFrame.setQueue_uid(this.queue_uid);
            stackFrame.setStarted_time(new Date().getTime());
            stackFrame.addCallBack(new StackFrameCallBack(){

                @Override
                public void callBack(StackFrame stackFrame, String string, SchedulerException schedulerException) {
                    String string2 = null;
                    if (stackFrame.getRscript() != null) {
                        Object object;
                        String string3;
                        Object object2;
                        string2 = "<?xml version=\"1.0\"?><output status=\"" + string + "\" peer=\"" + P2PService.getComputerName() + "\">";
                        if (stackFrame.getRscript().getResultXML() != null) {
                            string2 = string2 + "<result>" + stackFrame.getRscript().getResultXML() + "</result>";
                        }
                        REXP rEXP = stackFrame.getRscript().getResult();
                        String string4 = "";
                        if (rEXP != null) {
                            object2 = rEXP.asVector();
                            string3 = "";
                            string3 = ServerExecuteScript.this.parse(rEXP, string3);
                            try {
                                string4 = ServerExecuteScript.this.parseJSON(rEXP, string4);
                            }
                            catch (Exception exception) {
                                String string5 = "Error while parsing to json";
                                ServerExecuteScript.this.log.error((Object)string5);
                                stackFrame.getRscript().setError(stackFrame.getRscript().getError() != null ? stackFrame.getRscript().getError() + ", " + string5 : " Error while parsing result to JSON ");
                            }
                            string2 = string2 + "<result>" + string3 + "</result>";
                        }
                        object2 = new SimpleDateFormat("d MMM yyyy HH:mm:ss SSS");
                        string3 = stackFrame.getRscript().getError() != null ? stackFrame.getRscript().getError() : "";
                        string2 = string2 + "<error>" + string3 + "</error>";
                        string2 = string2 + "<startedTime>" + ((DateFormat)object2).format(new Date(stackFrame.getStarted_time())) + "</startedTime>";
                        string2 = string2 + "<duration in=\"milliseconds\">" + (new Date().getTime() - stackFrame.getStarted_time()) + "</duration>";
                        string2 = string2 + "</output>";
                        try {
                            object = P2PService.getComputerName();
                            QueueStackManager.setStackIdle((String)object, stackFrame.getQueue_uid());
                        }
                        catch (Exception exception) {
                            ServerExecuteScript.this.log.error((Object)("error while settting queue stack idle,e:" + exception.getMessage()));
                        }
                        ServerExecuteScript.this.log.debug((Object)"script finished and call back, just before sending back to server");
                        object = new PeerScriptFinished();
                        ((PeerScriptFinished)object).setScript_uid(stackFrame.getRscript().getUid());
                        ((PeerScriptFinished)object).setQueue_uid(ServerExecuteScript.this.getQueue_uid());
                        ((PeerScriptFinished)object).setError(string3);
                        ((PeerScriptFinished)object).setResultxml(string2);
                        ((PeerScriptFinished)object).setStatus(string);
                        ((IOPeerRequest)object).send();
                    }
                }
            });
            this.log.debug((Object)("before executing script, task:" + scheduledTask));
            String string2 = ScheduledTask.EXCECUTION_FAIL;
            try {
                this.log.debug((Object)("just before executed task:" + scheduledTask.getClass().getName()));
                scheduledTask.execute(stackFrame);
                this.log.debug((Object)"just after executed task");
                string2 = ScheduledTask.EXCECUTION_SUCCESS;
            }
            catch (Exception exception) {
                this.log.error((Object)("error:::::" + exception.getMessage() + " task:" + scheduledTask + " getTaskuid():" + this.getTaskuid()));
                exception.printStackTrace();
                string2 = ScheduledTask.EXCECUTION_FAIL;
                ClientErrorMgmt.reportError(exception, null);
            }
            finally {
                if (stackFrame.getCallBack() != null) {
                    try {
                        stackFrame.getCallBack().callBack(stackFrame, string2, null);
                    }
                    catch (Exception exception) {
                        ClientErrorMgmt.reportError(exception, null);
                    }
                }
                this.log.debug((Object)"thread finised....");
            }
        }
        catch (Exception exception) {}
    }

    private String parse(REXP rEXP, String string) {
        Object object;
        if (rEXP.getType() == 16) {
            object = rEXP.asVector();
            for (Object e : object) {
                if (!(e instanceof REXP)) continue;
                string = string + this.parse((REXP)e, "");
            }
        }
        if (rEXP.getType() == 2) {
            string = string + "<double>" + rEXP.asDouble() + "</double>";
        }
        if (rEXP.getType() == 33) {
            object = rEXP.asDoubleArray();
            string = string + "<array>";
            for (int i = 0; i < ((RVector)object).length; ++i) {
                string = string + "<double>" + (double)object[i] + "</double>";
            }
            string = string + "</array>";
        }
        if (rEXP.getType() == 3) {
            string = string + "<string>" + rEXP.asString() + "</string>";
        }
        return string;
    }

    private String parseJSON(REXP rEXP, String string) throws Exception {
        Object object;
        Object object2;
        if (rEXP.getType() == 16) {
            object2 = rEXP.asVector();
            object = object2.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (!(e instanceof REXP)) continue;
                string = string + this.parseJSON((REXP)e, "");
            }
        }
        object2 = new JSONArray();
        if (rEXP.getType() == 2) {
            ((JSONArray)object2).put(rEXP.asDouble());
        }
        if (rEXP.getType() == 33) {
            object = rEXP.asDoubleArray();
            for (int i = 0; i < ((Object)object).length; ++i) {
                ((JSONArray)object2).put((double)object[i]);
            }
        }
        if (rEXP.getType() == 3) {
            ((JSONArray)object2).put(rEXP.asString());
        }
        return ((JSONArray)object2).toString();
    }
}

