/*
 * Decompiled with CFR 0.152.
 */
package com.fe.migrate.current;

import com.fe.client.MigrationMgmt;
import com.fe.data.Contract;
import com.fe.db.ContractDB;
import com.fe.db.SuperDB;
import com.fe.migrate.historical.HistoricalData;
import com.fe.xls.current.XLSCurrentReader;
import com.fe.xls.listener.CurrentRowListener;
import com.fe.xls.listener.CurrentSheetListener;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class CurrentData
implements CurrentRowListener,
CurrentSheetListener {
    protected MigrationMgmt clientGateway;
    private Logger log = Logger.getLogger(CurrentData.class);
    private ContractDB cdb = null;

    public CurrentData(MigrationMgmt migrationMgmt) {
        this.clientGateway = migrationMgmt;
    }

    public abstract String getFolder() throws Exception;

    public abstract String getArchiveFolder() throws Exception;

    public abstract String getDB() throws Exception;

    public abstract HistoricalData getHistoricalData() throws Exception;

    public File[] getFiles() throws Exception {
        return CurrentData.getFiles(this.getFolder());
    }

    protected ContractDB getContractDB() {
        return this.cdb;
    }

    public static File[] getFiles(String string) throws Exception {
        File file = new File(string);
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".xls");
            }
        });
        return fileArray;
    }

    @Override
    public boolean excecute(Date date, String string, Vector vector, int n) throws Exception {
        return true;
    }

    @Override
    public void sheetsBegin(String string, String[] stringArray) throws Exception {
        this.cdb = new SuperDB().getContractDB(null, this.getDB());
        this.cdb.connectDB(this.getDB());
    }

    @Override
    public void sheetsEnd() throws Exception {
        if (this.cdb != null) {
            this.cdb.closeDB();
        }
    }

    public void startProcess() throws Exception {
        this.log.debug((Object)"startProcess() called");
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                XLSCurrentReader xLSCurrentReader = new XLSCurrentReader(fileArray[i]);
                xLSCurrentReader.processFile(this, this);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyy");
                String string = this.getArchiveFolder() + simpleDateFormat.format(new Date());
                if (!new File(string).exists()) {
                    new File(string).mkdirs();
                }
                fileArray[i].renameTo(new File(string + File.separator + fileArray[i].getName()));
            }
        } else {
            throw new Exception("No source file found");
        }
    }

    @Override
    public boolean excecuteContinue(String string, String string2, Vector vector, int n) throws Exception {
        HistoricalData historicalData = this.getHistoricalData();
        historicalData.setCommodity(string);
        if (string2 != null && !string2.equals("")) {
            historicalData.createTable(string2);
            for (Contract contract : vector) {
            }
            this.log.debug((Object)("contracts:" + vector));
            historicalData.createRecord(this.getContractDB().connection(), string2, vector);
            return true;
        }
        return false;
    }
}

