/*
 * Decompiled with CFR 0.152.
 */
package com.fe.migrate.historical;

import com.fe.Config;
import com.fe.client.MigrationMgmt;
import com.fe.migrate.historical.HistoricalData;
import com.fe.xls.historical.XLSMarketHistoricalReader;
import com.fe.xls.listener.HistoricalRowListener;
import com.fe.xls.listener.HistoricalSheetListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HistoricalMarketData
extends HistoricalData
implements HistoricalRowListener,
HistoricalSheetListener {
    public HistoricalMarketData(MigrationMgmt migrationMgmt) {
        super(migrationMgmt);
    }

    @Override
    public void startProcess(boolean bl) throws Exception {
        this.setDuplicateCheck(bl);
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName().substring(0, fileArray[i].getName().lastIndexOf(46));
                this.setCommodity(string);
                XLSMarketHistoricalReader xLSMarketHistoricalReader = new XLSMarketHistoricalReader(fileArray[i]);
                xLSMarketHistoricalReader.processFile(this, this);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyy");
                String string2 = this.getArchiveFolder() + simpleDateFormat.format(new Date());
                if (!new File(string2).exists()) {
                    new File(string2).mkdirs();
                }
                fileArray[i].renameTo(new File(string2 + File.separator + fileArray[i].getName()));
            }
        } else {
            throw new Exception("No source file found");
        }
    }

    @Override
    public String getFolder() throws Exception {
        return Config.getString("xls_mkt_historical_folder");
    }

    @Override
    public String getArchiveFolder() throws Exception {
        return Config.getString("xls_mkt_historical_archive");
    }

    @Override
    public String getDB() throws Exception {
        return Config.getString("db_mkt_name");
    }
}

