/*
 * Decompiled with CFR 0.152.
 */
package com.fe.migrate.historical;

import com.fe.client.MigrationMgmt;
import com.fe.db.ContractDB;
import com.fe.db.SuperDB;
import com.fe.migrate.historical.HistoricalData;
import com.fe.xls.historical.XLStrgyContractHistoricalReader;
import com.fe.xls.listener.HistoricalRowListener;
import com.fe.xls.listener.HistoricalStrategySheetListener;
import java.io.File;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public abstract class HistoricalStrategyData
extends HistoricalData
implements HistoricalRowListener,
HistoricalStrategySheetListener {
    public HistoricalStrategyData(MigrationMgmt migrationMgmt) {
        super(migrationMgmt);
    }

    @Override
    public void startProcess(boolean bl) throws Exception {
        this.setDuplicateCheck(bl);
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                XLStrgyContractHistoricalReader xLStrgyContractHistoricalReader = new XLStrgyContractHistoricalReader(fileArray[i]);
                xLStrgyContractHistoricalReader.processFile(this, this);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyy");
                String string = this.getArchiveFolder() + simpleDateFormat.format(new Date());
                if (!new File(string).exists()) {
                    new File(string).mkdirs();
                }
                fileArray[i].renameTo(new File(string + File.separator + fileArray[i].getName()));
            }
        } else {
            throw new Exception("No source file found");
        }
    }

    @Override
    public void createRecord(Connection connection, String string, Vector vector) throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalStrategyData.resolvedColNameNoTrim(this.getCommodity()) + "_" + HistoricalStrategyData.resolvedColName(string), null);
        if (this.duplicateCheck) {
            contractDB.updateSValRecords(connection, vector);
        } else {
            contractDB.addSValRecords(connection, vector);
        }
    }

    @Override
    public void createTable(String string) throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(HistoricalStrategyData.resolvedColNameNoTrim(this.getCommodity()) + "_" + HistoricalStrategyData.resolvedColName(string), this.getDB());
        contractDB.connectDB(this.getDB());
        contractDB.updateMasterTable(contractDB.connection(), this.getCommodity(), string);
        contractDB.createSValTable(contractDB.connection(), 8);
        contractDB.closeDB();
    }
}

