/*
 * Decompiled with CFR 0.152.
 */
package com.fe.rhino;

import com.fe.Config;
import com.fe.ValueObject;
import com.fe.client.ClientErrorMgmt;
import com.fe.data.Contract;
import com.fe.db.ContractDB;
import com.fe.db.SuperDB;
import com.fe.migrate.historical.HistoricalMarketData;
import com.fe.rhino.DatabaseSelector;
import com.fe.scheduler.StackFrame;
import com.fe.xml.XMLRtrsContracts;
import com.fe.xml.XMLRtrsFields;
import com.fe.xml.XMLRtrsTickers;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class RtrsDownload
extends DatabaseSelector {
    private StackFrame stackframe = null;
    private String xmlfilename = null;
    private Calendar startdate;
    private Calendar enddate;
    private Vector fields = new Vector();
    private Vector tickers = new Vector();
    private String statuscontent = null;

    public RtrsDownload(StackFrame stackFrame) {
        this.stackframe = stackFrame;
    }

    public Calendar getStartdate() {
        return this.startdate;
    }

    public void setStartdate(Calendar calendar) {
        this.startdate = calendar;
    }

    public Calendar getEnddate() {
        return this.enddate;
    }

    public void setEnddate(Calendar calendar) {
        this.enddate = calendar;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getTickers() {
        return this.tickers;
    }

    public void addTicker(String string) {
        this.tickers.add(string);
    }

    public void addField(String string) {
        this.fields.add(string);
    }

    public void start() throws Exception {
        String string = Config.getString("rtrs_download_xml_reqfolder");
        this.xmlfilename = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        SmbFile smbFile = new SmbFile(string + this.xmlfilename + "_query.xml");
        SmbFileOutputStream smbFileOutputStream = new SmbFileOutputStream(smbFile);
        smbFileOutputStream.write(this.generateRequestXML().getBytes());
        smbFileOutputStream.close();
        Timer timer = new Timer();
        boolean bl = false;
        timer.scheduleAtFixedRate((TimerTask)new StatusCheck(this), 60000L, 60000L);
        while (!bl) {
            String string2 = Config.getString("rtrs_download_xml_resfolder");
            SmbFile smbFile2 = new SmbFile(string2 + this.xmlfilename + "_response.xml");
            if (smbFile2.isFile() && smbFile2.canWrite()) {
                SmbFileInputStream smbFileInputStream = new SmbFileInputStream(smbFile2);
                Vector vector = this.parseXML((InputStream)smbFileInputStream);
                if (vector != null && vector.size() == 0 || vector == null) {
                    SmbFileInputStream smbFileInputStream2 = new SmbFileInputStream(smbFile2);
                    Vector vector2 = this.parseErrorXML((InputStream)smbFileInputStream2);
                    if (vector2.size() > 0) {
                        ValueObject valueObject = (ValueObject)vector2.get(0);
                        this.stackframe.setTasklog("Status:" + valueObject.getKey() + " Msg:" + valueObject.getValue());
                        if (valueObject.getKey().equalsIgnoreCase("failed")) {
                            // empty if block
                        }
                        throw new Exception(valueObject.getValue());
                    }
                } else {
                    this.move2Database(vector);
                }
                bl = true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        timer.cancel();
    }

    private void move2Database(Vector vector) {
        String string = "";
        for (XMLRtrsTickers xMLRtrsTickers : vector) {
            for (XMLRtrsFields xMLRtrsFields : xMLRtrsTickers.getFields()) {
                Object object;
                Object object22;
                Vector<Object> vector2 = new Vector<Object>();
                for (Object object22 : xMLRtrsFields.getContracts()) {
                    try {
                        object = new Contract();
                        ((Contract)object).setValue(Double.parseDouble(((XMLRtrsContracts)object22).getVal()));
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/d/yyyy");
                        ((Contract)object).setCdate(simpleDateFormat.parse(((XMLRtrsContracts)object22).getCdate()));
                        ((Contract)object).setName(xMLRtrsTickers.getName());
                        vector2.add(object);
                    }
                    catch (Exception exception) {
                        Log.error((Object)("Error while parsing data:" + object22 + " error:" + exception.getMessage()));
                    }
                }
                String string2 = xMLRtrsFields.getName();
                object22 = HistoricalMarketData.resolvedColName(xMLRtrsTickers.getName()) + "_" + HistoricalMarketData.resolvedColName(string2);
                try {
                    object = new SuperDB().getContractDB((String)object22, this.db);
                    ((SuperDB)object).connectDB(this.db);
                    ((ContractDB)object).updateMasterTable(((SuperDB)object).connection(), xMLRtrsTickers.getName(), string2);
                    ((ContractDB)object).createTable(((SuperDB)object).connection(), 8);
                    ((ContractDB)object).updateRecords(((SuperDB)object).connection(), vector2);
                    ((SuperDB)object).closeDB();
                    string = string + "Ticker:" + xMLRtrsTickers.getName() + " # of Records:" + vector2.size() + " Field:" + (String)string2 + "\n";
                }
                catch (Exception exception) {
                    Log.error((Object)("Error while saving data error:" + exception.getMessage()));
                }
            }
        }
        if (this.stackframe != null && string != null && !string.equals("")) {
            this.stackframe.setTasklog(string);
        }
    }

    private String generateRequestXML() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/M/d");
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request>";
        string = string + "<startdate>" + simpleDateFormat.format(this.startdate.getTime()) + "</startdate><enddate>" + simpleDateFormat.format(this.enddate.getTime()) + "</enddate>";
        string = string + "<fields>";
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            string = string + "<field>" + iterator.next() + "</field>";
        }
        string = string + "</fields>";
        string = string + "<tickers>";
        iterator = this.tickers.iterator();
        while (iterator.hasNext()) {
            string = string + "<ticker>" + iterator.next() + "</ticker>";
        }
        string = string + "</tickers>";
        string = string + "</request>";
        return string;
    }

    private Vector parseXML(InputStream inputStream) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("response", Vector.class);
        digester.addSetProperties("response");
        digester.addObjectCreate("response/ticker", XMLRtrsTickers.class);
        digester.addSetProperties("response/ticker");
        digester.addSetNext("response/ticker", "add", "com.fe.xml.XMLRtrsTickers");
        digester.addObjectCreate("response/ticker/field", XMLRtrsFields.class);
        digester.addSetProperties("response/ticker/field");
        digester.addSetNext("response/ticker/field", "addField", "com.fe.xml.XMLRtrsFields");
        digester.addObjectCreate("response/ticker/field/set", XMLRtrsContracts.class);
        digester.addBeanPropertySetter("response/ticker/field/set/cdate");
        digester.addBeanPropertySetter("response/ticker/field/set/val");
        digester.addSetNext("response/ticker/field/set", "addContract");
        Vector vector = (Vector)digester.parse(inputStream);
        return vector;
    }

    private Vector parseErrorXML(InputStream inputStream) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("response", Vector.class);
        digester.addSetProperties("response");
        digester.addObjectCreate("response/status", ValueObject.class);
        digester.addSetProperties("response/status", "code", "key");
        digester.addSetProperties("response/status", "message", "value");
        digester.addSetNext("response/status", "add", "com.fe.ValueObject");
        Vector vector = (Vector)digester.parse(inputStream);
        return vector;
    }

    class StatusCheck
    extends TimerTask {
        private RtrsDownload rd;
        private String taskid;
        Logger log = Logger.getLogger(StatusCheck.class);

        public StatusCheck(RtrsDownload rtrsDownload2) {
            this.rd = rtrsDownload2;
        }

        private String generateStatusTimeoutXML() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/M/d");
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><response>";
            string = string + "<status code=\"failed\" message=\"No Response from XL Add-in, Timeout\"></status>";
            string = string + "</response>";
            return string;
        }

        @Override
        public void run() {
            try {
                String string;
                Object object;
                SmbFileInputStream smbFileInputStream;
                SmbFile smbFile;
                String string2;
                StringBuffer stringBuffer = null;
                boolean bl = false;
                try {
                    string2 = Config.getString("rtrs_download_xml_statusfolder");
                    smbFile = new SmbFile(string2 + this.rd.xmlfilename + "_status.xml");
                    smbFileInputStream = new SmbFileInputStream(smbFile);
                    object = new BufferedReader(new InputStreamReader((InputStream)smbFileInputStream));
                    stringBuffer = new StringBuffer();
                    while ((string = ((BufferedReader)object).readLine()) != null) {
                        stringBuffer.append(string);
                    }
                }
                catch (SmbException smbException) {
                    bl = true;
                }
                if (bl || stringBuffer != null && this.rd.statuscontent != null && this.rd.statuscontent.equals(stringBuffer.toString())) {
                    string2 = Config.getString("rtrs_download_xml_resfolder");
                    smbFile = new SmbFile(string2 + this.rd.xmlfilename + "_response.xml");
                    smbFileInputStream = new SmbFileOutputStream(smbFile);
                    smbFileInputStream.write(this.generateStatusTimeoutXML().getBytes());
                    smbFileInputStream.close();
                    object = Config.getString("rtrs_download_xml_reqfolder");
                    string = new SmbFile((String)object + this.rd.xmlfilename + "_query.xml");
                    string.delete();
                }
            }
            catch (Exception exception) {
                this.log.error((Object)("Error:" + exception.getMessage()));
                ClientErrorMgmt.reportError(exception, null);
            }
        }
    }
}

